/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.coreplugin;

import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.server.coreplugin.CorePluginsInjectingPropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.shared.WebClientConfigurationProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CorePlugin;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class JettyWebAppPluginInjector {
    private static final String WEBAPP_FOLDER = "webapp";
    private static final String START_PAGE = "start-page";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, JettyWebAppPluginInjector.class);
    private final List<String> webapps;
    private final Map<String, Properties> webappProperties;
    public static final String WEB_APP_FOLDER_PROPERTY = "webapp-folder";
    private Map<String, File> webappToFoldersMap;

    private static Map<String, Properties> extractWebappProperties(Properties props, List<String> webapps) {
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        for (String webapp : webapps) {
            Properties webappProperties = PropertyParametersUtil.extractSingleSectionProperties((Properties)props, (String)webapp, (boolean)false).getProperties();
            map.put(webapp, webappProperties);
        }
        return map;
    }

    public JettyWebAppPluginInjector(Properties props) {
        List appList = PropertyUtils.tryGetListInOriginalCase((Properties)props, (String)"webapps");
        this.webapps = null == appList ? Collections.emptyList() : appList;
        this.webappProperties = JettyWebAppPluginInjector.extractWebappProperties(props, this.webapps);
        this.webappToFoldersMap = new HashMap<String, File>();
        String corePluginsFolder = CorePluginsUtils.getCorePluginsFolder(props, CorePluginScanner.ScannerType.AS);
        CorePluginScanner scanner = new CorePluginScanner(corePluginsFolder, CorePluginScanner.ScannerType.AS);
        List<CorePlugin> plugins = scanner.scanForPlugins();
        block0: for (CorePlugin plugin : plugins) {
            File[] pluginFolders;
            File webappsFolder = new File(corePluginsFolder, CorePluginScanner.constructPath(plugin, CorePluginScanner.ScannerType.AS, CorePluginsInjectingPropertyPlaceholderConfigurer.PLUGIN_TYPE_WEBAPPS));
            if (!webappsFolder.isDirectory()) continue;
            for (File folder : pluginFolders = webappsFolder.listFiles()) {
                String webappName = folder.getName();
                if (webappName.startsWith(".")) continue;
                Properties webappProps = this.webappProperties.get(webappName);
                if (webappProps == null) continue block0;
                String f = webappProps.getProperty(WEB_APP_FOLDER_PROPERTY);
                this.webappToFoldersMap.put(webappName, new File(f));
            }
        }
    }

    public void injectWebApps() {
        List<String> remainingWebapps = this.replaceDefaultStartPageByWebApp();
        if (remainingWebapps.isEmpty()) {
            return;
        }
        operationLog.info((Object)("Inject the following web apps: " + remainingWebapps));
        List<File> targets = WebClientConfigurationProvider.findInjectionTargets();
        for (File target : targets) {
            File webappFolder = new File(target, WEBAPP_FOLDER);
            FileUtilities.deleteRecursively((File)webappFolder);
        }
        for (String webapp : remainingWebapps) {
            File folder = this.webappToFoldersMap.get(webapp);
            if (folder == null) continue;
            String path = folder.getAbsolutePath();
            for (File target : targets) {
                File webappFolder = new File(target, WEBAPP_FOLDER);
                webappFolder.mkdirs();
                File link = new File(webappFolder, webapp);
                if (link.exists()) {
                    try {
                        if (!folder.getCanonicalPath().equals(link.getCanonicalPath())) {
                            link.delete();
                        }
                    }
                    catch (Exception e) {
                        operationLog.error((Object)("WebApp '" + webapp + "': Problem managing Symbolic link "), (Throwable)e);
                    }
                }
                if (link.exists()) continue;
                String linkPath = link.getAbsolutePath();
                Unix.createSymbolicLink((String)path, (String)linkPath);
                operationLog.info((Object)("WebApp '" + webapp + "': Symbolic link " + linkPath + " -> " + path));
            }
        }
    }

    private List<String> replaceDefaultStartPageByWebApp() {
        ArrayList<String> remainingWebApps = new ArrayList<String>(this.webapps);
        if (!remainingWebApps.contains(START_PAGE)) {
            return remainingWebApps;
        }
        remainingWebApps.remove(START_PAGE);
        operationLog.info((Object)"Replace default start page by web app 'start-page'.");
        File webappFolder = this.webappToFoldersMap.get(START_PAGE);
        if (webappFolder != null) {
            for (File target : WebClientConfigurationProvider.findInjectionTargets()) {
                target.mkdirs();
                File folderCustom = new File(target, "custom");
                if (folderCustom.exists()) {
                    boolean success = FileUtilities.deleteRecursively((File)folderCustom);
                    if (success) {
                        operationLog.info((Object)(folderCustom.getAbsoluteFile() + " deleted."));
                    } else {
                        operationLog.error((Object)("Couldn't delete folder " + folderCustom.getAbsolutePath() + "."));
                    }
                }
                Unix.createSymbolicLink((String)webappFolder.getAbsolutePath(), (String)folderCustom.getAbsolutePath());
                operationLog.info((Object)("Symbolic link: " + folderCustom.getAbsolutePath() + " -> " + webappFolder.getAbsolutePath()));
                File webappIndexFile = new File(webappFolder, "index.html");
                if (!webappIndexFile.exists()) continue;
                File indexFile = new File(target, "index.html");
                if (indexFile.exists()) {
                    boolean success = FileUtilities.delete((File)indexFile);
                    if (success) {
                        operationLog.info((Object)(indexFile.getAbsolutePath() + " deleted."));
                    } else {
                        operationLog.error((Object)("Couldn't delete file " + indexFile.getAbsolutePath() + "."));
                    }
                }
                Unix.createSymbolicLink((String)webappIndexFile.getAbsolutePath(), (String)indexFile.getAbsolutePath());
                operationLog.info((Object)("Symbolic link: " + indexFile.getAbsolutePath() + " -> " + webappIndexFile.getAbsolutePath()));
            }
        }
        return remainingWebApps;
    }
}

