/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.dbmigration.DatabaseEngine;
import ch.systemsx.cisd.dbmigration.MonitoringDataSource;
import ch.systemsx.cisd.dbmigration.SimpleDatabaseConfigurationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataSourceProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDataSourceManager;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSourceDefinition;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSourceWithDefinition;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.util.IDataSourceFactory;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;

public class DataStoreServerBasedDataSourceProvider
implements IDataSourceProvider,
IDataStoreDataSourceManager,
InitializingBean {
    public static final String ROOT_KEY = "dss-based-data-source-provider";
    public static final String DATA_STORE_SERVERS_KEY = "data-store-servers";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataStoreServerBasedDataSourceProvider.class);
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;
    private Map<String, DataSource> dataSourcesByKey = new HashMap<String, DataSource>();
    private Map<Mapping, DataSource> dataSourcesByMapping = new HashMap<Mapping, DataSource>();
    private Map<String, Properties> configParametersByKeys = new HashMap<String, Properties>();
    private final IDAOFactory daoFactory;
    private final MappingManager mappingManager;
    private final IDataSourceFactory dataSourceFactory;

    public DataStoreServerBasedDataSourceProvider(IDAOFactory daoFactory, String dssDataSourceMappingFilePath) {
        this(daoFactory, dssDataSourceMappingFilePath, new IDataSourceFactory(){

            @Override
            public DataSourceWithDefinition create(Properties props) {
                return new DataSourceWithDefinition(new SimpleDatabaseConfigurationContext(props).getDataSource(), null);
            }
        });
    }

    DataStoreServerBasedDataSourceProvider(IDAOFactory daoFactory, String dssDataSourceMappingFilePath, IDataSourceFactory dataSourceFactory) {
        this.daoFactory = daoFactory;
        this.dataSourceFactory = dataSourceFactory;
        this.mappingManager = new MappingManager(dssDataSourceMappingFilePath);
    }

    public void afterPropertiesSet() throws Exception {
        this.init((Properties)ExtendedProperties.getSubset((Properties)this.configurer.getResolvedProps(), (String)"dss-based-data-source-provider.", (boolean)true));
    }

    void init(Properties props) {
        PropertyParametersUtil.SectionProperties[] sectionsProperties;
        for (PropertyParametersUtil.SectionProperties sectionProperties : sectionsProperties = PropertyParametersUtil.extractSectionProperties((Properties)props, (String)DATA_STORE_SERVERS_KEY, (boolean)false)) {
            String key = sectionProperties.getKey().toUpperCase();
            this.configParametersByKeys.put(key, sectionProperties.getProperties());
        }
        this.mappingManager.init(this.configParametersByKeys);
        HashMap<String, List<DataSourceDefinition>> originalDataSourceDefinitions = new HashMap<String, List<DataSourceDefinition>>();
        List<DataStorePE> dataStores = this.daoFactory.getDataStoreDAO().listDataStores();
        for (DataStorePE dataStorePE : dataStores) {
            String code = dataStorePE.getCode();
            List<DataSourceDefinition> definitions = DataSourceDefinition.listFromString(dataStorePE.getSerializedDataSourceDefinitions());
            originalDataSourceDefinitions.put(code, definitions);
        }
        for (Map.Entry entry : originalDataSourceDefinitions.entrySet()) {
            String dataStoreCode = (String)entry.getKey();
            this.mappingManager.handle(dataStoreCode, (List)entry.getValue());
            this.clearDataSourceCaches(dataStoreCode);
        }
    }

    @Override
    public synchronized DataSource getDataSourceByDataStoreServerCode(String dssCode, String technology) {
        String normalizedDssCode = dssCode.toUpperCase();
        String moduleCode = technology.toUpperCase();
        String key = normalizedDssCode + "[" + moduleCode + "]";
        DataSource dataSource = this.dataSourcesByKey.get(key);
        if (dataSource == null) {
            dataSource = this.createDataSource(normalizedDssCode, moduleCode);
            this.dataSourcesByKey.put(key, dataSource);
        }
        return dataSource;
    }

    private DataSource createDataSource(String dataStoreCode, String moduleCode) {
        Mapping mapping = this.mappingManager.getMapping(dataStoreCode, moduleCode);
        DataSource dataSource = this.dataSourcesByMapping.get(mapping);
        if (dataSource == null) {
            dataSource = this.createDataSource(mapping);
            this.dataSourcesByMapping.put(mapping, dataSource);
        }
        return dataSource;
    }

    private DataSource createDataSource(Mapping mapping) {
        Properties properties = this.configParametersByKeys.get(mapping.configKey);
        if (properties == null) {
            throw new ConfigurationFailureException("No data source configured for '" + mapping.configKey + "'.");
        }
        properties = ExtendedProperties.createWith((Properties)properties);
        DataSourceDefinition definitionOrNull = mapping.definitionOrNull;
        Properties props = this.createMergedProperties(properties, definitionOrNull);
        return this.dataSourceFactory.create(props).getDataSource();
    }

    private Properties createMergedProperties(Properties properties, DataSourceDefinition definitionOrNull) {
        ExtendedProperties props = ExtendedProperties.createWith((Properties)properties);
        if (definitionOrNull != null) {
            String driverClassName = definitionOrNull.getDriverClassName();
            this.setProperty((Properties)props, "database-driver", driverClassName);
            this.setProperty((Properties)props, "database-username", definitionOrNull.getUsername());
            this.setProperty((Properties)props, "database-password", definitionOrNull.getPassword());
            String sid = definitionOrNull.getSid();
            if (properties.getProperty("database-url") == null && driverClassName != null && sid != null) {
                DatabaseEngine engine = DatabaseEngine.getEngineForDriverClass((String)driverClassName);
                String url = engine.getURL(definitionOrNull.getHostPart(), sid);
                props.setProperty("database-url", url);
            }
        }
        return props;
    }

    private void setProperty(Properties properties, String key, String valueOrNull) {
        if (properties.getProperty(key) == null && valueOrNull != null) {
            properties.setProperty(key, valueOrNull);
        }
    }

    @Override
    public synchronized void handle(String dataStoreCode, List<DataSourceDefinition> dataSourceDefinitions) {
        IDataStoreDAO dataStoreDAO = this.daoFactory.getDataStoreDAO();
        DataStorePE dataStore = dataStoreDAO.tryToFindDataStoreByCode(dataStoreCode);
        if (dataStore == null) {
            throw new EnvironmentFailureException("Unknown data store: " + dataStoreCode);
        }
        this.assertMandatoryAttributesDefined(dataSourceDefinitions);
        dataStore.setSerializedDataSourceDefinitions(DataSourceDefinition.toString(dataSourceDefinitions));
        dataStoreDAO.createOrUpdateDataStore(dataStore);
        this.mappingManager.handle(dataStoreCode, dataSourceDefinitions);
        this.clearDataSourceCaches(dataStoreCode);
    }

    private void clearDataSourceCaches(String dataStoreCode) {
        LinkedList<Map.Entry<Mapping, DataSource>> entries = new LinkedList<Map.Entry<Mapping, DataSource>>(this.dataSourcesByMapping.entrySet());
        this.dataSourcesByMapping.clear();
        for (Map.Entry entry : entries) {
            Mapping mapping = (Mapping)entry.getKey();
            DataSource dataSource = (DataSource)entry.getValue();
            if (dataStoreCode.equals(mapping.dataStoreCode)) {
                if (!(dataSource instanceof MonitoringDataSource)) continue;
                try {
                    ((MonitoringDataSource)dataSource).close();
                }
                catch (SQLException ex) {
                    DataSourceDefinition definition = mapping.definitionOrNull;
                    if (definition == null) {
                        operationLog.warn((Object)("Couldn't close data source for " + mapping.configKey + "."));
                        continue;
                    }
                    operationLog.warn((Object)("Couldn't close data source for database " + definition.getSid() + " on " + dataStoreCode + "."));
                }
                continue;
            }
            this.dataSourcesByMapping.put(mapping, dataSource);
        }
        this.dataSourcesByKey.clear();
    }

    private void assertMandatoryAttributesDefined(List<DataSourceDefinition> definitions) {
        StringBuilder errors = new StringBuilder();
        for (DataSourceDefinition definition : definitions) {
            String error;
            String driverClassName;
            CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
            if (StringUtils.isBlank((CharSequence)definition.getCode())) {
                builder.append((Object)"code");
            }
            if (StringUtils.isBlank((CharSequence)definition.getSid())) {
                builder.append((Object)"sid");
            }
            if ((driverClassName = definition.getDriverClassName()) == null || !DatabaseEngine.hasEngineForDriverClass((String)driverClassName)) {
                builder.append((Object)"driverClassName");
            }
            if ((error = builder.toString()).length() <= 0) continue;
            errors.append("\n").append(error).append("\n[").append(definition).append("]");
        }
        if (errors.length() > 0) {
            throw new EnvironmentFailureException("Some data source definitions have missing or wrong mandatory attributes: " + errors);
        }
    }

    private static final class Mapping {
        private final String dataStoreCode;
        private final String configKey;
        private final DataSourceDefinition definitionOrNull;

        public Mapping(String dataStoreCode, String configKey, DataSourceDefinition definitionOrNull) {
            this.dataStoreCode = dataStoreCode;
            this.configKey = configKey;
            this.definitionOrNull = definitionOrNull;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Mapping)) {
                return false;
            }
            Mapping that = (Mapping)obj;
            return this.configKey.equals(that.configKey) && (this.definitionOrNull == null ? null == that.definitionOrNull : this.definitionOrNull.equals(that.definitionOrNull));
        }

        public int hashCode() {
            int sum = this.definitionOrNull == null ? 0 : this.definitionOrNull.hashCode();
            return 37 * sum + this.configKey.hashCode();
        }

        public String toString() {
            return this.configKey + "[" + (this.definitionOrNull == null ? "?" : this.definitionOrNull) + "]";
        }
    }

    private static final class MappingManager {
        private final String mappingFilePath;
        private List<MappingEntry> mappingEntries;
        private Map<String, Properties> configs;
        private Map<String, Map<String, DataSourceDefinition>> dataSourceDefinitionsByCodes = new HashMap<String, Map<String, DataSourceDefinition>>();

        public MappingManager(String mappingFilePath) {
            this.mappingFilePath = mappingFilePath;
        }

        public void init(Map<String, Properties> propertiesByKey) {
            this.mappingEntries = MappingManager.parse(this.mappingFilePath);
            this.configs = propertiesByKey;
        }

        private static List<MappingEntry> parse(String mappingFilePath) {
            ArrayList<MappingEntry> mappingEntries = new ArrayList<MappingEntry>();
            File file = new File(mappingFilePath);
            if (file.isFile()) {
                List lines = FileUtilities.loadToStringList((File)file);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < lines.size(); ++i) {
                    String line = (String)lines.get(i);
                    if (StringUtils.isBlank((CharSequence)line) || line.startsWith("#")) continue;
                    try {
                        mappingEntries.add(MappingManager.parseLine(line));
                        continue;
                    }
                    catch (Exception e) {
                        builder.append("\nLine ").append(i + 1).append(": ").append(e.getMessage());
                    }
                }
                if (builder.length() > 0) {
                    throw new ConfigurationFailureException("Error(s) in mapping file " + mappingFilePath + ":" + builder);
                }
            }
            return mappingEntries;
        }

        private static MappingEntry parseLine(String line) {
            int indexOfEqualSign = line.indexOf(61);
            if (indexOfEqualSign < 0) {
                throw new IllegalArgumentException("Missing '='");
            }
            String[] description = line.substring(0, indexOfEqualSign).trim().split("\\.");
            if (description.length != 3) {
                throw new IllegalArgumentException("Mapping description should have three parts separated by '.'");
            }
            Pattern dssCodePattern = MappingManager.createPattern(description[0].toUpperCase());
            Pattern dataSourceCodePattern = MappingManager.createPattern(description[1].toUpperCase());
            String type = description[2];
            String value = line.substring(indexOfEqualSign + 1).trim();
            return new MappingEntry(dssCodePattern, dataSourceCodePattern, type, value);
        }

        private static Pattern createPattern(String wildcardPattern) {
            String regex = wildcardPattern.replace("*", ".*");
            return Pattern.compile(regex);
        }

        public Mapping getMapping(String dataStoreCode, String moduleCode) {
            String configKey = dataStoreCode + "[" + moduleCode + "]";
            String dataSourceCode = null;
            EnumMap<Type, String> replacementsByType = new EnumMap<Type, String>(Type.class);
            block4: for (MappingEntry mappingEntry : this.mappingEntries) {
                String value = mappingEntry.value;
                if (!mappingEntry.matches(dataStoreCode, moduleCode) || value == null) continue;
                Type type = mappingEntry.type;
                switch (type) {
                    case CONFIG: {
                        configKey = value.replace("[*]", "[" + moduleCode + "]").replace("*", dataStoreCode);
                        continue block4;
                    }
                    case DATA_SOURCE: {
                        dataSourceCode = value;
                        continue block4;
                    }
                }
                replacementsByType.put(type, value);
            }
            DataSourceDefinition definition = this.getDefinitionsOrNull(dataStoreCode, dataSourceCode, replacementsByType);
            if (!this.configs.containsKey(configKey)) {
                if (!this.configs.containsKey(dataStoreCode)) {
                    throw new EnvironmentFailureException("Couldn't find data source core plugin '" + configKey + "' nor '" + dataStoreCode + "'.");
                }
                configKey = dataStoreCode;
            }
            return new Mapping(dataStoreCode, configKey, definition);
        }

        private DataSourceDefinition getDefinitionsOrNull(String dataStoreCode, String dataSourceCode, Map<Type, String> replacementsByType) {
            Map<String, DataSourceDefinition> definitionsByCode = this.dataSourceDefinitionsByCodes.get(dataStoreCode);
            if (definitionsByCode == null) {
                return null;
            }
            DataSourceDefinition definition = definitionsByCode.get(dataSourceCode);
            if (definition == null && definitionsByCode.size() == 1) {
                definition = definitionsByCode.values().iterator().next();
            }
            if (definition != null) {
                definition = definition.clone();
                Set<Map.Entry<Type, String>> entrySet = replacementsByType.entrySet();
                for (Map.Entry<Type, String> entry : entrySet) {
                    entry.getKey().modify(definition, entry.getValue());
                }
            }
            return definition;
        }

        public void handle(String dataStoreCode, List<DataSourceDefinition> dataSourceDefinitions) {
            Map<String, DataSourceDefinition> definitionsByCode = this.dataSourceDefinitionsByCodes.get(dataStoreCode);
            if (definitionsByCode == null) {
                definitionsByCode = new HashMap<String, DataSourceDefinition>();
                this.dataSourceDefinitionsByCodes.put(dataStoreCode, definitionsByCode);
            }
            for (DataSourceDefinition definition : dataSourceDefinitions) {
                definitionsByCode.put(definition.getCode(), definition);
            }
        }

        private static enum Type {
            HOST_PART("host-part"){

                @Override
                public void modify(DataSourceDefinition definition, String value) {
                    definition.setHostPart(value);
                }
            }
            ,
            USERNAME("username"){

                @Override
                public void modify(DataSourceDefinition definition, String value) {
                    definition.setUsername(value);
                }
            }
            ,
            PASSWORD("password"){

                @Override
                public void modify(DataSourceDefinition definition, String value) {
                    definition.setPassword(value);
                }
            }
            ,
            SID("sid"){

                @Override
                public void modify(DataSourceDefinition definition, String value) {
                    definition.setSid(value);
                }
            }
            ,
            CONFIG("config", true),
            DATA_SOURCE("data-source-code");

            private final String name;
            private final boolean valueInUpperCase;

            static Type getType(String typeName) {
                Type[] values = Type.values();
                CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
                for (Type type : values) {
                    if (type.name.equals(typeName)) {
                        return type;
                    }
                    builder.append((Object)type.name);
                }
                throw new IllegalArgumentException("Unknown type '" + typeName + "', possible values are: " + builder);
            }

            private Type(String name) {
                this(name, false);
            }

            private Type(String name, boolean valueInUpperCase) {
                this.name = name;
                this.valueInUpperCase = valueInUpperCase;
            }

            public void modify(DataSourceDefinition definition, String value) {
            }
        }

        private static final class MappingEntry {
            private final Pattern dssCodePattern;
            private final Pattern moduleCodePattern;
            private final Type type;
            private final String value;

            public MappingEntry(Pattern dssCodePattern, Pattern moduleCodePattern, String typeName, String value) {
                this.dssCodePattern = dssCodePattern;
                this.moduleCodePattern = moduleCodePattern;
                this.type = Type.getType(typeName);
                this.value = this.type.valueInUpperCase ? value.toUpperCase() : value;
            }

            public boolean matches(String dataStoreCode, String moduleCode) {
                if (!this.dssCodePattern.matcher(dataStoreCode).matches()) {
                    return false;
                }
                return this.moduleCodePattern.matcher(moduleCode).matches();
            }
        }
    }
}

