/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DynamicPropertyEvaluationOperation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final Set<Long> ids;
    private final boolean deletion;
    private boolean taken;

    public static DynamicPropertyEvaluationOperation evaluate(Class<? extends IEntityInformationWithPropertiesHolder> clazz, Collection<Long> ids) {
        return new DynamicPropertyEvaluationOperation(clazz, ids, false);
    }

    public static DynamicPropertyEvaluationOperation evaluateAll(Class<? extends IEntityInformationWithPropertiesHolder> clazz) {
        return new DynamicPropertyEvaluationOperation(clazz, null, false);
    }

    public static DynamicPropertyEvaluationOperation delete(Class<? extends IEntityInformationWithPropertiesHolder> clazz, Collection<Long> ids) {
        return new DynamicPropertyEvaluationOperation(clazz, ids, true);
    }

    private DynamicPropertyEvaluationOperation(Class<? extends IEntityInformationWithPropertiesHolder> clazz, Collection<Long> ids, boolean deletion) {
        this.className = clazz.getName();
        if (ids == null) {
            this.ids = null;
        } else {
            this.ids = new HashSet<Long>();
            this.ids.addAll(ids);
        }
        this.deletion = deletion;
    }

    public String getClassName() {
        return this.className;
    }

    public Set<Long> getIds() {
        return this.ids;
    }

    public boolean isDeletion() {
        return this.deletion;
    }

    public boolean isTaken() {
        return this.taken;
    }

    public void setTaken(boolean taken) {
        this.taken = taken;
    }

    public String toString() {
        return this.className + ": " + (this.ids == null ? "all" : CollectionUtils.abbreviate(this.ids, (int)10));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.ids == null ? 0 : this.ids.hashCode());
        result = 31 * result + (this.deletion ? 0 : 1);
        result = 31 * result + (this.taken ? 0 : 1);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicPropertyEvaluationOperation other = (DynamicPropertyEvaluationOperation)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.ids == null ? other.ids != null : !this.ids.equals(other.ids)) {
            return false;
        }
        if (other.deletion != this.deletion) {
            return false;
        }
        return other.taken == this.taken;
    }
}

