/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.collection.IToStringConverter;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPropertyValueValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import ch.systemsx.cisd.openbis.generic.shared.util.SimplePropertyValidator;
import ch.systemsx.cisd.openbis.generic.shared.util.XmlUtils;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

public final class PropertyValidator
implements IPropertyValueValidator {
    private static final SimplePropertyValidator simplePropertyValidator = new SimplePropertyValidator();

    private static final Map<DataTypeCode, IDataTypeValidator> createDataTypeValidators() {
        EnumMap<DataTypeCode, IDataTypeValidator> map = new EnumMap<DataTypeCode, IDataTypeValidator>(DataTypeCode.class);
        map.put(DataTypeCode.CONTROLLEDVOCABULARY, new ControlledVocabularyValidator());
        map.put(DataTypeCode.MATERIAL, new MaterialValidator());
        map.put(DataTypeCode.XML, new XmlValidator());
        map.put(DataTypeCode.SAMPLE, new SampleValidator());
        return map;
    }

    @Override
    public final String validatePropertyValue(PropertyTypePE propertyType, String value) throws UserFailureException {
        assert (propertyType != null) : "Unspecified property type.";
        assert (value != null) : "Unspecified value.";
        if (value.startsWith(BasicConstant.ERROR_PROPERTY_PREFIX)) {
            return value;
        }
        DataTypeCode entityDataType = propertyType.getType().getCode();
        if (simplePropertyValidator.canValidate(entityDataType)) {
            return simplePropertyValidator.validatePropertyValue(entityDataType, value);
        }
        IDataTypeValidator dataTypeValidator = PropertyValidator.createDataTypeValidators().get(entityDataType);
        assert (dataTypeValidator != null) : String.format("No IDataTypeValidator implementation specified for '%s'.", entityDataType);
        switch (entityDataType) {
            case CONTROLLEDVOCABULARY: {
                ((ControlledVocabularyValidator)dataTypeValidator).setVocabulary(propertyType.getVocabulary());
                break;
            }
            case MATERIAL: {
                ((MaterialValidator)dataTypeValidator).setMaterialType(propertyType.getMaterialType());
                break;
            }
            case XML: {
                ((XmlValidator)dataTypeValidator).setXmlSchema(propertyType.getSchema());
                ((XmlValidator)dataTypeValidator).setPropertyTypeLabel(propertyType.getLabel());
                break;
            }
        }
        return dataTypeValidator.validate(value);
    }

    private static final class XmlValidator
    implements IDataTypeValidator {
        private String xmlSchema;
        private String propertyTypeLabel;

        private XmlValidator() {
        }

        public void setXmlSchema(String xmlSchema) {
            this.xmlSchema = xmlSchema;
        }

        public void setPropertyTypeLabel(String label) {
            this.propertyTypeLabel = label;
        }

        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            Document document = XmlUtils.parseXmlDocument(value);
            if (this.xmlSchema != null) {
                try {
                    XmlUtils.validate(document, this.xmlSchema);
                }
                catch (Exception e) {
                    throw UserFailureException.fromTemplate((String)"Provided value doesn't validate against schema of property type '%s'. %s", (Object[])new Object[]{this.propertyTypeLabel, e.getMessage()});
                }
            }
            return value;
        }
    }

    private static final class MaterialValidator
    implements IDataTypeValidator {
        private MaterialTypePE materialTypeOrNull;

        private MaterialValidator() {
        }

        public void setMaterialType(MaterialTypePE materialType) {
            this.materialTypeOrNull = materialType;
        }

        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            MaterialIdentifier identifierOrNull = MaterialIdentifier.tryParseIdentifier(value);
            if (identifierOrNull == null) {
                if (this.materialTypeOrNull == null) {
                    throw UserFailureException.fromTemplate((String)"Material specification '%s' has improper format. Expected format is '<CODE> (<TYPE>)'. Type has to be specified because any type of material can be assigned.", (Object[])new Object[]{value});
                }
                return value;
            }
            if (this.materialTypeOrNull != null && !identifierOrNull.getTypeCode().equalsIgnoreCase(this.materialTypeOrNull.getCode())) {
                throw UserFailureException.fromTemplate((String)"Material '%s' is of wrong type. Expected: '%s'.", (Object[])new Object[]{value, this.materialTypeOrNull.getCode()});
            }
            return value;
        }
    }

    private static final class ControlledVocabularyValidator
    implements IDataTypeValidator {
        private VocabularyPE vocabulary;

        private ControlledVocabularyValidator() {
        }

        final void setVocabulary(VocabularyPE vocabulary) {
            this.vocabulary = vocabulary;
        }

        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            assert (this.vocabulary != null) : "Unspecified vocabulary.";
            String upperCaseValue = value.toUpperCase();
            this.vocabulary.tryGetVocabularyTerm(upperCaseValue);
            VocabularyTermPE termOrNull = this.vocabulary.tryGetVocabularyTerm(upperCaseValue);
            if (termOrNull != null) {
                return upperCaseValue;
            }
            throw UserFailureException.fromTemplate((String)"Vocabulary value '%s' is not valid. It must exist in '%s' controlled vocabulary %s", (Object[])new Object[]{upperCaseValue, this.vocabulary.getCode(), this.getVocabularyDetails()});
        }

        private final String getVocabularyDetails() {
            if (this.vocabulary.isChosenFromList()) {
                return CollectionUtils.abbreviate(this.vocabulary.getTerms(), (int)10, (IToStringConverter)new IToStringConverter<VocabularyTermPE>(){

                    public final String toString(VocabularyTermPE term) {
                        return term.getCode();
                    }
                });
            }
            String descriptionOrNull = this.vocabulary.getDescription();
            return descriptionOrNull == null ? "" : " - " + descriptionOrNull;
        }
    }

    private static final class SampleValidator
    implements IDataTypeValidator {
        private SampleValidator() {
        }

        @Override
        public String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            if (value.startsWith("/")) {
                // empty if block
            }
            return value;
        }
    }

    private static interface IDataTypeValidator {
        public String validate(String var1) throws UserFailureException;
    }
}

