/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.exceptions.ExceptionUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.DynamicPropertyEvaluationOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.util.UpdateUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.internal.StatelessSessionImpl;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public abstract class AbstractDAO
extends HibernateDaoSupport {
    private static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    private static final int MAX_STRING_ERROR_LENGTH = 500;

    protected AbstractDAO(SessionFactory sessionFactory) {
        assert (sessionFactory != null) : "Unspecified session factory";
        this.setSessionFactory(sessionFactory);
    }

    protected static final <E> void validatePE(E pe) throws DataIntegrityViolationException {
        Validator validator = factory.getValidator();
        Set violations = validator.validate(pe, new Class[0]);
        if (violations.size() > 0) {
            String msg = "";
            for (ConstraintViolation v : violations) {
                String invalidValue;
                String string = invalidValue = v.getInvalidValue() != null ? v.getInvalidValue().toString() : null;
                if (invalidValue != null && invalidValue.length() > 500) {
                    invalidValue = String.format("%s... (complete value was %d characters)", invalidValue.substring(0, 500), invalidValue.length());
                }
                msg = msg + ", " + String.format(v.getMessage(), invalidValue);
            }
            throw new DataIntegrityViolationException(msg.substring(2));
        }
    }

    protected static final <T> List<T> cast(List<?> list) {
        return list;
    }

    protected static final <T> T getEntity(List<T> entities) throws DataAccessException {
        return (T)DataAccessUtils.requiredSingleResult(entities);
    }

    protected static final <T> T getEntity(Object entity) throws EmptyResultDataAccessException {
        if (entity == null) {
            throw new EmptyResultDataAccessException(1);
        }
        return (T)entity;
    }

    protected static final <T> T tryGetEntity(Object entityOrNull) {
        return (T)(entityOrNull == null ? null : entityOrNull);
    }

    protected static final <T> T tryFindEntity(List<T> entities, String entitiesName, Object ... parameters) throws IncorrectResultSizeDataAccessException {
        int size = entities.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return entities.get(0);
            }
        }
        throw new IncorrectResultSizeDataAccessException(String.format("%d %s found for '%s'. Expected: 1 or 0.", size, entitiesName, parameters.length == 1 ? parameters[0] : Arrays.asList(parameters)), 1, size);
    }

    protected Date getTransactionTimeStamp() {
        return UpdateUtils.getTransactionTimeStamp(this.getSessionFactory());
    }

    protected final void executeUpdate(final String sql, final Serializable ... parameters) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) throws HibernateException {
                NativeQuery sqlQuery = session.createSQLQuery(sql);
                for (int i = 0; i < parameters.length; ++i) {
                    Serializable parameter = parameters[i];
                    if (parameter instanceof Long) {
                        sqlQuery.setLong(i, ((Long)parameter).longValue());
                        continue;
                    }
                    if (parameter instanceof Integer) {
                        sqlQuery.setInteger(i, ((Integer)parameter).intValue());
                        continue;
                    }
                    if (parameter instanceof Character) {
                        sqlQuery.setCharacter(i, ((Character)parameter).charValue());
                        continue;
                    }
                    if (parameter instanceof Date) {
                        sqlQuery.setDate(i, (Date)parameter);
                        continue;
                    }
                    sqlQuery.setSerializable(i, parameter);
                }
                sqlQuery.executeUpdate();
                return null;
            }
        });
    }

    protected final <T> T getUniqueResult(final String sql, final Object ... parameters) {
        return (T)this.getHibernateTemplate().execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) {
                return session.createSQLQuery(String.format(sql, parameters)).uniqueResult();
            }
        });
    }

    protected static final Object[] toArray(Object ... objects) {
        return objects;
    }

    protected final long getNextSequenceId(final String sequenceName) {
        Object result = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session sess) throws HibernateException {
                NativeQuery sqlQuery = sess.createSQLQuery("select nextval('" + sequenceName + "')");
                return sqlQuery.uniqueResult();
            }
        });
        Long toReturn = result instanceof BigInteger ? Long.valueOf(((BigInteger)result).longValue()) : (Long)result;
        return toReturn;
    }

    protected final Object executeStatelessAction(final StatelessHibernateCallback action) throws DataAccessException {
        assert (action != null);
        return this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public final Object doInHibernate(Session session) throws HibernateException {
                return session.doReturningWork((ReturningWork)new ReturningWork<Object>(){

                    public Object execute(Connection connection) throws SQLException {
                        StatelessSessionImpl sls = null;
                        try {
                            sls = (StatelessSessionImpl)AbstractDAO.this.getSessionFactory().openStatelessSession(connection);
                            return action.doInStatelessSession((StatelessSession)sls);
                        }
                        catch (HibernateException ex) {
                            throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex);
                        }
                    }
                });
            }
        });
    }

    protected void lockEntities(Collection<? extends IIdHolder> entitiesOrNull) {
        if (entitiesOrNull == null) {
            return;
        }
        for (IIdHolder iIdHolder : entitiesOrNull) {
            this.lockEntity(iIdHolder);
        }
    }

    protected void lockEntity(IIdHolder entityOrNull) {
        if (entityOrNull != null && entityOrNull.getId() != null && this.currentSession().contains((Object)entityOrNull)) {
            this.getHibernateTemplate().lock((Object)entityOrNull, LockMode.PESSIMISTIC_WRITE);
        }
    }

    protected static void flushWithSqlExceptionHandling(HibernateTemplate hibernateTemplate) throws DataAccessException {
        try {
            hibernateTemplate.flush();
        }
        catch (UncategorizedSQLException e) {
            AbstractDAO.translateUncategorizedSQLException(e);
        }
    }

    protected static void translateUncategorizedSQLException(UncategorizedSQLException exception) throws DataAccessException {
        SQLException sqlExceptionOrNull = (SQLException)ExceptionUtils.tryGetThrowableOfClass((Throwable)exception, SQLException.class);
        if (sqlExceptionOrNull != null && sqlExceptionOrNull.getNextException() != null) {
            throw new DataIntegrityViolationException(sqlExceptionOrNull.getNextException().getMessage());
        }
        throw exception;
    }

    protected static Set<TechId> transformNumbers2TechIdSet(Collection<? extends Number> numbers) {
        HashSet<TechId> result = new HashSet<TechId>();
        for (Number number : numbers) {
            result.add(new TechId(number));
        }
        return result;
    }

    protected static List<TechId> transformNumbers2TechIdList(Collection<? extends Number> numbers) {
        ArrayList<TechId> result = new ArrayList<TechId>();
        for (Number number : numbers) {
            result.add(new TechId(number));
        }
        return result;
    }

    protected static <T extends IEntityInformationWithPropertiesHolder> List<Long> transformEntities2Longs(Collection<T> entities) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (IEntityInformationWithPropertiesHolder entity : entities) {
            result.add(entity.getId());
        }
        return result;
    }

    protected static <T extends IEntityInformationWithPropertiesHolder> void scheduleDynamicPropertiesEvaluationWithIds(IDynamicPropertyEvaluationScheduler scheduler, Class<T> entityClass, List<Long> ids) {
        AbstractDAO.scheduleDynamicPropertiesEvaluationForIds(scheduler, entityClass, ids);
    }

    protected static <T extends IEntityInformationWithPropertiesHolder> void scheduleDynamicPropertiesEvaluation(IDynamicPropertyEvaluationScheduler scheduler, Class<T> entityClass, List<T> entities) {
        List<Long> ids = AbstractDAO.transformEntities2Longs(entities);
        AbstractDAO.scheduleDynamicPropertiesEvaluationForIds(scheduler, entityClass, ids);
    }

    protected static <T extends IEntityInformationWithPropertiesHolder> void scheduleDynamicPropertiesEvaluationForIds(IDynamicPropertyEvaluationScheduler scheduler, Class<T> entityClass, List<Long> entityIds) {
        scheduler.scheduleUpdate(DynamicPropertyEvaluationOperation.evaluate(entityClass, entityIds));
    }

    public void flush() {
        AbstractDAO.flushWithSqlExceptionHandling(this.getHibernateTemplate());
    }

    public void clear() {
        this.getHibernateTemplate().clear();
    }

    protected static final <T> Class<T> cast(Class<?> clazz) {
        return clazz;
    }

    protected static interface StatelessHibernateCallback {
        public Object doInStatelessSession(StatelessSession var1);
    }
}

