/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IGenericDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.orm.hibernate5.HibernateTemplate;

public abstract class AbstractGenericEntityDAO<T extends IIdHolder>
extends AbstractDAO
implements IGenericDAO<T> {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AbstractGenericEntityDAO.class);
    private final Class<T> entityClass;
    protected final EntityHistoryCreator historyCreator;

    protected AbstractGenericEntityDAO(SessionFactory sessionFactory, Class<T> entityClass, EntityHistoryCreator historyCreator) {
        super(sessionFactory);
        this.entityClass = entityClass;
        this.historyCreator = historyCreator;
    }

    protected Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public final T getByTechId(TechId techId) throws DataAccessException {
        assert (techId != null) : "Technical identifier unspecified.";
        Object entity = this.getHibernateTemplate().get(this.getEntityClass(), (Serializable)techId.getId());
        IIdHolder result = null;
        if (entity == null) {
            throw new DataRetrievalFailureException(this.getEntityDescription() + " with ID " + techId.getId() + " does not exist. Maybe someone has just deleted it.");
        }
        result = (IIdHolder)AbstractGenericEntityDAO.getEntity(entity);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): '%s'.", MethodUtils.getCurrentMethod().getName(), techId, result));
        }
        return (T)result;
    }

    public final T loadByTechId(TechId techId) throws DataAccessException {
        assert (techId != null) : "Technical identifier unspecified.";
        return (T)((IIdHolder)AbstractGenericEntityDAO.getEntity(this.getHibernateTemplate().load(this.getEntityClass(), (Serializable)techId.getId())));
    }

    private String getEntityDescription() {
        String nameWithoutPE = this.getEntityClass().getSimpleName().replace("PE", "");
        Object[] words = StringUtils.splitByCharacterTypeCamelCase((String)nameWithoutPE);
        return StringUtils.join((Object[])words, (String)" ");
    }

    @Override
    public final T tryGetByTechId(TechId techId, String ... connections) throws DataAccessException {
        assert (techId != null) : "Technical identifier unspecified.";
        Criteria criteria = this.currentSession().createCriteria(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)techId.getId()));
        for (String connection : connections) {
            criteria.setFetchMode(connection, FetchMode.SELECT);
        }
        IIdHolder result = (IIdHolder)AbstractGenericEntityDAO.tryGetEntity(criteria.uniqueResult());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): '%s'.", MethodUtils.getCurrentMethod().getName(), techId, result));
        }
        return (T)result;
    }

    protected <T> List<T> listByIDsOfName(Class<T> clazz, String idName, Collection<?> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList();
        }
        List list = DAOUtils.listByCollection(this.getHibernateTemplate(), clazz, idName, ids);
        if (operationLog.isDebugEnabled()) {
            String name = clazz.getSimpleName();
            if (name.endsWith("PE")) {
                name = name.substring(0, name.length() - 2);
            }
            operationLog.debug((Object)String.format("%d " + name.toLowerCase() + "(s) have been found.", list.size()));
        }
        return list;
    }

    @Override
    public void validateAndSaveUpdatedEntity(T entity) throws DataAccessException {
        assert (entity != null) : "entity is null";
        AbstractGenericEntityDAO.validatePE(entity);
        AbstractGenericEntityDAO.flushWithSqlExceptionHandling(this.getHibernateTemplate());
    }

    @Override
    public final void validate(T entity) {
        assert (entity != null) : "entity is null";
        AbstractGenericEntityDAO.validatePE(entity);
    }

    public void clearSession() {
        this.getHibernateTemplate().clear();
    }

    @Override
    public final void flush() {
        this.getHibernateTemplate().flush();
    }

    @Override
    public void persist(T entity) {
        assert (entity != null) : "entity unspecified";
        AbstractGenericEntityDAO.validatePE(entity);
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        hibernateTemplate.save(entity);
        hibernateTemplate.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.debug((Object)String.format("%s(%s)", MethodUtils.getCurrentMethod().getName(), entity));
        }
    }

    @Override
    public void delete(T entity) throws DataAccessException {
        assert (entity != null) : "entity unspecified";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        hibernateTemplate.delete(entity);
        hibernateTemplate.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.debug((Object)String.format("%s(%s)", MethodUtils.getCurrentMethod().getName(), entity));
        }
    }

    @Override
    public List<T> listAllEntities() throws DataAccessException {
        return AbstractGenericEntityDAO.cast(this.getHibernateTemplate().loadAll(this.getEntityClass()));
    }
}

