/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractTypePE;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;

abstract class AbstractTypeDAO<T extends AbstractTypePE>
extends AbstractGenericEntityDAO<T> {
    private final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, this.getClass());

    public AbstractTypeDAO(SessionFactory sessionFactory, Class<T> entityClass, EntityHistoryCreator historyCreator) {
        super(sessionFactory, entityClass, historyCreator);
    }

    final T tryFindTypeByCode(String code) throws DataAccessException {
        return this.tryFindTypeByCode(code, true);
    }

    final T tryFindTypeByCode(String code, boolean appendDatabaseInstance) throws DataAccessException {
        assert (code != null) : "Unspecified code";
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(code)));
        List list = AbstractTypeDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        AbstractTypePE entity = (AbstractTypePE)AbstractTypeDAO.tryFindEntity(list, "type", new Object[0]);
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)String.format("%s(%s,%s): Entity type '%s' has been found.", MethodUtils.getCurrentMethod().getName(), code, appendDatabaseInstance, entity));
        }
        return (T)entity;
    }

    final List<T> tryFindTypeByCodes(List<String> codes, boolean appendDatabaseInstance) throws DataAccessException {
        assert (codes != null) : "Unspecified codes";
        ArrayList<String> dbCodes = new ArrayList<String>(codes.size());
        for (String code : codes) {
            dbCodes.add(CodeConverter.tryToDatabase(code));
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.add(Restrictions.in((String)"code", dbCodes));
        List list = AbstractTypeDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)String.format("%s(): %d entity type(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    final List<T> listTypes() throws DataAccessException {
        return this.listTypes(true);
    }

    final List<T> listTypes(boolean appendDatabaseInstance) throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        List list = AbstractTypeDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)String.format("%s(%s): %d entity type(s) have been found.", MethodUtils.getCurrentMethod().getName(), appendDatabaseInstance, list.size()));
        }
        return list;
    }

    protected void createOrUpdateType(T type) {
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        AbstractTypeDAO.validatePE(type);
        ((AbstractTypePE)type).setCode(CodeConverter.tryToDatabase(((AbstractTypePE)type).getCode()));
        hibernateTemplate.saveOrUpdate(type);
        hibernateTemplate.flush();
        if (this.operationLog.isInfoEnabled()) {
            this.operationLog.info((Object)String.format("ADD/UPDATE: type '%s'.", type));
        }
    }
}

