/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDeletionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IGridCustomColumnDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IGridCustomFilterDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IMetaprojectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IQueryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRelationshipTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRoleAssignmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISpaceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DeletionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.ExperimentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.GridCustomColumnDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.GridCustomFilterDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.MetaprojectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.PersonDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.ProjectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.QueryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.RelationshipTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.RoleAssignmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.SampleDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.SpaceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class AuthorizationDAOFactory
implements IAuthorizationDAOFactory {
    private final IAuthorizationConfig authorizationConfig;
    private final IRoleAssignmentDAO roleAssignmentDAO;
    private final ISpaceDAO groupDAO;
    private final IPersonDAO personDAO;
    private final IDataDAO dataDAO;
    private final IExperimentDAO experimentDAO;
    private final IProjectDAO projectDAO;
    private final ISampleDAO sampleDAO;
    private final IGridCustomFilterDAO gridCustomFilterDAO;
    private final IGridCustomColumnDAO gridCustomColumnDAO;
    private final QueryDAO queryDAO;
    private final PersistencyResources persistencyResources;
    private final IRelationshipTypeDAO relationshipTypeDAO;
    private final IDeletionDAO deletionDAO;
    private final IMetaprojectDAO metaprojectDAO;

    public AuthorizationDAOFactory(DatabaseConfigurationContext context, SessionFactory sessionFactory, IDynamicPropertyEvaluationScheduler dynamicPropertyEvaluationScheduler, EntityHistoryCreator historyCreator, IAuthorizationConfig authorizationConfig) {
        this.persistencyResources = new PersistencyResources(context, sessionFactory, dynamicPropertyEvaluationScheduler);
        this.personDAO = new PersonDAO(sessionFactory, historyCreator);
        this.groupDAO = new SpaceDAO(sessionFactory, historyCreator);
        this.roleAssignmentDAO = new RoleAssignmentDAO(sessionFactory, historyCreator);
        this.relationshipTypeDAO = new RelationshipTypeDAO(sessionFactory, historyCreator);
        this.dataDAO = new DataDAO(this.persistencyResources, this.relationshipTypeDAO, historyCreator);
        this.experimentDAO = new ExperimentDAO(this.persistencyResources, historyCreator);
        this.projectDAO = new ProjectDAO(sessionFactory, historyCreator);
        this.sampleDAO = new SampleDAO(this.persistencyResources, historyCreator);
        this.gridCustomFilterDAO = new GridCustomFilterDAO(sessionFactory, historyCreator);
        this.gridCustomColumnDAO = new GridCustomColumnDAO(sessionFactory, historyCreator);
        this.queryDAO = new QueryDAO(sessionFactory, historyCreator);
        this.deletionDAO = new DeletionDAO(sessionFactory, this.persistencyResources, historyCreator);
        this.metaprojectDAO = new MetaprojectDAO(sessionFactory, historyCreator);
        this.authorizationConfig = authorizationConfig;
    }

    @Override
    public final PersistencyResources getPersistencyResources() {
        return this.persistencyResources;
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.persistencyResources.getSessionFactory();
    }

    @Override
    public final ISpaceDAO getSpaceDAO() {
        return this.groupDAO;
    }

    @Override
    public final IPersonDAO getPersonDAO() {
        return this.personDAO;
    }

    @Override
    public final IRoleAssignmentDAO getRoleAssignmentDAO() {
        return this.roleAssignmentDAO;
    }

    @Override
    public final IDataDAO getDataDAO() {
        return this.dataDAO;
    }

    @Override
    public final IExperimentDAO getExperimentDAO() {
        return this.experimentDAO;
    }

    @Override
    public final IProjectDAO getProjectDAO() {
        return this.projectDAO;
    }

    @Override
    public final ISampleDAO getSampleDAO() {
        return this.sampleDAO;
    }

    @Override
    public IGridCustomFilterDAO getGridCustomFilterDAO() {
        return this.gridCustomFilterDAO;
    }

    @Override
    public IGridCustomColumnDAO getGridCustomColumnDAO() {
        return this.gridCustomColumnDAO;
    }

    @Override
    public IQueryDAO getQueryDAO() {
        return this.queryDAO;
    }

    @Override
    public IRelationshipTypeDAO getRelationshipTypeDAO() {
        return this.relationshipTypeDAO;
    }

    @Override
    public IDeletionDAO getDeletionDAO() {
        return this.deletionDAO;
    }

    @Override
    public IMetaprojectDAO getMetaprojectDAO() {
        return this.metaprojectDAO;
    }

    @Override
    public IAuthorizationConfig getAuthorizationConfig() {
        return this.authorizationConfig;
    }

    @Override
    public void setBatchUpdateMode(boolean batchMode) {
        SessionFactory sessionFactory = this.persistencyResources.getSessionFactory();
        Session currentSession = sessionFactory.getCurrentSession();
        HibernateUtils.setBatchUpdateMode(currentSession, batchMode);
    }
}

