/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationGroupDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class AuthorizationGroupDAO
extends AbstractGenericEntityDAO<AuthorizationGroupPE>
implements IAuthorizationGroupDAO {
    public static final Class<AuthorizationGroupPE> ENTITY_CLASS = AuthorizationGroupPE.class;
    private static final String TABLE_NAME = ENTITY_CLASS.getSimpleName();
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AuthorizationGroupDAO.class);

    protected AuthorizationGroupDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, ENTITY_CLASS, historyCreator);
    }

    @Override
    public List<AuthorizationGroupPE> list() {
        List<AuthorizationGroupPE> list = AuthorizationGroupDAO.cast(this.getHibernateTemplate().find(String.format("from %s a", TABLE_NAME), new Object[0]));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d authorization group(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public List<AuthorizationGroupPE> listByIds(Collection<Long> ids) {
        return this.listByIDsOfName(AuthorizationGroupPE.class, "id", ids);
    }

    @Override
    public List<AuthorizationGroupPE> listByCodes(Collection<String> ids) {
        return this.listByIDsOfName(AuthorizationGroupPE.class, "code", ids);
    }

    @Override
    public void create(AuthorizationGroupPE authorizationGroup) {
        assert (authorizationGroup != null) : "Missing authorization group.";
        AuthorizationGroupDAO.validatePE(authorizationGroup);
        authorizationGroup.setCode(CodeConverter.tryToDatabase(authorizationGroup.getCode()));
        HibernateTemplate template = this.getHibernateTemplate();
        template.saveOrUpdate((Object)authorizationGroup);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("SAVE: authorization group '%s'.", authorizationGroup));
        }
    }

    @Override
    public AuthorizationGroupPE tryFindByCode(String code) {
        Criteria criteria = this.currentSession().createCriteria(ENTITY_CLASS);
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(code)));
        return (AuthorizationGroupPE)criteria.uniqueResult();
    }
}

