/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.openbis.common.spring.SpringEoDSQLExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAttachmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationGroupDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ICorePluginDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataSetTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityHistoryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityOperationsLogDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEventDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEventsSearchDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExternalDataManagementSystemDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IFileFormatTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IHibernateSearchDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ILocatorTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IMaterialDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IOperationExecutionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPostRegistrationDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IScriptDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISemanticAnnotationDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyTermDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AttachmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AuthorizationGroupDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.CodeSequenceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.CorePluginDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DataSetTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DataStoreDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EntityHistoryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EntityOperationsLogDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EntityPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EntityTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EventDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EventsSearchDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.ExternalDataManagementSystemDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.FileFormatTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.HibernateSearchDAOV3Adaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.ICodeSequenceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IPermIdDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.LocatorTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.MaterialDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.OperationExecutionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.PermIdDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.PostRegistrationDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.PropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.SampleTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.ScriptDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.SemanticAnnotationDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.VocabularyDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.VocabularyTermDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.util.UpdateUtils;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.InitializingBean;

public final class DAOFactory
extends AuthorizationDAOFactory
implements IDAOFactory,
InitializingBean {
    private static Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DAOFactory.class);
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;
    private final IDynamicPropertyEvaluationScheduler dynamicPropertyEvaluationScheduler;
    private final ISampleTypeDAO sampleTypeDAO;
    private final IHibernateSearchDAO hibernateSearchDAO;
    private final IPropertyTypeDAO propertyTypeDAO;
    private final Map<EntityKind, IEntityTypeDAO> entityTypeDAOs = new HashMap<EntityKind, IEntityTypeDAO>();
    private final Map<EntityKind, IEntityPropertyTypeDAO> entityPropertyTypeDAOs = new HashMap<EntityKind, IEntityPropertyTypeDAO>();
    private final IVocabularyDAO vocabularyDAO;
    private final IVocabularyTermDAO vocabularyTermDAO;
    private final IAttachmentDAO attachmentDAO;
    private final DataSetTypeDAO dataSetTypeDAO;
    private final FileFormatTypeDAO fileFormatTypeDAO;
    private final LocatorTypeDAO locatorTypeDAO;
    private final IMaterialDAO materialDAO;
    private final ICodeSequenceDAO codeSequenceDAO;
    private final IDataStoreDAO dataStoreDAO;
    private final IPermIdDAO permIdDAO;
    private final IEventDAO eventDAO;
    private final IEventsSearchDAO eventsSearchDAO;
    private final IAuthorizationGroupDAO authorizationGroupDAO;
    private final IScriptDAO scriptDAO;
    private final ICorePluginDAO corePluginDAO;
    private final IPostRegistrationDAO postRegistrationDAO;
    private final IEntityOperationsLogDAO entityOperationsLogDAO;
    private EntityHistoryDAO entityPropertyHistoryDAO;
    private final IExternalDataManagementSystemDAO externalDataManagementSystemDAO;
    private final IOperationExecutionDAO operationExecutionDAO;
    private final ISemanticAnnotationDAO semanticAnnotationDAO;
    private DatabaseConfigurationContext context;
    public static final boolean USE_NEW_SQL_ENGINE = true;
    private static String projectConstraintFunction;
    private static String projectConstraintTrigger;
    private static String setProjectsToSamplesWithExperiments;

    public DAOFactory(DatabaseConfigurationContext context, SessionFactory sessionFactory, IDynamicPropertyEvaluationScheduler dynamicPropertyEvaluationScheduler, EntityHistoryCreator historyCreator, IAuthorizationConfig authorizationConfig) {
        super(context, sessionFactory, dynamicPropertyEvaluationScheduler, historyCreator, authorizationConfig);
        EntityKind[] entityKinds;
        this.context = context;
        this.dynamicPropertyEvaluationScheduler = dynamicPropertyEvaluationScheduler;
        historyCreator.setDaoFactory(this);
        this.sampleTypeDAO = new SampleTypeDAO(sessionFactory, historyCreator);
        this.hibernateSearchDAO = new HibernateSearchDAOV3Adaptor();
        this.propertyTypeDAO = new PropertyTypeDAO(sessionFactory, historyCreator);
        this.vocabularyDAO = new VocabularyDAO(sessionFactory, historyCreator);
        this.vocabularyTermDAO = new VocabularyTermDAO(sessionFactory, historyCreator);
        this.dataSetTypeDAO = new DataSetTypeDAO(sessionFactory, historyCreator);
        this.fileFormatTypeDAO = new FileFormatTypeDAO(sessionFactory, historyCreator);
        this.locatorTypeDAO = new LocatorTypeDAO(sessionFactory, historyCreator);
        this.materialDAO = new MaterialDAO(this.getPersistencyResources(), historyCreator);
        this.codeSequenceDAO = new CodeSequenceDAO(sessionFactory);
        this.dataStoreDAO = new DataStoreDAO(sessionFactory);
        this.permIdDAO = new PermIdDAO(sessionFactory);
        this.eventDAO = new EventDAO(sessionFactory, historyCreator);
        this.eventsSearchDAO = new EventsSearchDAO(sessionFactory);
        this.attachmentDAO = new AttachmentDAO(this.getPersistencyResources(), this.eventDAO, historyCreator);
        this.authorizationGroupDAO = new AuthorizationGroupDAO(sessionFactory, historyCreator);
        this.scriptDAO = new ScriptDAO(sessionFactory, historyCreator);
        this.corePluginDAO = new CorePluginDAO(sessionFactory);
        this.postRegistrationDAO = new PostRegistrationDAO(sessionFactory, historyCreator);
        this.entityOperationsLogDAO = new EntityOperationsLogDAO(sessionFactory, historyCreator);
        for (EntityKind entityKind : entityKinds = EntityKind.values()) {
            EntityTypeDAO dao = new EntityTypeDAO(entityKind, sessionFactory, historyCreator, this);
            this.entityTypeDAOs.put(entityKind, dao);
            this.entityPropertyTypeDAOs.put(entityKind, new EntityPropertyTypeDAO(entityKind, this.getPersistencyResources()));
        }
        this.entityPropertyHistoryDAO = new EntityHistoryDAO(this.getPersistencyResources());
        this.externalDataManagementSystemDAO = new ExternalDataManagementSystemDAO(sessionFactory);
        this.operationExecutionDAO = new OperationExecutionDAO(sessionFactory, historyCreator);
        this.semanticAnnotationDAO = new SemanticAnnotationDAO(sessionFactory, historyCreator);
    }

    @Override
    public Date getTransactionTimestamp() {
        return UpdateUtils.getTransactionTimeStamp(this.getSessionFactory());
    }

    @Override
    public final ISampleTypeDAO getSampleTypeDAO() {
        return this.sampleTypeDAO;
    }

    @Override
    public final IHibernateSearchDAO getHibernateSearchDAO() {
        return this.hibernateSearchDAO;
    }

    @Override
    public IEntityPropertyTypeDAO getEntityPropertyTypeDAO(EntityKind entityKind) {
        return this.entityPropertyTypeDAOs.get((Object)entityKind);
    }

    @Override
    public IEntityHistoryDAO getEntityPropertyHistoryDAO() {
        return this.entityPropertyHistoryDAO;
    }

    @Override
    public IEntityTypeDAO getEntityTypeDAO(EntityKind entityKind) {
        return this.entityTypeDAOs.get((Object)entityKind);
    }

    @Override
    public IPropertyTypeDAO getPropertyTypeDAO() {
        return this.propertyTypeDAO;
    }

    @Override
    public final IVocabularyDAO getVocabularyDAO() {
        return this.vocabularyDAO;
    }

    @Override
    public final IVocabularyTermDAO getVocabularyTermDAO() {
        return this.vocabularyTermDAO;
    }

    @Override
    public final IAttachmentDAO getAttachmentDAO() {
        return this.attachmentDAO;
    }

    @Override
    public IDataSetTypeDAO getDataSetTypeDAO() {
        return this.dataSetTypeDAO;
    }

    @Override
    public IFileFormatTypeDAO getFileFormatTypeDAO() {
        return this.fileFormatTypeDAO;
    }

    @Override
    public ILocatorTypeDAO getLocatorTypeDAO() {
        return this.locatorTypeDAO;
    }

    @Override
    public IMaterialDAO getMaterialDAO() {
        return this.materialDAO;
    }

    @Override
    public ICodeSequenceDAO getCodeSequenceDAO() {
        return this.codeSequenceDAO;
    }

    @Override
    public IDataStoreDAO getDataStoreDAO() {
        return this.dataStoreDAO;
    }

    @Override
    public IPermIdDAO getPermIdDAO() {
        return this.permIdDAO;
    }

    @Override
    public IEventDAO getEventDAO() {
        return this.eventDAO;
    }

    @Override
    public IEventsSearchDAO getEventsSearchDAO() {
        return this.eventsSearchDAO;
    }

    @Override
    public IAuthorizationGroupDAO getAuthorizationGroupDAO() {
        return this.authorizationGroupDAO;
    }

    @Override
    public IScriptDAO getScriptDAO() {
        return this.scriptDAO;
    }

    public IDynamicPropertyEvaluationScheduler getDynamicPropertyEvaluationScheduler() {
        return this.dynamicPropertyEvaluationScheduler;
    }

    @Override
    public ICorePluginDAO getCorePluginDAO() {
        return this.corePluginDAO;
    }

    @Override
    public IPostRegistrationDAO getPostRegistrationDAO() {
        return this.postRegistrationDAO;
    }

    @Override
    public IEntityOperationsLogDAO getEntityOperationsLogDAO() {
        return this.entityOperationsLogDAO;
    }

    @Override
    public IExternalDataManagementSystemDAO getExternalDataManagementSystemDAO() {
        return this.externalDataManagementSystemDAO;
    }

    @Override
    public IOperationExecutionDAO getOperationExecutionDAO() {
        return this.operationExecutionDAO;
    }

    @Override
    public ISemanticAnnotationDAO getSemanticAnnotationDAO() {
        return this.semanticAnnotationDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Properties serviceProperties = this.configurer.getResolvedProps();
        this.hibernateSearchDAO.setProperties(serviceProperties);
        SamplePE.projectSamplesEnabled = PropertyUtils.getBoolean((Properties)serviceProperties, (String)"project-samples-enabled", (boolean)false);
        Connection connection = null;
        try {
            connection = this.context.getDataSource().getConnection();
            Statement statement = connection.createStatement();
            connection.setAutoCommit(false);
            ResultSet result = statement.executeQuery("SELECT tgname FROM pg_trigger WHERE tgname='disable_project_level_samples'");
            boolean triggerExists = result.next();
            if (SamplePE.projectSamplesEnabled) {
                if (triggerExists) {
                    operationLog.info((Object)"Enable project samples by dropping the trigger 'disable_project_level_samples'.");
                    ResultSet frozenProjects = statement.executeQuery("SELECT id FROM projects WHERE frozen_for_samp='t'");
                    ArrayList<Long> frozenProjectsIds = new ArrayList<Long>();
                    while (frozenProjects.next()) {
                        frozenProjectsIds.add(frozenProjects.getLong("id"));
                    }
                    statement.executeUpdate("UPDATE projects SET frozen_for_samp='f' WHERE frozen_for_samp='t'");
                    statement.executeUpdate("DROP TRIGGER disable_project_level_samples ON samples_all");
                    statement.executeUpdate(projectConstraintFunction);
                    statement.executeUpdate(projectConstraintTrigger);
                    statement.executeUpdate(setProjectsToSamplesWithExperiments);
                    if (!frozenProjectsIds.isEmpty()) {
                        StringBuilder frozenProjectsIdsAsString = new StringBuilder();
                        for (int idx = 0; idx < frozenProjectsIds.size(); ++idx) {
                            if (idx > 0) {
                                frozenProjectsIdsAsString.append(",");
                            }
                            frozenProjectsIdsAsString.append(frozenProjectsIds.get(idx));
                        }
                        statement.executeUpdate("UPDATE projects SET frozen_for_samp='t' WHERE id in (" + frozenProjectsIdsAsString + ")");
                    }
                } else {
                    operationLog.info((Object)"Project samples already enabled.");
                }
            } else if (!triggerExists) {
                operationLog.warn((Object)"It is not possible to disable project samples feature. The system still considers project-samples-enabled=true.");
                SamplePE.projectSamplesEnabled = true;
            }
            statement.close();
            connection.commit();
        }
        catch (Throwable t) {
            operationLog.info((Object)"Failed to enable project level samples.", t);
            if (connection != null) {
                connection.rollback();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
                }
            }
        }
    }

    static {
        SpringEoDSQLExceptionTranslator.activate();
        projectConstraintFunction = "CREATE FUNCTION check_project_is_defined_for_experiment_level_samples()   RETURNS trigger AS $BODY$ BEGIN   IF (NEW.proj_id IS NULL AND NEW.expe_id IS NOT NULL) THEN     RAISE EXCEPTION 'Project has to be defined for experiment level samples';   END IF;   RETURN NEW; END; $BODY$   LANGUAGE 'plpgsql';";
        projectConstraintTrigger = "CREATE TRIGGER check_project_is_defined_for_experiment_level_samples BEFORE INSERT OR UPDATE ON samples_all FOR EACH ROW EXECUTE PROCEDURE check_project_is_defined_for_experiment_level_samples();";
        setProjectsToSamplesWithExperiments = "UPDATE samples_all AS s  SET proj_id = (SELECT proj_id FROM experiments_all WHERE id = s.expe_id) WHERE s.proj_id IS NULL AND s.expe_id IS NOT NULL;";
    }
}

