/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IDetachedCriteriaFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateTemplate;

final class DAOUtils {
    static final int MAX_COUNT_FOR_PROPERTIES = 20000;
    private static final int BATCH_SIZE = 1000;

    private DAOUtils() {
    }

    static int getCount(Criteria criteria) {
        int count = ((Number)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
        criteria.setProjection(null);
        criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        return count;
    }

    static <T> List<T> listByCollection(HibernateTemplate hibernateTemplate, final Class<?> entityClass, String columnName, Collection<?> identifiers) {
        return DAOUtils.listByCollection(hibernateTemplate, new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                return DetachedCriteria.forClass((Class)entityClass);
            }
        }, columnName, identifiers);
    }

    static <T> List<T> listByCollection(HibernateTemplate hibernateTemplate, IDetachedCriteriaFactory factory, String columnName, Collection<?> identifiers) {
        ArrayList parameters = new ArrayList(identifiers);
        ArrayList result = new ArrayList();
        int n = parameters.size();
        for (int i = 0; i < n; i += 1000) {
            DetachedCriteria criteria = factory.createCriteria();
            List subList = parameters.subList(i, Math.min(n, i + 1000));
            if (subList.isEmpty()) continue;
            criteria.add(Restrictions.in((String)columnName, subList));
            result.addAll(hibernateTemplate.findByCriteria(criteria));
        }
        return result;
    }
}

