/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.collection.CollectionStyle;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.collection.IToStringConverter;
import ch.systemsx.cisd.common.collection.ToStringDefaultConverter;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRelationshipTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.RelationshipUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityWithPropertiesDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IDetachedCriteriaFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.InQuery;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.InQueryScroller;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.StatelessSession;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

final class DataDAO
extends AbstractGenericEntityWithPropertiesDAO<DataPE>
implements IDataDAO {
    private final int MAX_BATCH_SIZE = 999;
    private static final Class<DataPE> ENTITY_CLASS = DataPE.class;
    private static final Class<ExternalDataPE> EXTERNAL_DATA_ENTITY_CLASS = ExternalDataPE.class;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataDAO.class);
    private static final String TABLE_NAME = ENTITY_CLASS.getSimpleName();
    private static final String EXTERNAL_DATA_TABLE_NAME = EXTERNAL_DATA_ENTITY_CLASS.getSimpleName();
    private Boolean isAccessTimestampColumnDefined;
    private IRelationshipTypeDAO relationshipTypeDAO;
    private static final String ENTITY_TYPE = "case when h.data_id is not null then 'DATA_SET' when h.samp_id is not null then 'SAMPLE' when h.expe_id is not null then 'EXPERIMENT' else 'UNKNOWN' end as entity_type";

    DataDAO(PersistencyResources persistencyResources, IRelationshipTypeDAO relationshipTypeDAO, EntityHistoryCreator historyCreator) {
        super(persistencyResources, ENTITY_CLASS, historyCreator);
        this.relationshipTypeDAO = relationshipTypeDAO;
    }

    @Override
    public boolean hasDataSet(SamplePE sample) throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(DataPE.class);
        criteria.add((Criterion)Restrictions.eq((String)"sampleInternal", (Object)sample));
        criteria.setProjection(Projections.rowCount());
        Integer count = ((Number)this.getHibernateTemplate().findByCriteria(criteria).get(0)).intValue();
        return count > 0;
    }

    @Override
    public Map<SamplePE, Boolean> haveDataSets(Collection<SamplePE> samples) throws DataAccessException {
        if (samples == null || samples.isEmpty()) {
            return Collections.emptyMap();
        }
        final LinkedList<Long> sampleIds = new LinkedList<Long>();
        for (SamplePE sample : samples) {
            sampleIds.add(sample.getId());
        }
        Set idsOfSamplesWithDataSets = (Set)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                InQuery inQuery = new InQuery();
                List list = inQuery.withBatch(session, "select distinct samp_id from data where samp_id in (:sampleIds)", "sampleIds", sampleIds, null);
                HashSet<Long> ids = new HashSet<Long>();
                for (Number item : list) {
                    ids.add(item.longValue());
                }
                return ids;
            }
        });
        HashMap<SamplePE, Boolean> result = new HashMap<SamplePE, Boolean>();
        for (SamplePE sample : samples) {
            result.put(sample, idsOfSamplesWithDataSets.contains(sample.getId()));
        }
        return result;
    }

    @Override
    public final List<DataPE> listRelatedDataSets(List<IEntityInformationHolder> entities, EntityKind entityKind) throws DataAccessException {
        assert (entities != null) : "Unspecified entities.";
        assert (entities.size() > 0) : "Empty entities.";
        assert (entityKind != null) : "Unspecified entity kind.";
        String entityName = entityKind.toString().toLowerCase();
        final String query = String.format("from %s e left join fetch e.experimentInternal left join fetch e.sampleInternal left join fetch e.dataSetParentRelationships left join fetch e.dataSetProperties where e.%sInternal.id IN (:ids)", TABLE_NAME, entityName);
        final ArrayList<Long> ids = new ArrayList<Long>();
        for (IEntityInformationHolder entity : entities) {
            ids.add(entity.getId());
        }
        final ArrayList<DataPE> results = new ArrayList<DataPE>();
        BatchOperationExecutor.executeInBatches(new IBatchOperation<Long>(){

            @Override
            public void execute(List<Long> entityIds) {
                List list = AbstractDAO.cast(DataDAO.this.getHibernateTemplate().findByNamedParam(query, "ids", entityIds));
                results.addAll(list);
            }

            @Override
            public List<Long> getAllEntities() {
                return ids;
            }

            @Override
            public String getEntityName() {
                return "dataSet";
            }

            @Override
            public String getOperationName() {
                return "listRelatedDataSets";
            }
        });
        this.distinct(results);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d external data have been found for %d entities.", results.size(), entities.size()));
        }
        return results;
    }

    @Override
    public final List<DataPE> listDataSetsWithoutRelationships(SamplePE sample) throws DataAccessException {
        assert (sample != null) : "Unspecified sample.";
        String query = String.format("from %s e where e.sampleInternal = ?", TABLE_NAME);
        List<DataPE> list = DataDAO.cast(this.getHibernateTemplate().find(query, DataDAO.toArray(sample)));
        this.distinct(list);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d external data have been found for [sample=%s].", list.size(), sample));
        }
        return list;
    }

    @Override
    public final List<DataPE> listDataSets(SamplePE sample) throws DataAccessException {
        assert (sample != null) : "Unspecified sample.";
        String query = String.format("from %s e left join fetch e.experimentInternal left join fetch e.dataSetParentRelationships left join fetch e.dataSetProperties where e.sampleInternal = ?", TABLE_NAME);
        List<DataPE> list = DataDAO.cast(this.getHibernateTemplate().find(query, DataDAO.toArray(sample)));
        this.distinct(list);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d external data have been found for [sample=%s].", list.size(), sample));
        }
        return list;
    }

    @Override
    public final List<DataPE> listExternalData(DataStorePE dataStore) throws DataAccessException {
        assert (dataStore != null) : "Unspecified data store.";
        DetachedCriteria criteria = DetachedCriteria.forClass(ExternalDataPE.class);
        criteria.add((Criterion)Restrictions.eq((String)"dataStore", (Object)dataStore));
        List<DataPE> list = DataDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): %d data set(s) have been found.", MethodUtils.getCurrentMethod().getName(), dataStore, list.size()));
        }
        return list;
    }

    @Override
    public final List<DataPE> listDataSets(ExperimentPE experiment) throws DataAccessException {
        assert (experiment != null) : "Unspecified experiment.";
        String query = String.format("from %s e left join fetch e.experimentInternal left join fetch e.dataSetParentRelationships left join fetch e.dataSetProperties where e.experimentInternal = ?", TABLE_NAME);
        List<DataPE> list = DataDAO.cast(this.getHibernateTemplate().find(query, DataDAO.toArray(experiment)));
        this.distinct(list);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d external data have been found for [experiment=%s].", list.size(), experiment));
        }
        return list;
    }

    private void distinct(List<DataPE> list) {
        TreeSet<DataPE> set = new TreeSet<DataPE>(list);
        list.clear();
        list.addAll(set);
    }

    @Override
    public DataPE tryToFindDataSetByCode(String dataSetCode) {
        assert (dataSetCode != null) : "Unspecified data set code.";
        String mangledCode = CodeConverter.tryToDatabase(dataSetCode);
        SimpleExpression codeEq = Restrictions.eq((String)"code", (Object)mangledCode);
        DetachedCriteria criteria = DetachedCriteria.forClass(ENTITY_CLASS);
        criteria.add((Criterion)codeEq);
        criteria.setFetchMode("dataSetType", FetchMode.JOIN);
        criteria.setFetchMode("dataStore", FetchMode.JOIN);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List list = DataDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        DataPE entity = (DataPE)DataDAO.tryFindEntity(list, "data set", new Object[0]);
        if (operationLog.isDebugEnabled()) {
            String methodName = MethodUtils.getCurrentMethod().getName();
            operationLog.debug((Object)String.format("%s(%s): '%s'.", methodName, dataSetCode, entity));
        }
        return entity;
    }

    @Override
    public TechId tryToFindDataSetIdByCode(String dataSetCode) {
        NativeQuery query = this.currentSession().createSQLQuery("select id from data_all where code = :code");
        query.setString("code", CodeConverter.tryToDatabase(dataSetCode));
        Object uniqueResult = query.uniqueResult();
        if (uniqueResult != null) {
            return new TechId((Number)((BigInteger)uniqueResult));
        }
        return null;
    }

    @Override
    public List<DeletedDataPE> tryToFindDeletedDataSetsByCodes(Collection<String> dataSetCodes) {
        assert (dataSetCodes != null) : "Unspecified collection";
        if (dataSetCodes.size() == 0) {
            return Collections.emptyList();
        }
        List<DeletedDataPE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass(DeletedDataPE.class);
                criteria.setFetchMode("dataStore", FetchMode.SELECT);
                criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
                return criteria;
            }
        }, "code", dataSetCodes);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Found '%s' data sets for codes '%s'.", list.size(), dataSetCodes));
        }
        return list;
    }

    @Override
    public List<DataPE> tryToFindFullDataSetsByIds(Collection<Long> ids, boolean withPropertyTypes, boolean lockForUpdate) {
        return this.tryToFindFullDataSets("id", ids, withPropertyTypes, lockForUpdate);
    }

    @Override
    public List<DataPE> tryToFindFullDataSetsByCodes(Collection<String> dataSetCodes, boolean withPropertyTypes, boolean lockForUpdate) {
        return this.tryToFindFullDataSets("code", dataSetCodes, withPropertyTypes, lockForUpdate);
    }

    private List<DataPE> tryToFindFullDataSets(String identifierColumn, Collection<?> identifiers, boolean withPropertyTypes, boolean lockForUpdate) {
        assert (identifiers != null) : "Unspecified collection";
        int len = identifiers.size();
        if (len > 999) {
            ArrayList<DataPE> result = new ArrayList<DataPE>(identifiers.size());
            ArrayList dataSetCodesList = new ArrayList(identifiers);
            int startIndex = 0;
            int endIndex = 999;
            while (endIndex > startIndex) {
                result.addAll(this.primFindFullDataSetsByCode(identifierColumn, dataSetCodesList.subList(startIndex, endIndex), withPropertyTypes, lockForUpdate));
                startIndex = endIndex;
                endIndex = Math.min(endIndex + 999, len);
            }
            return result;
        }
        return this.primFindFullDataSetsByCode(identifierColumn, identifiers, withPropertyTypes, lockForUpdate);
    }

    private List<DataPE> primFindFullDataSetsByCode(String identifierColumn, Collection<?> identifiers, final boolean withPropertyTypes, boolean lockForUpdate) {
        if (identifiers.size() == 0) {
            return Collections.emptyList();
        }
        List<DataPE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass((Class)ENTITY_CLASS);
                criteria.setFetchMode("dataSetType", FetchMode.SELECT);
                criteria.setFetchMode("dataStore", FetchMode.SELECT);
                criteria.setFetchMode("experimentInternal", FetchMode.SELECT);
                criteria.setFetchMode("sampleInternal", FetchMode.SELECT);
                criteria.setFetchMode("fileFormat", FetchMode.SELECT);
                if (withPropertyTypes) {
                    criteria.setFetchMode("dataSetType.dataSetTypePropertyTypesInternal", FetchMode.JOIN);
                }
                criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
                return criteria;
            }
        }, identifierColumn, identifiers);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Found '%s' data sets for codes '%s'.", list.size(), identifiers));
        }
        return list;
    }

    @Override
    public DataPE tryToFindFullDataSetByCode(String dataSetCode, boolean withPropertyTypes, boolean lockForUpdate) {
        assert (dataSetCode != null) : "Unspecified data set code";
        String mangledCode = CodeConverter.tryToDatabase(dataSetCode);
        SimpleExpression codeEq = Restrictions.eq((String)"code", (Object)mangledCode);
        DetachedCriteria criteria = DetachedCriteria.forClass(ENTITY_CLASS);
        criteria.add((Criterion)codeEq);
        criteria.setFetchMode("dataSetType", FetchMode.SELECT);
        criteria.setFetchMode("dataStore", FetchMode.SELECT);
        criteria.setFetchMode("experimentInternal", FetchMode.SELECT);
        criteria.setFetchMode("sampleInternal", FetchMode.SELECT);
        criteria.setFetchMode("fileFormat", FetchMode.SELECT);
        if (withPropertyTypes) {
            criteria.setFetchMode("dataSetType.dataSetTypePropertyTypesInternal", FetchMode.JOIN);
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List list = DataDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        DataPE entity = (DataPE)DataDAO.tryFindEntity(list, "data set", new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Data Set '%s' found for data set code '%s'.", entity, dataSetCode));
        }
        return entity;
    }

    @Override
    public void updateDataSetStatuses(List<String> dataSetCodes, DataSetArchivingStatus status) {
        assert (dataSetCodes != null) : "Unspecified data set codes";
        assert (status != null) : "Unspecified code";
        if (dataSetCodes.size() == 0) {
            return;
        }
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        int len = dataSetCodes.size();
        int updatedRows = 0;
        if (len > 999) {
            int startIndex = 0;
            int endIndex = 999;
            while (endIndex > startIndex) {
                int startIndexFinal = startIndex;
                int endIndexFinal = endIndex;
                List<String> codes = dataSetCodes.subList(startIndexFinal, endIndexFinal);
                updatedRows += this.updateStatus(hibernateTemplate, status, codes).intValue();
                startIndex = endIndex;
                endIndex = Math.min(endIndex + 999, len);
            }
        } else {
            updatedRows = this.updateStatus(hibernateTemplate, status, dataSetCodes);
        }
        this.scheduleDynamicPropertiesEvaluationForDataSets(dataSetCodes);
        hibernateTemplate.flush();
        if (updatedRows != dataSetCodes.size()) {
            throw UserFailureException.fromTemplate((String)"Update of %s data set statuses to %s failed.", (Object[])new Object[]{dataSetCodes.size(), status});
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("UPDATED: %s data set statuses to '%s'.", new Object[]{dataSetCodes.size(), status}));
        }
    }

    private Integer updateStatus(HibernateTemplate hibernateTemplate, final DataSetArchivingStatus status, final List<String> codes) {
        return (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) throws HibernateException {
                int result = session.createQuery("UPDATE " + EXTERNAL_DATA_TABLE_NAME + " SET status = :status WHERE code IN (:codes) ").setParameter("status", (Object)status).setParameterList("codes", (Collection)codes).executeUpdate();
                DataDAO.updateVersion(session, codes);
                return result;
            }
        });
    }

    private static int updateVersion(Session session, List<String> codes) {
        return session.createQuery("UPDATE " + TABLE_NAME + " SET version = version + 1 WHERE code IN (:codes) ").setParameterList("codes", codes).executeUpdate();
    }

    @Override
    public void updateSizes(final Map<String, Long> sizeMap) {
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        hibernateTemplate.execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) throws HibernateException {
                for (Map.Entry sizeEntry : sizeMap.entrySet()) {
                    long positiveSize = Math.max(1L, (Long)sizeEntry.getValue());
                    session.createQuery("UPDATE " + EXTERNAL_DATA_TABLE_NAME + " SET size = :size WHERE code = :code").setParameter("size", (Object)positiveSize).setParameter("code", sizeEntry.getKey()).executeUpdate();
                }
                return null;
            }
        });
        hibernateTemplate.flush();
    }

    @Override
    public void updateDataSetStatuses(List<String> dataSetCodes, DataSetArchivingStatus status, boolean presentInArchive) {
        assert (dataSetCodes != null) : "Unspecified data set codes";
        assert (status != null) : "Unspecified code";
        if (dataSetCodes.size() == 0) {
            return;
        }
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        int len = dataSetCodes.size();
        int updatedRows = 0;
        if (len > 999) {
            int startIndex = 0;
            int endIndex = 999;
            while (endIndex > startIndex) {
                int startIndexFinal = startIndex;
                int endIndexFinal = endIndex;
                List<String> codes = dataSetCodes.subList(startIndexFinal, endIndexFinal);
                updatedRows += ((Integer)hibernateTemplate.execute((HibernateCallback)new StatusUpdater(presentInArchive, status, codes))).intValue();
                startIndex = endIndex;
                endIndex = Math.min(endIndex + 999, len);
            }
        } else {
            updatedRows = (Integer)hibernateTemplate.execute((HibernateCallback)new StatusUpdater(presentInArchive, status, dataSetCodes));
        }
        this.scheduleDynamicPropertiesEvaluationForDataSets(dataSetCodes);
        hibernateTemplate.flush();
        if (updatedRows != dataSetCodes.size()) {
            throw UserFailureException.fromTemplate((String)"Update of %s data set statuses to '%s' and presentInArchive to '%s' failed.", (Object[])new Object[]{dataSetCodes.size(), status, presentInArchive});
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("UPDATED: %s data set statuses to '%s' and presentInArchive flag to '%s'.", new Object[]{dataSetCodes.size(), status, presentInArchive}));
        }
    }

    private void scheduleDynamicPropertiesEvaluationForDataSets(List<String> dataSetCodes) {
        List<DataPE> dataSets = this.tryToFindFullDataSetsByCodes(dataSetCodes, false, false);
        this.scheduleDynamicPropertiesEvaluation(dataSets);
    }

    @Override
    public void createDataSet(DataPE dataset, PersonPE modifier) {
        this.createDataSets(Collections.singletonList(dataset), modifier);
    }

    @Override
    public void createDataSets(List<DataPE> dataSets, PersonPE modifier) throws DataAccessException {
        assert (dataSets != null && dataSets.size() > 0) : "Unspecified or empty dataSets.";
        for (DataPE dataPE : dataSets) {
            this.internalCreateOrUpdateDataSet(dataPE, modifier);
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("ADD: %d dataSets.", dataSets.size()));
        }
        this.getHibernateTemplate().flush();
        this.scheduleDynamicPropertiesEvaluation(dataSets);
    }

    private void internalCreateOrUpdateDataSet(DataPE dataset, PersonPE modifier) {
        assert (dataset != null) : "Unspecified data set.";
        dataset.setCode(CodeConverter.tryToDatabase(dataset.getCode()));
        dataset.setModifier(modifier);
        dataset.setRegistrator(modifier);
        DataDAO.validatePE(dataset);
        this.lockRelatedEntities(dataset);
        this.getHibernateTemplate().saveOrUpdate((Object)dataset);
    }

    private void lockRelatedEntities(DataPE data) {
        this.lockEntity(data.getExperiment());
        this.lockEntity(data.tryGetSample());
        this.lockEntities(data.getLinkedDataSets());
    }

    @Override
    public void updateDataSet(DataPE data, PersonPE modifier) {
        assert (data != null) : "Given external data can not be null.";
        DataDAO.validatePE(data);
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        data.setCode(CodeConverter.tryToDatabase(data.getCode()));
        data.setModifier(modifier);
        this.lockRelatedEntities(data);
        hibernateTemplate.update((Object)data);
        hibernateTemplate.flush();
        this.scheduleDynamicPropertiesEvaluation(Collections.singletonList(data));
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("UPDATE: external data '%s'.", data));
        }
    }

    @Override
    public void delete(List<TechId> dataIds, PersonPE registrator, String reason) throws DataAccessException {
        DeletionEventSQLs sqls = new DeletionEventSQLs();
        sqls.selectPermIds = DataDAO.createSelectCodesOrderByIdSQL();
        sqls.selectLocations = DataDAO.createSelectLocationsOrderByIdSQL();
        sqls.deleteProperties = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeletePropertiesSQL("data_set_properties", "ds_id");
        sqls.deleteDataSets = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeleteEnitiesSQL("data_all");
        sqls.insertEvent = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createInsertEventSQL();
        sqls.deleteExternalData = DataDAO.createDeleteExternalDataSQL();
        sqls.deleteContentCopies = DataDAO.createDeleteContentCopiesSQL();
        Long relationshipTypeId = RelationshipUtils.getParentChildRelationshipType(this.relationshipTypeDAO).getId();
        sqls.deleteChildrenConnections = DataDAO.createDeleteChildrenConnectionsSQL(relationshipTypeId);
        sqls.deleteParentConnections = DataDAO.createDeleteParentConnectionsSQL(relationshipTypeId);
        sqls.selectPropertyHistory = DataDAO.createQueryPropertyHistorySQL();
        sqls.selectRelationshipHistory = DataDAO.createQueryRelationshipHistorySQL();
        sqls.selectAttributes = DataDAO.createQueryAttributesHistorySQL();
        this.executePermanentDeleteOfDataSets(EventPE.EntityType.DATASET, dataIds, registrator, reason, sqls);
    }

    protected void executePermanentDeleteOfDataSets(EventPE.EntityType entityType, List<TechId> entityTechIds, PersonPE registrator, String reason, DeletionEventSQLs sqls) {
        List entityIds = TechId.asLongs(entityTechIds);
        DeleteDataSetsPermanentlyBatchOperation deleteOperation = new DeleteDataSetsPermanentlyBatchOperation(entityType, entityIds, registrator, reason, sqls);
        BatchOperationExecutor.executeInBatches(deleteOperation);
        this.scheduleRemoveFromFullTextIndex(entityIds);
    }

    private static String createSelectCodesOrderByIdSQL() {
        return "SELECT code FROM data_all WHERE id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " ORDER BY id";
    }

    private static String createSelectLocationsOrderByIdSQL() {
        return "SELECT ed.location, ed.share_id, ds.code FROM data_all d JOIN data_stores ds ON (d.dast_id = ds.id) LEFT OUTER JOIN external_data ed ON (d.id = ed.id) WHERE d.id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " ORDER BY d.id";
    }

    private static String createDeleteExternalDataSQL() {
        return "DELETE FROM external_data WHERE id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds();
    }

    private static String createDeleteContentCopiesSQL() {
        return "DELETE FROM content_copies WHERE data_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds();
    }

    private static String createDeleteChildrenConnectionsSQL(long relationshipTypeId) {
        return "DELETE FROM data_set_relationships_all WHERE data_id_parent " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " and relationship_id = " + relationshipTypeId;
    }

    private static String createDeleteParentConnectionsSQL(long relationshipTypeId) {
        return "DELETE FROM data_set_relationships_all WHERE data_id_child " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " and relationship_id = " + relationshipTypeId;
    }

    private static String createQueryPropertyHistorySQL() {
        return " ( select d.code as data_set_code, pt.code as property_code, coalesce(value, vocabulary_term, material) as value, p.user_id, h.valid_from_timestamp, h.valid_until_timestamp  from data_all d, data_set_properties_history h, data_set_type_property_types dspt, property_types pt, persons p  where ds_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " and d.id = ds_id  and h.dstpt_id = dspt.id and dspt.prty_id = pt.id and pers_id_author = p.id ) union ( select d.code as data_set_code, pt.code as property_code, coalesce(value,  (select (t.code || ' [' || v.code || ']') from " + "controlled_vocabulary_terms" + " as t join " + "controlled_vocabularies" + " as v on t.covo_id = v.id where t.id = pr.CVTE_ID), (select (m.code || ' [' || mt.code || ']') from " + "materials" + " as m join " + "material_types" + " as mt on m.maty_id = mt.id where m.id = pr.MATE_PROP_ID)) as value, author.user_id, pr.modification_timestamp, null from " + "data_all" + " d, " + "data_set_properties" + " pr, " + "data_set_type_property_types" + " dtpt, " + "property_types" + " pt, " + "persons" + " author where ds_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " and d.id = pr.ds_id  and pr.dstpt_id = dtpt.id and dtpt.prty_id = pt.id and pr.pers_id_author = author.id ) order by 1, valid_from_timestamp";
    }

    private static String createQueryRelationshipHistorySQL() {
        return " SELECT d.code, relation_type,entity_perm_id, case when h.data_id is not null then 'DATA_SET' when h.samp_id is not null then 'SAMPLE' when h.expe_id is not null then 'EXPERIMENT' else 'UNKNOWN' end as entity_type, p.user_id, valid_from_timestamp, valid_until_timestamp FROM data_all d, data_set_relationships_history h, persons p WHERE d.id = main_data_id and  main_data_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " and h.pers_id_author = p.id order by 1, valid_from_timestamp";
    }

    private static String createQueryAttributesHistorySQL() {
        return "SELECT d.id, d.code, d.code as perm_id, t.code as entity_type, st.code as data_store, d.data_producer_code, d.registration_timestamp, r.user_id as registrator, ed.share_id, ed.size, ed.location, fft.code as file_format_type, lt.code as locator_type,stf.code as storage_format, ed.is_complete, ed.speed_hint, ed.storage_confirmation, ed.status as archiving_status, ed.present_in_archive FROM data_all d left JOIN external_data ed on d.id = ed.id left JOIN locator_types lt on lt.id = ed.loty_id left JOIN file_format_types fft on fft.id = ffty_id left JOIN controlled_vocabulary_terms stf on stf.id = cvte_id_stor_fmt JOIN data_stores st on d.dast_id = st.id JOIN data_set_types t on d.dsty_id = t.id JOIN persons r on d.pers_id_registerer = r.id WHERE d.id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds();
    }

    @Override
    public Map<Long, Set<Long>> mapDataSetIdsByChildrenIds(final Collection<Long> children, final Long relationship) {
        List results = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) {
                InQuery inQuery = new InQuery();
                HashMap<String, Object> fixParams = new HashMap<String, Object>();
                fixParams.put("relationship", relationship);
                String query = "select data_id_child, data_id_parent from data_set_relationships where relationship_id = :relationship and data_id_child in (:children)";
                return inQuery.withBatch(session, query, "children", new ArrayList(children), fixParams);
            }
        });
        HashMap<Long, Set<Long>> childIdToParentIdsMap = new HashMap<Long, Set<Long>>();
        for (Object[] result : results) {
            Number childId = (Number)result[0];
            Number parentId = (Number)result[1];
            HashSet<Long> parentIds = (HashSet<Long>)childIdToParentIdsMap.get(childId);
            if (parentIds == null) {
                parentIds = new HashSet<Long>();
                childIdToParentIdsMap.put(childId.longValue(), parentIds);
            }
            parentIds.add(parentId.longValue());
        }
        return childIdToParentIdsMap;
    }

    @Override
    public Set<TechId> findParentIds(Collection<TechId> dataSetIds, long relationshipTypeId) {
        return this.findRelatedIds("data_id_parent", "data_id_child", dataSetIds, relationshipTypeId);
    }

    @Override
    public Set<TechId> findChildrenIds(Collection<TechId> dataSetIds, long relationshipTypeId) {
        return this.findRelatedIds("data_id_child", "data_id_parent", dataSetIds, relationshipTypeId);
    }

    private Set<TechId> findRelatedIds(String side1, String side2, Collection<TechId> dataSetIds, long relationshipTypeId) {
        String query = "select " + side1 + " from data_set_relationships where " + side2 + " in (:ids) and relationship_id = :type";
        InQueryScroller<TechId> dataSetIdsScroller = new InQueryScroller<TechId>(dataSetIds, 2);
        List<TechId> partialDataSetIds = null;
        HashSet<TechId> result = new HashSet<TechId>();
        while ((partialDataSetIds = dataSetIdsScroller.next()) != null) {
            Set<TechId> partialResult = this.findRelatedIds(query, partialDataSetIds, relationshipTypeId);
            result.addAll(partialResult);
        }
        return result;
    }

    private Set<TechId> findRelatedIds(final String query, final Collection<TechId> dataSetIds, final long relationshipTypeId) {
        List results = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) {
                List longIds = TechId.asLongs((Collection)dataSetIds);
                return session.createSQLQuery(query).setParameterList("ids", (Collection)longIds).setParameter("type", (Object)relationshipTypeId).list();
            }
        });
        return DataDAO.transformNumbers2TechIdSet(results);
    }

    @Override
    public List<DataPE> listByCode(Set<String> values) {
        return this.listByIDsOfName("code", values);
    }

    @Override
    public List<DataPE> listByIDs(Collection<Long> ids) {
        return this.listByIDsOfName("id", ids);
    }

    public List<DataPE> listByIDsOfName(String idName, Collection<?> dataSetIds) {
        if (dataSetIds == null || dataSetIds.isEmpty()) {
            return new ArrayList<DataPE>();
        }
        List<DataPE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), DataPE.class, idName, dataSetIds);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d data set(s) have been found.", list.size()));
        }
        return list;
    }

    @Override
    public List<SpacePE> listSpacesByDataSetIds(Collection<Long> values) {
        final ArrayList<Long> allIds = new ArrayList<Long>(values);
        final String query = "from " + SpacePE.class.getSimpleName() + " as s where s.id in (select p.space.id from " + ProjectPE.class.getSimpleName() + " as p where p.id in (select e.projectInternal.id from " + ExperimentPE.class.getSimpleName() + " as e where e.id in (select d.experimentInternal.id from " + DataPE.class.getSimpleName() + " as d where d.id in (:ids))))";
        final ArrayList<SpacePE> result = new ArrayList<SpacePE>();
        BatchOperationExecutor.executeInBatches(new IBatchOperation<Long>(){

            @Override
            public void execute(List<Long> ids) {
                List spaces = AbstractDAO.cast(DataDAO.this.getHibernateTemplate().findByNamedParam(query, "ids", ids));
                result.addAll(spaces);
            }

            @Override
            public List<Long> getAllEntities() {
                return allIds;
            }

            @Override
            public String getEntityName() {
                return "space";
            }

            @Override
            public String getOperationName() {
                return "listSpacesByDataSetIds";
            }
        });
        return result;
    }

    @Override
    public void updateDataSets(List<DataPE> dataSets, PersonPE modifier) {
        assert (dataSets != null) : "Data sets not defined";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        for (DataPE data : dataSets) {
            DataDAO.validatePE(data);
            data.setCode(CodeConverter.tryToDatabase(data.getCode()));
            hibernateTemplate.saveOrUpdate((Object)data);
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("UPDATE: %d data sets.", dataSets.size()));
        }
        DataDAO.flushWithSqlExceptionHandling(this.getHibernateTemplate());
        this.scheduleDynamicPropertiesEvaluation(dataSets);
        hibernateTemplate.clear();
    }

    @Override
    public final void validateAndSaveUpdatedEntity(DataPE entity) throws DataAccessException {
        DataDAO.flushWithSqlExceptionHandling(this.getHibernateTemplate());
        super.validateAndSaveUpdatedEntity(entity);
        this.scheduleDynamicPropertiesEvaluation(Arrays.asList(entity));
    }

    @Override
    protected void scheduleDynamicPropertiesEvaluation(List<DataPE> dataSets) {
        ArrayList<DataPE> toUpdate = new ArrayList<DataPE>();
        this.addAllDataSetsAndComponentsRecursively(toUpdate, dataSets);
        super.scheduleDynamicPropertiesEvaluation(toUpdate);
    }

    private void addAllDataSetsAndComponentsRecursively(List<DataPE> resultDataSets, List<DataPE> dataSets) {
        for (DataPE dataSet : dataSets) {
            resultDataSets.add(dataSet);
            this.addAllDataSetsAndComponentsRecursively(resultDataSets, dataSet.getContainedDataSets());
        }
    }

    @Override
    public List<TechId> listDataSetIdsBySampleIds(Collection<TechId> samples) {
        List longIds = TechId.asLongs(samples);
        List results = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass(DataPE.class);
                criteria.setProjection((Projection)Projections.id());
                return criteria;
            }
        }, "sampleInternal.id", longIds);
        if (operationLog.isDebugEnabled()) {
            operationLog.info((Object)String.format("found %s data sets for given samples", results.size()));
        }
        return DataDAO.transformNumbers2TechIdList(results);
    }

    @Override
    public List<TechId> listDataSetIdsByExperimentIds(Collection<TechId> experiments) {
        List longIds = TechId.asLongs(experiments);
        List results = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass(DataPE.class);
                criteria.setProjection((Projection)Projections.id());
                return criteria;
            }
        }, "experimentInternal.id", longIds);
        if (operationLog.isDebugEnabled()) {
            operationLog.info((Object)String.format("found %s data sets for given experiments", results.size()));
        }
        return DataDAO.transformNumbers2TechIdList(results);
    }

    @Override
    Logger getLogger() {
        return operationLog;
    }

    @Override
    public boolean confirmStorage(String dataSetCode) {
        NativeQuery query = this.currentSession().createSQLQuery("update external_data set storage_confirmation = true where storage_confirmation = false and id in (select id from data_all where code = :code)");
        query.setString("code", CodeConverter.tryToDatabase(dataSetCode));
        return query.executeUpdate() > 0;
    }

    @Override
    public boolean isAccessTimestampEnabled() {
        if (this.isAccessTimestampColumnDefined == null) {
            this.isAccessTimestampColumnDefined = this.isAccessTimestampColumnDefined();
            if (this.isAccessTimestampColumnDefined.booleanValue()) {
                operationLog.info((Object)"Access timestamp column for data sets is enabled");
            } else {
                operationLog.info((Object)"Access timestamp column for data sets is not enabled");
            }
        }
        return this.isAccessTimestampColumnDefined;
    }

    private boolean isAccessTimestampColumnDefined() {
        NativeQuery query = this.currentSession().createSQLQuery("SELECT column_name FROM information_schema.columns WHERE table_name='data_all' and column_name='access_timestamp'");
        return query.list().size() > 0;
    }

    @Override
    public boolean updateAccessTimestamp(String dataSetCode) {
        if (this.isAccessTimestampEnabled()) {
            NativeQuery query = this.currentSession().createSQLQuery("update data_all set access_timestamp = current_timestamp where code = :code");
            query.setString("code", CodeConverter.tryToDatabase(dataSetCode));
            return query.executeUpdate() > 0;
        }
        return false;
    }

    @Override
    public boolean exists(String dataSetCode) {
        NativeQuery query = this.currentSession().createSQLQuery("select count(*) from data_all where code = :code");
        query.setString("code", CodeConverter.tryToDatabase(dataSetCode));
        Number count = (Number)query.uniqueResult();
        return count != null && count.intValue() > 0;
    }

    protected class DeleteDataSetsPermanentlyBatchOperation
    implements IBatchOperation<Long> {
        private final EventPE.EntityType entityType;
        private final List<Long> allEntityIds;
        private final PersonPE registrator;
        private final String reason;
        private final DeletionEventSQLs sqls;

        public DeleteDataSetsPermanentlyBatchOperation(EventPE.EntityType entityType, List<Long> allEntityIds, PersonPE registrator, String reason, DeletionEventSQLs sqls) {
            this.entityType = entityType;
            this.allEntityIds = allEntityIds;
            this.registrator = registrator;
            this.reason = reason;
            this.sqls = sqls;
        }

        @Override
        public List<Long> getAllEntities() {
            return this.allEntityIds;
        }

        @Override
        public String getEntityName() {
            return this.entityType.name();
        }

        @Override
        public String getOperationName() {
            return "permanently deleting";
        }

        @Override
        public void execute(List<Long> batchEntityIds) {
            DataDAO.this.executeStatelessAction(this.createPermanentDeleteAction(batchEntityIds));
        }

        private AbstractDAO.StatelessHibernateCallback createPermanentDeleteAction(List<Long> entityIdsToDelete) {
            return new PermanentDeletionAction(entityIdsToDelete);
        }

        private class PermanentDeletionAction
        implements AbstractDAO.StatelessHibernateCallback {
            private final List<Long> entityIdsToDelete;

            public PermanentDeletionAction(List<Long> entityIdsToDelete) {
                this.entityIdsToDelete = entityIdsToDelete;
            }

            @Override
            public Object doInStatelessSession(StatelessSession session) {
                NativeQuery selectPermIds = session.createNativeQuery(((DeleteDataSetsPermanentlyBatchOperation)DeleteDataSetsPermanentlyBatchOperation.this).sqls.selectPermIds);
                NativeQuery selectLocations = session.createNativeQuery(((DeleteDataSetsPermanentlyBatchOperation)DeleteDataSetsPermanentlyBatchOperation.this).sqls.selectLocations);
                NativeQuery deleteProperties = session.createNativeQuery(((DeleteDataSetsPermanentlyBatchOperation)DeleteDataSetsPermanentlyBatchOperation.this).sqls.deleteProperties);
                NativeQuery deleteEntities = session.createNativeQuery(((DeleteDataSetsPermanentlyBatchOperation)DeleteDataSetsPermanentlyBatchOperation.this).sqls.deleteDataSets);
                NativeQuery insertEvent = session.createNativeQuery(((DeleteDataSetsPermanentlyBatchOperation)DeleteDataSetsPermanentlyBatchOperation.this).sqls.insertEvent);
                NativeQuery deleteExternalData = session.createNativeQuery(((DeleteDataSetsPermanentlyBatchOperation)DeleteDataSetsPermanentlyBatchOperation.this).sqls.deleteExternalData);
                NativeQuery deleteContentCopies = session.createNativeQuery(((DeleteDataSetsPermanentlyBatchOperation)DeleteDataSetsPermanentlyBatchOperation.this).sqls.deleteContentCopies);
                NativeQuery deleteChildrenConnections = session.createNativeQuery(((DeleteDataSetsPermanentlyBatchOperation)DeleteDataSetsPermanentlyBatchOperation.this).sqls.deleteChildrenConnections);
                NativeQuery deleteParentConnections = session.createNativeQuery(((DeleteDataSetsPermanentlyBatchOperation)DeleteDataSetsPermanentlyBatchOperation.this).sqls.deleteParentConnections);
                List<String> permIds = this.selectPermIds((SQLQuery)selectPermIds, this.entityIdsToDelete);
                if (permIds.isEmpty()) {
                    return null;
                }
                List<DeletedDataSetLocation> locations = this.selectLocations((SQLQuery)selectLocations, this.entityIdsToDelete);
                String content = DataDAO.this.historyCreator.apply((SharedSessionContract)session, this.entityIdsToDelete, ((DeleteDataSetsPermanentlyBatchOperation)DeleteDataSetsPermanentlyBatchOperation.this).sqls.selectPropertyHistory, ((DeleteDataSetsPermanentlyBatchOperation)DeleteDataSetsPermanentlyBatchOperation.this).sqls.selectRelationshipHistory, ((DeleteDataSetsPermanentlyBatchOperation)DeleteDataSetsPermanentlyBatchOperation.this).sqls.selectAttributes, null, null, DeleteDataSetsPermanentlyBatchOperation.this.registrator);
                this.executeUpdate(deleteProperties, this.entityIdsToDelete);
                this.executeUpdate(deleteExternalData, this.entityIdsToDelete);
                this.executeUpdate(deleteContentCopies, this.entityIdsToDelete);
                this.executeUpdate(deleteChildrenConnections, this.entityIdsToDelete);
                this.executeUpdate(deleteParentConnections, this.entityIdsToDelete);
                this.executeUpdate(deleteEntities, this.entityIdsToDelete);
                this.insertEvent((SQLQuery)insertEvent, permIds, locations, content);
                return null;
            }

            private List<String> selectPermIds(SQLQuery sqlQuerySelectPermIds, List<Long> entityIds) {
                sqlQuerySelectPermIds.setParameterList("entityIds", entityIds);
                List permIdsOrNull = AbstractDAO.cast(sqlQuerySelectPermIds.list());
                return permIdsOrNull == null ? Collections.emptyList() : permIdsOrNull;
            }

            private List<DeletedDataSetLocation> selectLocations(SQLQuery sqlQuerySelectLocations, List<Long> entityIds) {
                sqlQuerySelectLocations.setParameterList("entityIds", entityIds);
                sqlQuerySelectLocations.setResultTransformer(new ResultTransformer(){
                    private static final long serialVersionUID = 1L;

                    public Object transformTuple(Object[] values, String[] aliases) {
                        DeletedDataSetLocation location = new DeletedDataSetLocation();
                        location.setLocation((String)values[0]);
                        location.setShareId((String)values[1]);
                        location.setDatastoreCode((String)values[2]);
                        return location;
                    }

                    public List transformList(List list) {
                        return list;
                    }
                });
                return AbstractDAO.cast(sqlQuerySelectLocations.list());
            }

            private void executeUpdate(NativeQuery<?> a1, List<Long> entityIds) {
                a1.setParameterList("entityIds", entityIds);
                a1.executeUpdate();
            }

            private void insertEvent(SQLQuery sqlQueryInsertEvent, List<String> permIds, List<DeletedDataSetLocation> locations, String content) {
                sqlQueryInsertEvent.setParameter("eventType", (Object)EventType.DELETION.name());
                sqlQueryInsertEvent.setParameter("reason", (Object)DeleteDataSetsPermanentlyBatchOperation.this.reason);
                sqlQueryInsertEvent.setParameter("content", (Object)content);
                sqlQueryInsertEvent.setParameter("registratorId", (Object)DeleteDataSetsPermanentlyBatchOperation.this.registrator.getId());
                sqlQueryInsertEvent.setParameter("entityType", (Object)DeleteDataSetsPermanentlyBatchOperation.this.entityType.name());
                IToStringConverter<Object> toStringConverter = new IToStringConverter<Object>(){
                    IToStringConverter<Object> delegatee = ToStringDefaultConverter.getInstance();

                    public String toString(Object value) {
                        return value == null ? "" : this.delegatee.toString(value);
                    }
                };
                String allPermIdsAsString = CollectionUtils.abbreviate(permIds, (int)-1, (IToStringConverter)toStringConverter, (CollectionStyle)CollectionStyle.NO_BOUNDARY);
                sqlQueryInsertEvent.setParameter("identifiers", (Object)allPermIdsAsString);
                sqlQueryInsertEvent.setParameter("description", (Object)DeletedDataSetLocation.format(locations));
                sqlQueryInsertEvent.executeUpdate();
            }
        }
    }

    private static class DeletionEventSQLs {
        public String selectPermIds;
        public String selectLocations;
        public String deleteProperties;
        public String deleteDataSets;
        public String insertEvent;
        public String deleteExternalData;
        public String deleteContentCopies;
        public String deleteChildrenConnections;
        public String deleteParentConnections;
        public String selectPropertyHistory;
        public String selectRelationshipHistory;
        public String selectAttributes;

        private DeletionEventSQLs() {
        }
    }

    private static final class StatusUpdater
    implements HibernateCallback {
        private final boolean presentInArchive;
        private final DataSetArchivingStatus status;
        private final List<String> codes;

        private StatusUpdater(boolean presentInArchive, DataSetArchivingStatus status, List<String> codes) {
            this.presentInArchive = presentInArchive;
            this.status = status;
            this.codes = codes;
        }

        public final Object doInHibernate(Session session) throws HibernateException {
            Query query = this.presentInArchive ? session.createQuery("UPDATE " + EXTERNAL_DATA_TABLE_NAME + " SET status = :status, presentInArchive = :presentInArchive,      archivingRequested = 'f' WHERE code IN (:codes) ") : session.createQuery("UPDATE " + EXTERNAL_DATA_TABLE_NAME + " SET status = :status, presentInArchive = :presentInArchive WHERE code IN (:codes) ");
            int result = query.setParameter("status", (Object)this.status).setParameter("presentInArchive", (Object)this.presentInArchive).setParameterList("codes", this.codes).executeUpdate();
            System.err.println(result + " updated");
            System.err.println(DataDAO.updateVersion(session, this.codes) + " updated version");
            return result;
        }
    }
}

