/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class DataStoreDAO
extends AbstractDAO
implements IDataStoreDAO {
    private static final Class<DataStorePE> ENTITY_CLASS = DataStorePE.class;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataStoreDAO.class);

    public DataStoreDAO(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public void createOrUpdateDataStore(DataStorePE dataStore) {
        assert (dataStore != null) : "Unspecified data store";
        HibernateTemplate template = this.getHibernateTemplate();
        dataStore.setCode(CodeConverter.tryToDatabase(dataStore.getCode()));
        template.saveOrUpdate((Object)dataStore);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("SAVE/UPDATE: data store '%s'.", dataStore));
        }
    }

    @Override
    public DataStorePE tryToFindDataStoreByCode(final String dataStoreCode) {
        assert (dataStoreCode != null) : "Unspecified data store code.";
        return (DataStorePE)this.getHibernateTemplate().executeWithNativeSession((HibernateCallback)new HibernateCallback<DataStorePE>(){

            public DataStorePE doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(DataStorePE.class);
                criteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(dataStoreCode)));
                return (DataStorePE)criteria.uniqueResult();
            }
        });
    }

    @Override
    public List<DataStorePE> listDataStores() {
        return (List)this.getHibernateTemplate().executeWithNativeSession((HibernateCallback)new HibernateCallback<List<DataStorePE>>(){

            public List<DataStorePE> doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(ENTITY_CLASS);
                criteria.setFetchMode("servicesInternal", FetchMode.JOIN);
                criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
                List<DataStorePE> list = AbstractDAO.cast(criteria.list());
                if (operationLog.isDebugEnabled()) {
                    operationLog.debug((Object)String.format("%d data stores have been found.", list.size()));
                }
                return list;
            }
        });
    }
}

