/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationSchedulerWithQueue;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Transaction;

public class DynamicPropertiesInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 35L;
    private IDynamicPropertyEvaluationSchedulerWithQueue dynamicPropertyScheduler;
    private static ThreadLocal<Boolean> wasCommited = new ThreadLocal();

    public void setDynamicPropertyScheduler(IDynamicPropertyEvaluationSchedulerWithQueue dynamicPropertyScheduler) {
        this.dynamicPropertyScheduler = dynamicPropertyScheduler;
    }

    public void beforeTransactionCompletion(Transaction tx) {
        wasCommited.set(Boolean.TRUE);
    }

    public void afterTransactionCompletion(Transaction tx) {
        if (!Boolean.TRUE.equals(wasCommited.get())) {
            try {
                this.dynamicPropertyScheduler.synchronizeThreadQueue();
            }
            finally {
                wasCommited.set(null);
            }
        } else {
            this.dynamicPropertyScheduler.clearThreadQueue();
        }
    }
}

