/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.DetachedCriteria;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;

final class EntityTypeDAO
extends AbstractTypeDAO<EntityTypePE>
implements IEntityTypeDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, EntityTypeDAO.class);
    private final EntityKind entityKind;
    private final IDAOFactory daoFactory;

    EntityTypeDAO(EntityKind entityKind, SessionFactory sessionFactory, EntityHistoryCreator historyCreator, IDAOFactory daoFactory) {
        super(sessionFactory, entityKind.getTypeClass(), historyCreator);
        this.entityKind = entityKind;
        this.daoFactory = daoFactory;
    }

    @Override
    public final EntityTypePE tryToFindEntityTypeByCode(String code) throws DataAccessException {
        return (EntityTypePE)super.tryFindTypeByCode(code);
    }

    @Override
    public final List<EntityTypePE> tryToFindEntityTypeByCodes(List<String> codes) throws DataAccessException {
        return super.tryFindTypeByCodes(codes, true);
    }

    @Override
    public final <T extends EntityTypePE> List<T> listEntityTypes() throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        String entityKindName = this.entityKind.getLabel();
        criteria.setFetchMode(entityKindName + "TypePropertyTypesInternal", FetchMode.JOIN);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List list = EntityTypeDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        return list;
    }

    @Override
    public final <T extends EntityTypePE> void createOrUpdateEntityType(T entityType) throws DataAccessException {
        assert (entityType != null) : "entityType is null";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        EntityTypeDAO.validatePE(entityType);
        entityType.setCode(CodeConverter.tryToDatabase(entityType.getCode()));
        hibernateTemplate.saveOrUpdate(entityType);
        hibernateTemplate.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("ADD: entity type '%s'.", entityType));
        }
        if (entityType instanceof SampleTypePE) {
            ISampleDAO sampleDAO = this.daoFactory.getSampleDAO();
            List<TechId> sampleIds = sampleDAO.listSampleIdsBySampleTypeIds(Arrays.asList(new TechId(entityType.getId())));
            EntityTypeDAO.scheduleDynamicPropertiesEvaluationForIds(this.daoFactory.getPersistencyResources().getDynamicPropertyEvaluationScheduler(), SamplePE.class, TechId.asLongs(sampleIds));
        }
    }

    @Override
    public final <T extends EntityTypePE> void deleteEntityType(T entityType) {
        assert (entityType != null) : "Entity Type unspecified";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        hibernateTemplate.delete(entityType);
        hibernateTemplate.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("DELETE: entity type '%s'.", entityType));
        }
    }
}

