/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEventDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.event.DeleteDataSetEventParser;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class EventDAO
extends AbstractGenericEntityDAO<EventPE>
implements IEventDAO {
    private static final Class<EventPE> ENTITY_CLASS = EventPE.class;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, EventPE.class);

    public EventDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, ENTITY_CLASS, historyCreator);
    }

    @Override
    public EventPE tryFind(String identifier, EventPE.EntityType entityType, EventType eventType) {
        assert (identifier != null) : "Unspecified identifier.";
        assert (entityType != null) : "Unspecified entityType.";
        assert (eventType != null) : "Unspecified eventType.";
        Criteria criteria = this.currentSession().createCriteria(EventPE.class);
        criteria.add((Criterion)Restrictions.like((String)"identifiersInternal", (String)identifier, (MatchMode)MatchMode.ANYWHERE));
        criteria.add((Criterion)Restrictions.eq((String)"entityType", (Object)((Object)entityType)));
        criteria.add((Criterion)Restrictions.eq((String)"eventType", (Object)((Object)eventType)));
        EventPE result = (EventPE)EventDAO.tryGetEntity(criteria.uniqueResult());
        if (operationLog.isDebugEnabled()) {
            String methodName = MethodUtils.getCurrentMethod().getName();
            operationLog.debug((Object)String.format("%s: '%s'.", methodName, result));
        }
        return result;
    }

    @Override
    public List<DeletedDataSet> listDeletedDataSets(Long lastSeenDeletionEventIdOrNull, Date maxDeletionDataOrNull) {
        DetachedCriteria criteria = DetachedCriteria.forClass(EventPE.class);
        if (lastSeenDeletionEventIdOrNull != null) {
            criteria.add((Criterion)Restrictions.gt((String)"id", (Object)lastSeenDeletionEventIdOrNull));
        }
        if (maxDeletionDataOrNull != null) {
            criteria.add((Criterion)Restrictions.lt((String)"registrationDate", (Object)maxDeletionDataOrNull));
        }
        criteria.add((Criterion)Restrictions.eq((String)"eventType", (Object)((Object)EventType.DELETION)));
        criteria.add((Criterion)Restrictions.eq((String)"entityType", (Object)((Object)EventPE.EntityType.DATASET)));
        List<EventPE> list = EventDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            String lastDesc = lastSeenDeletionEventIdOrNull == null ? "all" : "id > " + lastSeenDeletionEventIdOrNull;
            operationLog.debug((Object)String.format("%s(%s): %d data set deletion events(s) have been found.", MethodUtils.getCurrentMethod().getName(), lastDesc, list.size()));
        }
        ArrayList<DeletedDataSet> result = new ArrayList<DeletedDataSet>();
        for (EventPE event : list) {
            DeleteDataSetEventParser parser = new DeleteDataSetEventParser(event);
            result.addAll(parser.getDeletedDatasets());
        }
        return result;
    }

    @Override
    public List<EventPE> listEvents(EventType eventType, EventPE.EntityType entityTypeOrNull, Date lastSeenTimestampOrNull, Integer limitOrNull) {
        DetachedCriteria criteria = DetachedCriteria.forClass(EventPE.class);
        criteria.addOrder(Order.asc((String)"registrationDate"));
        criteria.addOrder(Order.asc((String)"id"));
        criteria.add((Criterion)Restrictions.eq((String)"eventType", (Object)((Object)eventType)));
        if (entityTypeOrNull != null) {
            criteria.add((Criterion)Restrictions.eq((String)"entityType", (Object)((Object)entityTypeOrNull)));
        }
        if (lastSeenTimestampOrNull != null) {
            criteria.add((Criterion)Restrictions.gt((String)"registrationDate", (Object)lastSeenTimestampOrNull));
        }
        int limit = limitOrNull != null ? limitOrNull : 1;
        List<EventPE> list = EventDAO.cast(this.getHibernateTemplate().findByCriteria(criteria, 0, limit));
        if (list.size() == limit) {
            Date lastRegistrationDate = list.get(list.size() - 1).getRegistrationDateInternal();
            criteria.add((Criterion)Restrictions.le((String)"registrationDate", (Object)lastRegistrationDate));
            List remainderList = EventDAO.cast(this.getHibernateTemplate().findByCriteria(criteria, limit, Integer.MAX_VALUE));
            if (remainderList.size() > 0) {
                ArrayList<EventPE> fullList = new ArrayList<EventPE>(list);
                fullList.addAll(remainderList);
                list = fullList;
            }
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s, %s): %d events(s) have been found.", new Object[]{MethodUtils.getCurrentMethod().getName(), eventType, entityTypeOrNull, list.size()}));
        }
        return list;
    }
}

