/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEventsSearchDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventsSearchPE;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class EventsSearchDAO
extends AbstractGenericEntityDAO<EventsSearchPE>
implements IEventsSearchDAO {
    private static final Class<EventsSearchPE> ENTITY_CLASS = EventsSearchPE.class;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, EventsSearchPE.class);

    public EventsSearchDAO(SessionFactory sessionFactory) {
        super(sessionFactory, ENTITY_CLASS, null);
    }

    @Override
    public void createOrUpdate(EventsSearchPE eventsSearchPE) {
        this.getHibernateTemplate().saveOrUpdate((Object)eventsSearchPE);
    }

    @Override
    public Date getLastTimestamp(EventType eventType, EventPE.EntityType entityType) {
        Date lastTimestamp;
        DetachedCriteria criteria = DetachedCriteria.forClass(EventsSearchPE.class);
        criteria.setProjection((Projection)Projections.max((String)"registrationTimestamp"));
        criteria.add((Criterion)Restrictions.eq((String)"eventType", (Object)((Object)eventType)));
        criteria.add((Criterion)Restrictions.eq((String)"entityType", (Object)((Object)entityType)));
        List list = EventsSearchDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        Date date = lastTimestamp = list.isEmpty() ? null : (Date)list.get(0);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s, %s): last timestamp = %s.", new Object[]{MethodUtils.getCurrentMethod().getName(), eventType, entityType, lastTimestamp}));
        }
        return lastTimestamp;
    }
}

