/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityWithPropertiesDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IDetachedCriteriaFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.Select;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class ExperimentDAO
extends AbstractGenericEntityWithPropertiesDAO<ExperimentPE>
implements IExperimentDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ExperimentDAO.class);
    private final IExperimentSampleQuery experimentSampleQuery = (IExperimentSampleQuery)QueryTool.getManagedQuery(IExperimentSampleQuery.class);
    private static final String ENTITY_TYPE = "case when h.proj_id is not null then 'PROJECT' when h.samp_id is not null then 'SAMPLE' when h.data_id is not null then 'DATA_SET' else 'UNKNOWN' end as entity_type";

    protected ExperimentDAO(PersistencyResources persistencyResources, EntityHistoryCreator historyCreator) {
        super(persistencyResources, ExperimentPE.class, historyCreator);
    }

    @Override
    public List<ExperimentPE> listExperimentsWithProperties(List<ProjectPE> projects, boolean onlyHavingSamples, boolean onlyHavingDataSets) throws DataAccessException {
        if (projects == null || projects.isEmpty()) {
            throw new IllegalArgumentException("Projects were not set");
        }
        return this.listExperimentsWithProperties(null, projects, null, onlyHavingSamples, onlyHavingDataSets);
    }

    @Override
    public List<ExperimentPE> listExperimentsWithProperties(SpacePE space) throws DataAccessException {
        if (space == null) {
            throw new IllegalArgumentException("Space wasn't set");
        }
        return this.listExperimentsWithProperties(null, null, space);
    }

    @Override
    public List<ExperimentPE> listExperimentsWithProperties(ExperimentTypePE experimentTypeOrNull, ProjectPE projectOrNull, SpacePE spaceOrNull) throws DataAccessException {
        List<ProjectPE> projectsOrNull = projectOrNull != null ? Collections.singletonList(projectOrNull) : null;
        return this.listExperimentsWithProperties(experimentTypeOrNull, projectsOrNull, spaceOrNull, false, false);
    }

    @Override
    public List<ExperimentPE> listExperimentsWithProperties(ExperimentTypePE experimentTypeOrNull, List<ProjectPE> projectsOrNull, SpacePE spaceOrNull, boolean onlyHavingSamples, boolean onlyHavingDataSets) throws DataAccessException {
        DetachedCriteria criteria = this.createCriteriaForUndeleted();
        if (experimentTypeOrNull != null) {
            criteria.add((Criterion)Restrictions.eq((String)"experimentType", (Object)experimentTypeOrNull));
        }
        if (projectsOrNull != null && !projectsOrNull.isEmpty()) {
            criteria.add(Restrictions.in((String)"projectInternal", projectsOrNull));
        }
        if (spaceOrNull != null) {
            criteria.createAlias("projectInternal", "project");
            criteria.add((Criterion)Restrictions.eq((String)"project.space", (Object)spaceOrNull));
        }
        if (onlyHavingSamples) {
            criteria.add(Restrictions.isNotEmpty((String)"experimentSamples"));
        }
        if (onlyHavingDataSets) {
            criteria.add(Restrictions.isNotEmpty((String)"experimentDataSets"));
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List<ExperimentPE> list = ExperimentDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d experiments have been found for projects '%s'%s.", list.size(), projectsOrNull, experimentTypeOrNull == null ? "" : " and experiment type '" + experimentTypeOrNull + "'"));
        }
        return list;
    }

    @Override
    public List<ExperimentPE> listExperimentsWithProperties(Collection<Long> experimentIDs) throws DataAccessException {
        if (experimentIDs == null || experimentIDs.isEmpty()) {
            return new ArrayList<ExperimentPE>();
        }
        List<ExperimentPE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass(ExperimentDAO.this.getEntityClass());
                criteria.setFetchMode("experimentProperties", FetchMode.JOIN);
                criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
                return criteria;
            }
        }, "id", experimentIDs);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d experiments have been found for specified IDs.", list.size()));
        }
        return list;
    }

    @Override
    public List<ExperimentPE> listExperiments() throws DataAccessException {
        DetachedCriteria criteria = this.createCriteriaForUndeleted();
        List<ExperimentPE> list = ExperimentDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d experiment(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    private DetachedCriteria createCriteriaForUndeleted() {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.add(Restrictions.isNull((String)"deletion"));
        return criteria;
    }

    @Override
    public ExperimentPE tryFindByCodeAndProject(ProjectPE project, String experimentCode) {
        assert (experimentCode != null) : "Unspecified experiment code.";
        assert (project != null) : "Unspecified project.";
        Criteria criteria = this.currentSession().createCriteria(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(experimentCode)));
        criteria.add((Criterion)Restrictions.eq((String)"projectInternal", (Object)project));
        criteria.setFetchMode("experimentType.experimentTypePropertyTypesInternal", FetchMode.JOIN);
        ExperimentPE experiment = (ExperimentPE)criteria.uniqueResult();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Following experiment '%s' has been found for code '%s' and project '%s'.", experiment, experimentCode, project));
        }
        return experiment;
    }

    @Override
    public List<ExperimentPE> listByProjectAndCodes(ProjectPE project, Collection<String> experimentCodes) {
        assert (project != null) : "Unspecified project.";
        assert (experimentCodes != null) : "Unspecified experiment codes.";
        LinkedList<String> dbExperimentCodes = new LinkedList<String>();
        for (String experimentCode : experimentCodes) {
            dbExperimentCodes.add(CodeConverter.tryToDatabase(experimentCode));
        }
        Criteria criteria = this.currentSession().createCriteria(this.getEntityClass());
        criteria.add(Restrictions.in((String)"code", dbExperimentCodes));
        criteria.add((Criterion)Restrictions.eq((String)"projectInternal", (Object)project));
        List<ExperimentPE> experiments = ExperimentDAO.cast(criteria.list());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Found %s experiments", experiments.size()));
        }
        return experiments;
    }

    @Override
    public List<ExperimentPE> listExperimentsByProjectAndProperty(String propertyCode, String propertyValue, ProjectPE project) throws DataAccessException {
        assert (project != null) : "Unspecified space.";
        assert (propertyCode != null) : "Unspecified property code";
        assert (propertyValue != null) : "Unspecified property value";
        String queryFormat = "from " + ExperimentPropertyPE.class.getSimpleName() + " where %s = ? and entity.projectInternal = ?  and entityTypePropertyType.propertyTypeInternal.simpleCode = ? and entityTypePropertyType.propertyTypeInternal.managedInternally = ?";
        List<ExperimentPE> entities = this.listByPropertyValue(queryFormat, propertyCode, propertyValue, project);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d experiments have been found for project '%s' and property '%s' equal to '%s'.", entities.size(), project, propertyCode, propertyValue));
        }
        return entities;
    }

    private List<ExperimentPE> listByPropertyValue(String queryFormat, String propertyCode, String propertyValue, ProjectPE project) {
        String simplePropertyCode = CodeConverter.tryToDatabase(propertyCode);
        boolean isInternalNamespace = CodeConverter.isInternalNamespace(propertyCode);
        Object[] arguments = ExperimentDAO.toArray(propertyValue, project, simplePropertyCode, isInternalNamespace);
        String queryPropertySimpleValue = String.format(queryFormat, "value");
        List<ExperimentPropertyPE> properties1 = ExperimentDAO.cast(this.getHibernateTemplate().find(queryPropertySimpleValue, arguments));
        String queryPropertyVocabularyTerm = String.format(queryFormat, "vocabularyTerm.code");
        List properties2 = ExperimentDAO.cast(this.getHibernateTemplate().find(queryPropertyVocabularyTerm, arguments));
        properties1.addAll(properties2);
        List<ExperimentPE> entities = ExperimentDAO.extractEntities(properties1);
        return entities;
    }

    private static List<ExperimentPE> extractEntities(List<ExperimentPropertyPE> properties) {
        ArrayList<ExperimentPE> samples = new ArrayList<ExperimentPE>();
        for (ExperimentPropertyPE prop : properties) {
            samples.add(prop.getEntity());
        }
        return samples;
    }

    @Override
    public ExperimentPE tryGetByPermID(String permId) {
        Criteria criteria = this.currentSession().createCriteria(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"permId", (Object)permId));
        ExperimentPE experimentOrNull = (ExperimentPE)criteria.uniqueResult();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Following experiment '%s' has been found for permId '%s'.", experimentOrNull, permId));
        }
        return experimentOrNull;
    }

    @Override
    public List<SpacePE> listSpacesByExperimentIds(Collection<Long> experimentIds) {
        final ArrayList<Long> allIds = new ArrayList<Long>(experimentIds);
        final String query = "from " + SpacePE.class.getSimpleName() + " as s where s.id in (select p.space.id from " + ProjectPE.class.getSimpleName() + " as p where p.id in (select e.projectInternal.id from " + ExperimentPE.class.getSimpleName() + " as e where e.id in (:ids)))";
        final ArrayList<SpacePE> result = new ArrayList<SpacePE>();
        BatchOperationExecutor.executeInBatches(new IBatchOperation<Long>(){

            @Override
            public void execute(List<Long> ids) {
                List spaces = AbstractDAO.cast(ExperimentDAO.this.getHibernateTemplate().findByNamedParam(query, "ids", ids));
                result.addAll(spaces);
            }

            @Override
            public List<Long> getAllEntities() {
                return allIds;
            }

            @Override
            public String getEntityName() {
                return "space";
            }

            @Override
            public String getOperationName() {
                return "listSpacesByDataSetIds";
            }
        });
        return result;
    }

    @Override
    public List<ExperimentPE> listByPermID(Collection<String> permIds) {
        return this.listByIDsOfName("permId", permIds);
    }

    @Override
    public List<ExperimentPE> listByIDs(Collection<Long> ids) {
        return this.listByIDsOfName("id", ids);
    }

    private List<ExperimentPE> listByIDsOfName(String idName, Collection<?> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<ExperimentPE>();
        }
        List<ExperimentPE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), ExperimentPE.class, idName, ids);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d experiment(s) have been found.", list.size()));
        }
        return list;
    }

    private List<Long> getSampleIds(ExperimentPE experiment) {
        return this.experimentSampleQuery.getExperimentSampleIds(experiment.getId());
    }

    @Override
    public List<String> getSampleCodes(ExperimentPE experiment) {
        return this.experimentSampleQuery.getExperimentSampleCodes(experiment.getId());
    }

    @Override
    public void createOrUpdateExperiment(ExperimentPE experiment, PersonPE modifier) {
        HibernateTemplate template = this.getHibernateTemplate();
        this.lockEntity(experiment.getProject());
        this.internalCreateOrUpdateExperiment(experiment, modifier, template);
        template.flush();
        this.scheduleDynamicPropertiesEvaluation(Collections.singletonList(experiment));
        ExperimentDAO.scheduleDynamicPropertiesEvaluationWithIds(this.getDynamicPropertyEvaluatorScheduler(), SamplePE.class, this.getSampleIds(experiment));
    }

    @Override
    public void createOrUpdateExperiments(List<ExperimentPE> experiments, PersonPE modifier, boolean clearCache) {
        assert (experiments != null && experiments.size() > 0) : "Unspecified or empty experiments.";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        for (ExperimentPE experiment : experiments) {
            this.internalCreateOrUpdateExperiment(experiment, modifier, hibernateTemplate);
        }
        hibernateTemplate.flush();
        if (clearCache) {
            hibernateTemplate.clear();
        }
        this.scheduleDynamicPropertiesEvaluation(experiments);
    }

    private void internalCreateOrUpdateExperiment(ExperimentPE experiment, PersonPE modifier, HibernateTemplate hibernateTemplate) {
        assert (experiment != null) : "Missing experiment.";
        experiment.setCode(CodeConverter.tryToDatabase(experiment.getCode()));
        if (experiment.getModificationDate() == null) {
            experiment.setModificationDate(this.getTransactionTimeStamp());
        }
        ExperimentDAO.validatePE(experiment);
        HibernateTemplate template = this.getHibernateTemplate();
        template.saveOrUpdate((Object)experiment);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("ADD: experiment '%s'.", experiment));
        }
    }

    @Override
    public void delete(List<TechId> experimentIds, PersonPE registrator, String reason) throws DataAccessException {
        String experimentsTable = "experiments_all";
        String sqlSelectPermIds = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createSelectPermIdsSQL("experiments_all");
        String sqlDeleteProperties = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeletePropertiesSQL("experiment_properties", "expe_id");
        String sqlDeleteAttachments = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeleteAttachmentsSQL("expe_id");
        String sqlDeleteExperiments = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeleteEnitiesSQL("experiments_all");
        String sqlInsertEvent = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createInsertEventSQL();
        String sqlSelectPropertyHistory = ExperimentDAO.createQueryPropertyHistorySQL();
        String sqlSelectRelationshipHistory = ExperimentDAO.createQueryRelationshipHistorySQL();
        String sqlSelectAttributes = ExperimentDAO.createQueryAttributesSQL();
        this.executePermanentDeleteAction(EventPE.EntityType.EXPERIMENT, experimentIds, registrator, reason, sqlSelectPermIds, sqlDeleteProperties, sqlDeleteAttachments, sqlDeleteExperiments, sqlInsertEvent, sqlSelectPropertyHistory, sqlSelectRelationshipHistory, sqlSelectAttributes, null, AttachmentHolderKind.EXPERIMENT);
    }

    private static String createQueryPropertyHistorySQL() {
        return "(SELECT e.perm_id, pt.code, coalesce(h.value, h.vocabulary_term, h.material) as value, p.user_id, h.valid_from_timestamp, h.valid_until_timestamp FROM experiments_all e, experiment_properties_history h, experiment_type_property_types etpt, property_types pt, persons p WHERE h.expe_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " AND e.id=h.expe_id AND h.etpt_id=etpt.id AND etpt.prty_id = pt.id AND pers_id_author = p.id ) UNION (SELECT e.perm_id, pt.code, coalesce(value, (SELECT (t.code || ' [' || v.code || ']') FROM controlled_vocabulary_terms as t JOIN controlled_vocabularies as v ON t.covo_id = v.id WHERE t.id = pr.cvte_id), (SELECT (m.code || ' [' || mt.code || ']') FROM materials AS m JOIN material_types AS mt ON m.maty_id = mt.id WHERE m.id = pr.mate_prop_id)) as value, author.user_id, pr.modification_timestamp, null FROM experiments_all e, experiment_properties pr, experiment_type_property_types etpt, property_types pt, persons author WHERE pr.expe_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " AND e.id = pr.expe_id AND pr.etpt_id = etpt.id AND etpt.prty_id = pt.id AND pr.pers_id_author = author.id ) ORDER BY 1, valid_from_timestamp";
    }

    private static String createQueryRelationshipHistorySQL() {
        return "SELECT e.perm_id, h.relation_type, h.entity_perm_id, case when h.proj_id is not null then 'PROJECT' when h.samp_id is not null then 'SAMPLE' when h.data_id is not null then 'DATA_SET' else 'UNKNOWN' end as entity_type, p.user_id, h.valid_from_timestamp, h.valid_until_timestamp FROM experiments_all e, experiment_relationships_history h, persons p WHERE e.id = h.main_expe_id AND h.main_expe_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " AND h.pers_id_author = p.id ORDER BY 1, valid_from_timestamp";
    }

    private static String createQueryAttributesSQL() {
        return "SELECT e.id, e.perm_id, e.code, t.code as entity_type, e.registration_timestamp, r.user_id as registrator, e.is_public FROM experiments_all e JOIN experiment_types t on e.exty_id = t.id JOIN persons r on e.pers_id_registerer = r.id WHERE e.id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds();
    }

    @Override
    Logger getLogger() {
        return operationLog;
    }

    public static interface IExperimentSampleQuery
    extends BaseQuery {
        @Select(sql="select id from samples s where expe_id = ?{1}")
        public List<Long> getExperimentSampleIds(long var1);

        @Select(sql="select code from samples s where expe_id = ?{1}")
        public List<String> getExperimentSampleCodes(long var1);
    }
}

