/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExternalDataManagementSystemDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataManagementSystemPE;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class ExternalDataManagementSystemDAO
extends AbstractDAO
implements IExternalDataManagementSystemDAO {
    private static final Class<ExternalDataManagementSystemPE> ENTITY_CLASS = ExternalDataManagementSystemPE.class;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ExternalDataManagementSystemDAO.class);

    public ExternalDataManagementSystemDAO(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public void createOrUpdateExternalDataManagementSystem(ExternalDataManagementSystemPE externalDataManagementSystem) {
        assert (externalDataManagementSystem != null) : "Unspecified external data management system.";
        HibernateTemplate template = this.getHibernateTemplate();
        externalDataManagementSystem.setCode(CodeConverter.tryToDatabase(externalDataManagementSystem.getCode()));
        template.saveOrUpdate((Object)externalDataManagementSystem);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("SAVE/UPDATE: external data management system '%s'.", externalDataManagementSystem));
        }
    }

    @Override
    public ExternalDataManagementSystemPE tryToFindExternalDataManagementSystemById(Long id) {
        assert (id != null) : "Unspecified external data management system id.";
        Criteria criteria = this.currentSession().createCriteria(ENTITY_CLASS);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)id));
        return (ExternalDataManagementSystemPE)criteria.uniqueResult();
    }

    @Override
    public ExternalDataManagementSystemPE tryToFindExternalDataManagementSystemByCode(String externalDataManagementSystemCode) {
        assert (externalDataManagementSystemCode != null) : "Unspecified external data management system code.";
        Criteria criteria = this.currentSession().createCriteria(ENTITY_CLASS);
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(externalDataManagementSystemCode)));
        return (ExternalDataManagementSystemPE)criteria.uniqueResult();
    }

    @Override
    public List<ExternalDataManagementSystemPE> listExternalDataManagementSystems() {
        Criteria criteria = this.currentSession().createCriteria(ENTITY_CLASS);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List<ExternalDataManagementSystemPE> list = ExternalDataManagementSystemDAO.cast(criteria.list());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d external data management systems have been found.", list.size()));
        }
        return list;
    }

    @Override
    public void delete(Collection<ExternalDataManagementSystemPE> externalDms) {
        Session session = this.currentSession();
        String hql = "DELETE FROM ContentCopyPE WHERE externalDataManagementSystem IN :externalDms";
        session.createQuery(hql).setParameterList("externalDms", externalDms).executeUpdate();
        for (ExternalDataManagementSystemPE edms : externalDms) {
            session.delete((Object)edms);
        }
    }

    @Override
    public List<ExternalDataManagementSystemPE> listExternalDataManagementSystems(Collection<Long> ids) {
        Criteria criteria = this.currentSession().createCriteria(ENTITY_CLASS);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        criteria.add(Restrictions.in((String)"id", ids));
        List<ExternalDataManagementSystemPE> list = ExternalDataManagementSystemDAO.cast(criteria.list());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d external data management systems have been found.", list.size()));
        }
        return list;
    }
}

