/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IGridCustomFilterDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomFilterPE;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class GridCustomFilterDAO
extends AbstractGenericEntityDAO<GridCustomFilterPE>
implements IGridCustomFilterDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, GridCustomFilterDAO.class);

    public GridCustomFilterDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, GridCustomFilterPE.class, historyCreator);
    }

    @Override
    public void createFilter(GridCustomFilterPE filter) {
        assert (filter != null) : "Unspecified filter";
        this.persist(filter);
    }

    @Override
    public List<GridCustomFilterPE> listFilters(String gridId) {
        assert (gridId != null) : "Unspecified grid ID.";
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"gridId", (Object)gridId));
        List<GridCustomFilterPE> list = GridCustomFilterDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): %d filter(s) have been found.", MethodUtils.getCurrentMethod().getName(), gridId, list.size()));
        }
        return list;
    }
}

