/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractEntitySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AnyFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.BooleanFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberPropertySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.ArchivingStatus;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.Complete;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.AbstractDataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.CompleteSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.StatusSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.search.ExperimentSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.ExternalDmsAddressType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.search.ExternalDmsTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.fetchoptions.GlobalSearchObjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchObjectKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.search.MaterialSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.AbstractSampleSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.search.TagSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.AbstractLocalSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.DataSetSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.ExperimentSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.GlobalSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.IGlobalSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.ILocalSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.MaterialSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.SampleSearchManager;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IHibernateSearchDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.HibernateSearchDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.AuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CompareType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchSubCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SearchableEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

public class HibernateSearchDAOV3Adaptor
implements IHibernateSearchDAO {
    private static final String DAO_FACTORY = "dao-factory";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, HibernateSearchDAOV3Adaptor.class);
    private GlobalSearchManager globalSearchManager;
    private MaterialSearchManager materialSearchManager;
    private ExperimentSearchManager experimentSearchManager;
    private SampleSearchManager sampleSearchManager;
    private DataSetSearchManager dataSetSearchManager;
    private static String IS_NUMBER = "SELECT COUNT(*) > 0 FROM property_types WHERE code = :code AND (daty_id = (SELECT id FROM data_types WHERE code = 'INTEGER') OR daty_id = (SELECT id FROM data_types WHERE code = 'REAL'))";
    private static String IS_DATE = "SELECT COUNT(*) > 0 FROM property_types WHERE code = :code AND (daty_id = (SELECT id FROM data_types WHERE code = 'TIMESTAMP'))";
    private AuthorizationConfig authorizationConfig;

    @Override
    public List<MatchingEntity> searchEntitiesByTerm(String userId, SearchableEntity searchableEntity, String searchTerm, HibernateSearchDataProvider dataProvider, boolean useWildcardSearchMode, int alreadyFoundEntities, int maxSize) throws DataAccessException {
        DAOFactory daoFactory;
        PersonPE personPE;
        operationLog.info((Object)("TO ADAPT [FULL TEXT SEARCH] : " + (Object)((Object)searchableEntity) + " [" + searchTerm + "] Wildcards: [" + useWildcardSearchMode + "]"));
        if (StringUtils.isBlank((CharSequence)searchTerm)) {
            throw new AssertionError((Object)"searchTerm is empty");
        }
        if (searchableEntity == null) {
            throw new AssertionError((Object)"searchableEntity == null");
        }
        if (dataProvider == null) {
            throw new AssertionError((Object)"dataProvider == null");
        }
        if (useWildcardSearchMode) {
            operationLog.warn((Object)"TO ADAPT [FULL TEXT SEARCH] : useWildcardSearchMode not supported");
            this.throwUnsupportedOperationException("useWildcardSearchMode not supported");
        }
        if (maxSize != Integer.MAX_VALUE) {
            HibernateSearchDAOV3Adaptor.throwIllegalArgumentException("maxSize != Integer.MAX_VALUE");
        }
        if ((personPE = (daoFactory = (DAOFactory)CommonServiceProvider.getApplicationContext().getBean(DAO_FACTORY)).getPersonDAO().tryFindPersonByUserId(userId)) == null) {
            HibernateSearchDAOV3Adaptor.throwIllegalArgumentException("userId: '" + userId + "' not found on database.");
        }
        GlobalSearchCriteria globalSearchCriteria = this.getCriteria(searchableEntity);
        if (searchTerm.startsWith("\"") && searchTerm.endsWith("\"")) {
            globalSearchCriteria.withText().thatContainsExactly(searchTerm.substring(1, searchTerm.length() - 1));
        } else {
            globalSearchCriteria.withText().thatContains(searchTerm);
        }
        operationLog.info((Object)("ADAPTED [FULL TEXT SEARCH] : " + (Object)((Object)searchableEntity) + " [" + searchTerm + "] " + useWildcardSearchMode));
        GlobalSearchObjectFetchOptions fetchOptions = new GlobalSearchObjectFetchOptions();
        fetchOptions.withMatch();
        Collection<Map<String, Object>> newShortResults = this.getGlobalSearchManager().searchForIDs(personPE.getId(), this.getAuthorisationInformation(personPE), globalSearchCriteria, "id", Collections.singleton(this.getObjectKind(searchableEntity)), fetchOptions, false);
        Collection<Map<String, Object>> newResults = this.getGlobalSearchManager().searchForDetails(newShortResults, personPE.getId(), this.getAuthorisationInformation(personPE), globalSearchCriteria, "id", Collections.singleton(this.getObjectKind(searchableEntity)), fetchOptions);
        Collection<MatchingEntity> matchingEntities = this.getGlobalSearchManager().map(newResults, true);
        Map registratorIdByRecordIdentifierMap = newResults.stream().collect(HashMap::new, (supplierMap, record) -> {
            Long registratorId = (Long)record.get("pers_id_registerer");
            if (registratorId != null) {
                supplierMap.put((String)record.get("identifier"), registratorId);
            }
        }, HashMap::putAll);
        List<PersonPE> registrators = daoFactory.getPersonDAO().getPersons(registratorIdByRecordIdentifierMap.values());
        HashMap<Long, PersonPE> registratorsById = new HashMap<Long, PersonPE>();
        for (PersonPE registrator : registrators) {
            registratorsById.put(registrator.getId(), registrator);
        }
        for (MatchingEntity matchingEntity : matchingEntities) {
            Long registratorId = (Long)registratorIdByRecordIdentifierMap.get(matchingEntity.getIdentifier());
            PersonPE registratorPersonPE = (PersonPE)registratorsById.get(registratorId);
            Person registrator = new Person();
            registrator.setFirstName(registratorPersonPE.getFirstName());
            registrator.setLastName(registratorPersonPE.getLastName());
            registrator.setUserId(registratorPersonPE.getUserId());
            registrator.setEmail(registratorPersonPE.getEmail());
            registrator.setActive(registratorPersonPE.isActive());
            matchingEntity.setRegistrator(registrator);
        }
        return new ArrayList<MatchingEntity>(matchingEntities);
    }

    private IGlobalSearchManager getGlobalSearchManager() {
        if (this.globalSearchManager == null) {
            this.globalSearchManager = (GlobalSearchManager)CommonServiceProvider.getApplicationContext().getBean("global-search-manager");
        }
        return this.globalSearchManager;
    }

    private GlobalSearchCriteria getCriteria(SearchableEntity entityKind) {
        GlobalSearchCriteria globalSearchCriteria = new GlobalSearchCriteria();
        switch (entityKind) {
            case MATERIAL: {
                globalSearchCriteria.withObjectKind().thatIn(new GlobalSearchObjectKind[]{GlobalSearchObjectKind.MATERIAL});
                break;
            }
            case EXPERIMENT: {
                globalSearchCriteria.withObjectKind().thatIn(new GlobalSearchObjectKind[]{GlobalSearchObjectKind.EXPERIMENT});
                break;
            }
            case SAMPLE: {
                globalSearchCriteria.withObjectKind().thatIn(new GlobalSearchObjectKind[]{GlobalSearchObjectKind.SAMPLE});
                break;
            }
            case DATA_SET: {
                globalSearchCriteria.withObjectKind().thatIn(new GlobalSearchObjectKind[]{GlobalSearchObjectKind.DATA_SET});
            }
        }
        return globalSearchCriteria;
    }

    private GlobalSearchObjectKind getObjectKind(SearchableEntity entityKind) {
        GlobalSearchObjectKind objectKind;
        switch (entityKind) {
            case MATERIAL: {
                objectKind = GlobalSearchObjectKind.MATERIAL;
                break;
            }
            case EXPERIMENT: {
                objectKind = GlobalSearchObjectKind.EXPERIMENT;
                break;
            }
            case SAMPLE: {
                objectKind = GlobalSearchObjectKind.SAMPLE;
                break;
            }
            case DATA_SET: {
                objectKind = GlobalSearchObjectKind.DATA_SET;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return objectKind;
    }

    @Override
    public int getResultSetSizeLimit() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setProperties(Properties serviceProperties) {
        for (String propertyName : serviceProperties.stringPropertyNames()) {
            operationLog.warn((Object)("Configuration property ignored: " + propertyName));
        }
    }

    @Override
    public List<Long> searchForEntityIds(String userId, DetailedSearchCriteria mainV1Criteria, EntityKind entityKind) {
        operationLog.info((Object)("TO ADAPT [QUERY] : " + (Object)((Object)entityKind) + " [" + mainV1Criteria + "]"));
        DAOFactory daoFactory = (DAOFactory)CommonServiceProvider.getApplicationContext().getBean(DAO_FACTORY);
        PersonPE personPE = daoFactory.getPersonDAO().tryFindPersonByUserId(userId);
        if (personPE == null) {
            HibernateSearchDAOV3Adaptor.throwIllegalArgumentException("userId: '" + userId + "' not found on database.");
        }
        AbstractEntitySearchCriteria<?> mainV3Criteria = this.getCriteria(entityKind);
        switch (mainV1Criteria.getConnection()) {
            case MATCH_ALL: {
                mainV3Criteria.withAndOperator();
                break;
            }
            case MATCH_ANY: {
                mainV3Criteria.withOrOperator();
            }
        }
        for (DetailedSearchCriterion mainV1Criterion : mainV1Criteria.getCriteria()) {
            this.adapt(mainV3Criteria, mainV1Criteria, mainV1Criterion);
        }
        for (DetailedSearchSubCriteria subV1CriteriaPointer : mainV1Criteria.getSubCriterias()) {
            DetailedSearchCriteria subV1Criteria = subV1CriteriaPointer.getCriteria();
            SampleSearchCriteria subV3Criteria = null;
            switch (subV1CriteriaPointer.getTargetEntityKind()) {
                case SAMPLE: {
                    if (!(mainV3Criteria instanceof AbstractDataSetSearchCriteria)) break;
                    subV3Criteria = ((AbstractDataSetSearchCriteria)mainV3Criteria).withSample();
                    break;
                }
                case EXPERIMENT: {
                    if (mainV3Criteria instanceof AbstractSampleSearchCriteria) {
                        subV3Criteria = ((AbstractSampleSearchCriteria)mainV3Criteria).withExperiment();
                        break;
                    }
                    if (!(mainV3Criteria instanceof AbstractDataSetSearchCriteria)) break;
                    subV3Criteria = ((AbstractDataSetSearchCriteria)mainV3Criteria).withExperiment();
                    break;
                }
                case DATA_SET: {
                    break;
                }
                case DATA_SET_PARENT: {
                    if (!(mainV3Criteria instanceof DataSetSearchCriteria)) break;
                    subV3Criteria = ((DataSetSearchCriteria)mainV3Criteria).withParents();
                    break;
                }
                case DATA_SET_CHILD: {
                    if (!(mainV3Criteria instanceof DataSetSearchCriteria)) break;
                    subV3Criteria = ((DataSetSearchCriteria)mainV3Criteria).withChildren();
                    break;
                }
                case DATA_SET_CONTAINER: {
                    if (!(mainV3Criteria instanceof DataSetSearchCriteria)) break;
                    subV3Criteria = ((DataSetSearchCriteria)mainV3Criteria).withContainer();
                    break;
                }
                case SAMPLE_CONTAINER: {
                    if (!(mainV3Criteria instanceof SampleSearchCriteria)) break;
                    subV3Criteria = ((SampleSearchCriteria)mainV3Criteria).withContainer();
                    break;
                }
                case SAMPLE_CHILD: {
                    if (!(mainV3Criteria instanceof SampleSearchCriteria)) break;
                    subV3Criteria = ((SampleSearchCriteria)mainV3Criteria).withChildren();
                    break;
                }
                case SAMPLE_PARENT: {
                    if (!(mainV3Criteria instanceof SampleSearchCriteria)) break;
                    subV3Criteria = ((SampleSearchCriteria)mainV3Criteria).withParents();
                    break;
                }
            }
            if (subV3Criteria == null) {
                this.throwUnsupportedOperationException("TargetEntityKind: " + subV1CriteriaPointer.getTargetEntityKind() + " For V3: " + mainV3Criteria.getClass().getName());
            }
            switch (subV1Criteria.getConnection()) {
                case MATCH_ALL: {
                    subV3Criteria.withAndOperator();
                    break;
                }
                case MATCH_ANY: {
                    subV3Criteria.withOrOperator();
                }
            }
            for (DetailedSearchCriterion subV1Criterion : subV1Criteria.getCriteria()) {
                this.adapt((AbstractEntitySearchCriteria)subV3Criteria, subV1Criteria, subV1Criterion);
            }
        }
        operationLog.info((Object)("ADAPTED [QUERY] : " + mainV3Criteria));
        Set<Long> results = this.getSearchManager(entityKind).searchForIDs(personPE.getId(), this.getAuthorisationInformation(personPE), mainV3Criteria, null, "id");
        return new ArrayList<Long>(results);
    }

    private void adapt(AbstractEntitySearchCriteria v3Criteria, DetailedSearchCriteria v1Criteria, DetailedSearchCriterion v1Criterion) {
        if (v1Criterion.isNegated()) {
            this.throwUnsupportedOperationException("negated");
        }
        for (String value : v1Criterion.getValues()) {
            CompleteSearchCriteria enumFieldSearchCriteria;
            AnyFieldSearchCriteria criterionV3Criteria;
            DetailedSearchFieldKind searchFieldKind = v1Criterion.getField().getKind();
            block1 : switch (searchFieldKind) {
                case ANY_FIELD: {
                    criterionV3Criteria = v3Criteria.withAnyField();
                    break;
                }
                case ANY_PROPERTY: {
                    criterionV3Criteria = v3Criteria.withAnyProperty();
                    break;
                }
                case PROPERTY: {
                    if (v1Criterion.getField().getPropertyCode() == null) {
                        HibernateSearchDAOV3Adaptor.throwIllegalArgumentException("PROPERTY PropertyCode null");
                    }
                    if (this.isNumberProperty(v1Criterion.getField().getPropertyCode())) {
                        criterionV3Criteria = v3Criteria.withNumberProperty(v1Criterion.getField().getPropertyCode());
                        break;
                    }
                    if (this.isDateProperty(v1Criterion.getField().getPropertyCode())) {
                        criterionV3Criteria = v3Criteria.withDateProperty(v1Criterion.getField().getPropertyCode());
                        break;
                    }
                    criterionV3Criteria = v3Criteria.withProperty(v1Criterion.getField().getPropertyCode());
                    break;
                }
                case ATTRIBUTE: {
                    if (v1Criterion.getField().getAttributeCode() == null) {
                        HibernateSearchDAOV3Adaptor.throwIllegalArgumentException("ATTRIBUTE AttributeCode null");
                    }
                    EntityKind entityKind = this.getEntityKind(v3Criteria);
                    switch (entityKind) {
                        case MATERIAL: {
                            criterionV3Criteria = this.withAttribute((MaterialSearchCriteria)v3Criteria, v1Criterion.getField().getAttributeCode());
                            break block1;
                        }
                        case EXPERIMENT: {
                            criterionV3Criteria = this.withAttribute((ExperimentSearchCriteria)v3Criteria, v1Criterion.getField().getAttributeCode());
                            break block1;
                        }
                        case SAMPLE: {
                            criterionV3Criteria = this.withAttribute((AbstractSampleSearchCriteria)v3Criteria, v1Criterion.getField().getAttributeCode());
                            break block1;
                        }
                        case DATA_SET: {
                            criterionV3Criteria = this.withAttribute((AbstractDataSetSearchCriteria)v3Criteria, v1Criterion.getField().getAttributeCode());
                            break block1;
                        }
                    }
                    HibernateSearchDAOV3Adaptor.throwIllegalArgumentException(String.format("Unexpected entityKind. entityKind=%s.", new Object[]{entityKind}));
                    return;
                }
                case REGISTRATOR: {
                    criterionV3Criteria = v3Criteria.withRegistrator().withUserId();
                    break;
                }
                default: {
                    HibernateSearchDAOV3Adaptor.throwIllegalArgumentException(String.format("Unexpected searchFieldKind. searchFieldKind=%s.", searchFieldKind));
                    return;
                }
            }
            CompareType comparisonOperator = v1Criterion.getType();
            if (criterionV3Criteria instanceof StringFieldSearchCriteria) {
                HibernateSearchDAOV3Adaptor.adaptStringFieldCriterion(v1Criteria, value, (StringFieldSearchCriteria)criterionV3Criteria, comparisonOperator);
                continue;
            }
            if (criterionV3Criteria instanceof NumberPropertySearchCriteria) {
                NumberFieldSearchCriteria numberFieldSearchCriteria = (NumberFieldSearchCriteria)criterionV3Criteria;
                Number number = this.getNumber(value);
                switch (comparisonOperator) {
                    case LESS_THAN: {
                        numberFieldSearchCriteria.thatIsLessThan(number);
                        break;
                    }
                    case LESS_THAN_OR_EQUAL: {
                        numberFieldSearchCriteria.thatIsLessThanOrEqualTo(number);
                        break;
                    }
                    case EQUALS: {
                        numberFieldSearchCriteria.thatEquals(number);
                        break;
                    }
                    case MORE_THAN_OR_EQUAL: {
                        numberFieldSearchCriteria.thatIsGreaterThanOrEqualTo(number);
                        break;
                    }
                    case MORE_THAN: {
                        numberFieldSearchCriteria.thatIsGreaterThan(number);
                    }
                }
                continue;
            }
            if (criterionV3Criteria instanceof BooleanFieldSearchCriteria) {
                BooleanFieldSearchCriteria booleanFieldSearchCriteria = (BooleanFieldSearchCriteria)criterionV3Criteria;
                booleanFieldSearchCriteria.thatEquals(Boolean.parseBoolean(value));
                continue;
            }
            if (criterionV3Criteria instanceof DateFieldSearchCriteria) {
                DateFieldSearchCriteria dateFieldSearchCriteria = (DateFieldSearchCriteria)criterionV3Criteria;
                String timezone = v1Criterion.getTimeZone();
                if (timezone != null && !"server".equals(timezone)) {
                    int hourOffset = 0;
                    try {
                        hourOffset = Integer.parseInt(timezone);
                    }
                    catch (Exception ex) {
                        this.throwUnsupportedOperationException("timezone format not supported for: '" + timezone + "'");
                    }
                    dateFieldSearchCriteria.withTimeZone(hourOffset);
                }
                switch (comparisonOperator) {
                    case LESS_THAN: {
                        HibernateSearchDAOV3Adaptor.throwIllegalArgumentException("Date operator LESS_THAN");
                        break;
                    }
                    case LESS_THAN_OR_EQUAL: {
                        dateFieldSearchCriteria.thatIsEarlierThanOrEqualTo(value);
                        break;
                    }
                    case EQUALS: {
                        dateFieldSearchCriteria.thatEquals(value);
                        break;
                    }
                    case MORE_THAN_OR_EQUAL: {
                        dateFieldSearchCriteria.thatIsLaterThanOrEqualTo(value);
                        break;
                    }
                    case MORE_THAN: {
                        HibernateSearchDAOV3Adaptor.throwIllegalArgumentException("Date operator MORE_THAN");
                    }
                }
                continue;
            }
            if (criterionV3Criteria instanceof CompleteSearchCriteria) {
                enumFieldSearchCriteria = (CompleteSearchCriteria)criterionV3Criteria;
                enumFieldSearchCriteria.thatEquals((Enum)Complete.valueOf((String)value));
                continue;
            }
            if (criterionV3Criteria instanceof StatusSearchCriteria) {
                enumFieldSearchCriteria = (StatusSearchCriteria)criterionV3Criteria;
                enumFieldSearchCriteria.thatEquals((Enum)ArchivingStatus.valueOf((String)value));
                continue;
            }
            if (criterionV3Criteria instanceof ExternalDmsTypeSearchCriteria) {
                enumFieldSearchCriteria = (ExternalDmsTypeSearchCriteria)criterionV3Criteria;
                enumFieldSearchCriteria.thatEquals((Enum)ExternalDmsAddressType.valueOf((String)value));
                continue;
            }
            if (criterionV3Criteria instanceof AbstractCompositeSearchCriteria) {
                Collection subcriteria = ((AbstractCompositeSearchCriteria)criterionV3Criteria).getCriteria();
                subcriteria.forEach(subcriterion -> {
                    if (subcriterion instanceof AbstractCompositeSearchCriteria) {
                        Collection subsubcriteria = ((AbstractCompositeSearchCriteria)subcriterion).getCriteria();
                        subsubcriteria.forEach(subsubcriterion -> {
                            if (subsubcriterion instanceof TagSearchCriteria) {
                                Collection subsubsubcriteria = ((AbstractCompositeSearchCriteria)subsubcriterion).getCriteria();
                                subsubsubcriteria.forEach(subsubsubcriterion -> {
                                    if (subsubsubcriterion instanceof PermIdSearchCriteria || subsubsubcriterion instanceof CodeSearchCriteria) {
                                        HibernateSearchDAOV3Adaptor.adaptStringFieldCriterion(v1Criteria, value, (StringFieldSearchCriteria)subsubsubcriterion, comparisonOperator);
                                    }
                                });
                            }
                        });
                    }
                });
                continue;
            }
            this.throwUnsupportedOperationException("TargetV3Criteria: " + v3Criteria.getClass().getSimpleName() + " For V1 Criterion: " + v1Criterion);
        }
    }

    private static void adaptStringFieldCriterion(DetailedSearchCriteria v1Criteria, String value, StringFieldSearchCriteria criterionV3Criteria, CompareType comparisonOperator) {
        StringFieldSearchCriteria stringFieldSearchCriteria = criterionV3Criteria;
        if (comparisonOperator == null || comparisonOperator == CompareType.EQUALS) {
            if (v1Criteria.isUseWildcardSearchMode()) {
                stringFieldSearchCriteria.withWildcards();
            } else {
                stringFieldSearchCriteria.withoutWildcards();
            }
            if (value.startsWith("\"") && value.endsWith("\"")) {
                stringFieldSearchCriteria.thatEquals(value.substring(1, value.length() - 1));
            } else {
                stringFieldSearchCriteria.thatEquals(value);
            }
        } else {
            HibernateSearchDAOV3Adaptor.throwIllegalArgumentException((Object)((Object)comparisonOperator) + " compare type for StringFieldSearchCriteria");
        }
    }

    private ISearchCriteria withAttribute(AbstractDataSetSearchCriteria<?> v3Criteria, String attributeCode) {
        CodeSearchCriteria criterionV3Criteria = null;
        switch (DataSetAttributeSearchFieldKind.valueOf(attributeCode)) {
            case CODE: {
                criterionV3Criteria = v3Criteria.withCode();
                break;
            }
            case DATA_SET_TYPE: {
                criterionV3Criteria = v3Criteria.withType().withCode();
                break;
            }
            case METAPROJECT: {
                criterionV3Criteria = v3Criteria;
                if (!(v3Criteria instanceof DataSetSearchCriteria)) break;
                DataSetSearchCriteria subcriteria = ((DataSetSearchCriteria)v3Criteria).withSubcriteria();
                subcriteria.withOrOperator();
                TagSearchCriteria tagSearchCriteria1 = subcriteria.withTag();
                TagSearchCriteria tagSearchCriteria2 = subcriteria.withTag();
                tagSearchCriteria1.withPermId();
                tagSearchCriteria2.withCode();
                break;
            }
            case REGISTRATION_DATE: {
                criterionV3Criteria = v3Criteria.withRegistrationDate();
                break;
            }
            case MODIFICATION_DATE: {
                criterionV3Criteria = v3Criteria.withModificationDate();
                break;
            }
            case REGISTRATION_DATE_FROM: {
                criterionV3Criteria = v3Criteria.withRegistrationDate();
                break;
            }
            case MODIFICATION_DATE_FROM: {
                criterionV3Criteria = v3Criteria.withModificationDate();
                break;
            }
            case REGISTRATION_DATE_UNTIL: {
                criterionV3Criteria = v3Criteria.withRegistrationDate();
                break;
            }
            case MODIFICATION_DATE_UNTIL: {
                criterionV3Criteria = v3Criteria.withModificationDate();
                break;
            }
            case REGISTRATOR_USER_ID: {
                criterionV3Criteria = v3Criteria.withRegistrator().withUserId();
                break;
            }
            case REGISTRATOR_FIRST_NAME: {
                criterionV3Criteria = v3Criteria.withRegistrator().withFirstName();
                break;
            }
            case REGISTRATOR_LAST_NAME: {
                criterionV3Criteria = v3Criteria.withRegistrator().withLastName();
                break;
            }
            case REGISTRATOR_EMAIL: {
                criterionV3Criteria = v3Criteria.withRegistrator().withEmail();
                break;
            }
            case MODIFIER_USER_ID: {
                criterionV3Criteria = v3Criteria.withModifier().withUserId();
                break;
            }
            case MODIFIER_FIRST_NAME: {
                criterionV3Criteria = v3Criteria.withModifier().withFirstName();
                break;
            }
            case MODIFIER_LAST_NAME: {
                criterionV3Criteria = v3Criteria.withModifier().withLastName();
                break;
            }
            case MODIFIER_EMAIL: {
                criterionV3Criteria = v3Criteria.withModifier().withEmail();
                break;
            }
            case LOCATOR_TYPE: {
                criterionV3Criteria = v3Criteria.withPhysicalData().withLocatorType().withCode();
                break;
            }
            case LOCATION: {
                criterionV3Criteria = v3Criteria.withPhysicalData().withLocation();
                break;
            }
            case SHARE_ID: {
                criterionV3Criteria = v3Criteria.withPhysicalData().withShareId();
                break;
            }
            case SIZE: {
                criterionV3Criteria = v3Criteria.withPhysicalData().withSize();
                break;
            }
            case STORAGE_FORMAT: {
                criterionV3Criteria = v3Criteria.withPhysicalData().withStorageFormat().withCode();
                break;
            }
            case FILE_TYPE: {
                criterionV3Criteria = v3Criteria.withPhysicalData().withFileFormatType().withCode();
                break;
            }
            case COMPLETE: {
                criterionV3Criteria = v3Criteria.withPhysicalData().withComplete();
                break;
            }
            case STATUS: {
                criterionV3Criteria = v3Criteria.withPhysicalData().withStatus();
                break;
            }
            case ARCHIVING_REQUESTED: {
                criterionV3Criteria = v3Criteria.withPhysicalData().withArchivingRequested();
                break;
            }
            case PRESENT_IN_ARCHIVE: {
                criterionV3Criteria = v3Criteria.withPhysicalData().withPresentInArchive();
                break;
            }
            case STORAGE_CONFIRMATION: {
                criterionV3Criteria = v3Criteria.withPhysicalData().withStorageConfirmation();
                break;
            }
            case SPEED_HINT: {
                criterionV3Criteria = v3Criteria.withPhysicalData().withSpeedHint();
                break;
            }
            case EXTERNAL_DMS_CODE: {
                criterionV3Criteria = v3Criteria.withLinkedData().withExternalDms().withCode();
                break;
            }
            case EXTERNAL_DMS_LABEL: {
                criterionV3Criteria = v3Criteria.withLinkedData().withExternalDms().withLabel();
                break;
            }
            case EXTERNAL_DMS_ADDRESS: {
                criterionV3Criteria = v3Criteria.withLinkedData().withExternalDms().withAddress();
                break;
            }
            case EXTERNAL_DMS_TYPE: {
                criterionV3Criteria = v3Criteria.withLinkedData().withExternalDms().withType();
                break;
            }
            case EXTERNAL_CODE: {
                criterionV3Criteria = v3Criteria.withLinkedData().withExternalCode();
                break;
            }
            case PATH: {
                criterionV3Criteria = v3Criteria.withLinkedData().withCopy().withPath();
                break;
            }
            case COMMIT_HASH: {
                criterionV3Criteria = v3Criteria.withLinkedData().withCopy().withGitCommitHash();
                break;
            }
            case COMMIT_REPOSITORY_ID: {
                criterionV3Criteria = v3Criteria.withLinkedData().withCopy().withGitRepositoryId();
            }
        }
        return criterionV3Criteria;
    }

    private ISearchCriteria withAttribute(AbstractSampleSearchCriteria<?> v3Criteria, String attributeCode) {
        CodeSearchCriteria criterionV3Criteria = null;
        switch (SampleAttributeSearchFieldKind.valueOf(attributeCode)) {
            case CODE: {
                criterionV3Criteria = v3Criteria.withCode();
                break;
            }
            case SAMPLE_TYPE: {
                criterionV3Criteria = v3Criteria.withType().withCode();
                break;
            }
            case PERM_ID: {
                criterionV3Criteria = v3Criteria.withPermId();
                break;
            }
            case IDENTIFIER: {
                criterionV3Criteria = v3Criteria.withIdentifier();
                break;
            }
            case SPACE: {
                criterionV3Criteria = v3Criteria.withSpace().withCode();
                break;
            }
            case PROJECT: {
                criterionV3Criteria = v3Criteria.withProject().withCode();
                break;
            }
            case PROJECT_PERM_ID: {
                criterionV3Criteria = v3Criteria.withProject().withPermId();
                break;
            }
            case PROJECT_SPACE: {
                criterionV3Criteria = v3Criteria.withProject().withSpace().withCode();
                break;
            }
            case METAPROJECT: {
                criterionV3Criteria = v3Criteria;
                if (!(v3Criteria instanceof SampleSearchCriteria)) break;
                SampleSearchCriteria subcriteria = (SampleSearchCriteria)((SampleSearchCriteria)v3Criteria).withSubcriteria().withOrOperator();
                subcriteria.withTag().withPermId();
                subcriteria.withTag().withCode();
                break;
            }
            case REGISTRATION_DATE: {
                criterionV3Criteria = v3Criteria.withRegistrationDate();
                break;
            }
            case MODIFICATION_DATE: {
                criterionV3Criteria = v3Criteria.withModificationDate();
                break;
            }
            case REGISTRATION_DATE_FROM: {
                criterionV3Criteria = v3Criteria.withRegistrationDate();
                break;
            }
            case MODIFICATION_DATE_FROM: {
                criterionV3Criteria = v3Criteria.withModificationDate();
                break;
            }
            case REGISTRATION_DATE_UNTIL: {
                criterionV3Criteria = v3Criteria.withRegistrationDate();
                break;
            }
            case MODIFICATION_DATE_UNTIL: {
                criterionV3Criteria = v3Criteria.withModificationDate();
                break;
            }
            case REGISTRATOR_USER_ID: {
                criterionV3Criteria = v3Criteria.withRegistrator().withUserId();
                break;
            }
            case REGISTRATOR_FIRST_NAME: {
                criterionV3Criteria = v3Criteria.withRegistrator().withFirstName();
                break;
            }
            case REGISTRATOR_LAST_NAME: {
                criterionV3Criteria = v3Criteria.withRegistrator().withLastName();
                break;
            }
            case REGISTRATOR_EMAIL: {
                criterionV3Criteria = v3Criteria.withRegistrator().withEmail();
                break;
            }
            case MODIFIER_USER_ID: {
                criterionV3Criteria = v3Criteria.withModifier().withUserId();
                break;
            }
            case MODIFIER_FIRST_NAME: {
                criterionV3Criteria = v3Criteria.withModifier().withFirstName();
                break;
            }
            case MODIFIER_LAST_NAME: {
                criterionV3Criteria = v3Criteria.withModifier().withLastName();
                break;
            }
            case MODIFIER_EMAIL: {
                criterionV3Criteria = v3Criteria.withModifier().withEmail();
            }
        }
        return criterionV3Criteria;
    }

    private ISearchCriteria withAttribute(ExperimentSearchCriteria v3Criteria, String attributeCode) {
        ExperimentSearchCriteria criterionV3Criteria = null;
        switch (ExperimentAttributeSearchFieldKind.valueOf(attributeCode)) {
            case CODE: {
                criterionV3Criteria = v3Criteria.withCode();
                break;
            }
            case EXPERIMENT_TYPE: {
                criterionV3Criteria = v3Criteria.withType().withCode();
                break;
            }
            case PERM_ID: {
                criterionV3Criteria = v3Criteria.withPermId();
                break;
            }
            case IDENTIFIER: {
                criterionV3Criteria = v3Criteria.withIdentifier();
                break;
            }
            case PROJECT: {
                criterionV3Criteria = v3Criteria.withProject().withCode();
                break;
            }
            case PROJECT_PERM_ID: {
                criterionV3Criteria = v3Criteria.withProject().withPermId();
                break;
            }
            case PROJECT_SPACE: {
                criterionV3Criteria = v3Criteria.withProject().withSpace().withCode();
                break;
            }
            case METAPROJECT: {
                criterionV3Criteria = v3Criteria;
                ExperimentSearchCriteria subcriteria = v3Criteria.withSubcriteria().withOrOperator();
                subcriteria.withTag().withPermId();
                subcriteria.withTag().withCode();
                break;
            }
            case REGISTRATION_DATE: {
                criterionV3Criteria = v3Criteria.withRegistrationDate();
                break;
            }
            case MODIFICATION_DATE: {
                criterionV3Criteria = v3Criteria.withModificationDate();
                break;
            }
            case REGISTRATION_DATE_FROM: {
                criterionV3Criteria = v3Criteria.withRegistrationDate();
                break;
            }
            case MODIFICATION_DATE_FROM: {
                criterionV3Criteria = v3Criteria.withModificationDate();
                break;
            }
            case REGISTRATION_DATE_UNTIL: {
                criterionV3Criteria = v3Criteria.withRegistrationDate();
                break;
            }
            case MODIFICATION_DATE_UNTIL: {
                criterionV3Criteria = v3Criteria.withModificationDate();
                break;
            }
            case REGISTRATOR_USER_ID: {
                criterionV3Criteria = v3Criteria.withRegistrator().withUserId();
                break;
            }
            case REGISTRATOR_FIRST_NAME: {
                criterionV3Criteria = v3Criteria.withRegistrator().withFirstName();
                break;
            }
            case REGISTRATOR_LAST_NAME: {
                criterionV3Criteria = v3Criteria.withRegistrator().withLastName();
                break;
            }
            case REGISTRATOR_EMAIL: {
                criterionV3Criteria = v3Criteria.withRegistrator().withEmail();
                break;
            }
            case MODIFIER_USER_ID: {
                criterionV3Criteria = v3Criteria.withModifier().withUserId();
                break;
            }
            case MODIFIER_FIRST_NAME: {
                criterionV3Criteria = v3Criteria.withModifier().withFirstName();
                break;
            }
            case MODIFIER_LAST_NAME: {
                criterionV3Criteria = v3Criteria.withModifier().withLastName();
                break;
            }
            case MODIFIER_EMAIL: {
                criterionV3Criteria = v3Criteria.withModifier().withEmail();
            }
        }
        return criterionV3Criteria;
    }

    private ISearchCriteria withAttribute(MaterialSearchCriteria v3Criteria, String attributeCode) {
        MaterialSearchCriteria criterionV3Criteria = null;
        switch (MaterialAttributeSearchFieldKind.valueOf(attributeCode)) {
            case ID: {
                break;
            }
            case CODE: {
                criterionV3Criteria = v3Criteria.withCode();
                break;
            }
            case PERM_ID: {
                criterionV3Criteria = v3Criteria.withPermId();
                break;
            }
            case MATERIAL_TYPE: {
                criterionV3Criteria = v3Criteria.withType().withCode();
                break;
            }
            case METAPROJECT: {
                criterionV3Criteria = v3Criteria;
                MaterialSearchCriteria subcriteria = v3Criteria.withSubcriteria().withOrOperator();
                subcriteria.withTag().withCode();
                subcriteria.withTag().withPermId();
                break;
            }
            case REGISTRATION_DATE: {
                criterionV3Criteria = v3Criteria.withRegistrationDate();
                break;
            }
            case MODIFICATION_DATE: {
                criterionV3Criteria = v3Criteria.withModificationDate();
                break;
            }
            case REGISTRATION_DATE_FROM: {
                criterionV3Criteria = v3Criteria.withRegistrationDate();
                break;
            }
            case MODIFICATION_DATE_FROM: {
                criterionV3Criteria = v3Criteria.withModificationDate();
                break;
            }
            case REGISTRATION_DATE_UNTIL: {
                criterionV3Criteria = v3Criteria.withRegistrationDate();
                break;
            }
            case MODIFICATION_DATE_UNTIL: {
                criterionV3Criteria = v3Criteria.withModificationDate();
                break;
            }
            case REGISTRATOR_USER_ID: {
                criterionV3Criteria = v3Criteria.withRegistrator().withUserId();
                break;
            }
            case REGISTRATOR_FIRST_NAME: {
                criterionV3Criteria = v3Criteria.withRegistrator().withFirstName();
                break;
            }
            case REGISTRATOR_LAST_NAME: {
                criterionV3Criteria = v3Criteria.withRegistrator().withLastName();
                break;
            }
            case REGISTRATOR_EMAIL: {
                criterionV3Criteria = v3Criteria.withRegistrator().withEmail();
                break;
            }
            case MODIFIER_USER_ID: {
                criterionV3Criteria = v3Criteria.withModifier().withUserId();
                break;
            }
            case MODIFIER_FIRST_NAME: {
                criterionV3Criteria = v3Criteria.withModifier().withFirstName();
                break;
            }
            case MODIFIER_LAST_NAME: {
                criterionV3Criteria = v3Criteria.withModifier().withLastName();
                break;
            }
            case MODIFIER_EMAIL: {
                criterionV3Criteria = v3Criteria.withModifier().withEmail();
            }
        }
        return criterionV3Criteria;
    }

    private EntityKind getEntityKind(AbstractEntitySearchCriteria<?> criteria) {
        EntityKind entityKind = null;
        if (criteria instanceof MaterialSearchCriteria) {
            entityKind = EntityKind.MATERIAL;
        }
        if (criteria instanceof ExperimentSearchCriteria) {
            entityKind = EntityKind.EXPERIMENT;
        }
        if (criteria instanceof AbstractSampleSearchCriteria) {
            entityKind = EntityKind.SAMPLE;
        }
        if (criteria instanceof AbstractDataSetSearchCriteria) {
            entityKind = EntityKind.DATA_SET;
        }
        return entityKind;
    }

    private AbstractEntitySearchCriteria<?> getCriteria(EntityKind entityKind) {
        MaterialSearchCriteria criteria = null;
        switch (entityKind) {
            case MATERIAL: {
                criteria = new MaterialSearchCriteria();
                break;
            }
            case EXPERIMENT: {
                criteria = new ExperimentSearchCriteria();
                break;
            }
            case SAMPLE: {
                criteria = new SampleSearchCriteria();
                break;
            }
            case DATA_SET: {
                criteria = new DataSetSearchCriteria();
            }
        }
        return criteria;
    }

    private MaterialSearchManager getMaterialSearchManager() {
        if (this.materialSearchManager == null) {
            this.materialSearchManager = (MaterialSearchManager)CommonServiceProvider.getApplicationContext().getBean("material-search-manager");
        }
        return this.materialSearchManager;
    }

    private ExperimentSearchManager getExperimentSearchManager() {
        if (this.experimentSearchManager == null) {
            this.experimentSearchManager = (ExperimentSearchManager)CommonServiceProvider.getApplicationContext().getBean("experiment-search-manager");
        }
        return this.experimentSearchManager;
    }

    private SampleSearchManager getSampleSearchManager() {
        if (this.sampleSearchManager == null) {
            this.sampleSearchManager = (SampleSearchManager)CommonServiceProvider.getApplicationContext().getBean("sample-search-manager");
        }
        return this.sampleSearchManager;
    }

    private DataSetSearchManager getDataSetSearchManager() {
        if (this.dataSetSearchManager == null) {
            this.dataSetSearchManager = (DataSetSearchManager)CommonServiceProvider.getApplicationContext().getBean("data-set-search-manager");
        }
        return this.dataSetSearchManager;
    }

    private ILocalSearchManager<AbstractEntitySearchCriteria<?>, ?, Long> getSearchManager(EntityKind entityKind) {
        AbstractLocalSearchManager manager = null;
        switch (entityKind) {
            case MATERIAL: {
                manager = this.getMaterialSearchManager();
                break;
            }
            case EXPERIMENT: {
                manager = this.getExperimentSearchManager();
                break;
            }
            case SAMPLE: {
                manager = this.getSampleSearchManager();
                break;
            }
            case DATA_SET: {
                manager = this.getDataSetSearchManager();
            }
        }
        return manager;
    }

    private Number getNumber(String number) {
        try {
            if (HibernateSearchDAOV3Adaptor.isInteger(number)) {
                return Integer.parseInt(number);
            }
            return Double.parseDouble(number);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("NaN : " + number);
        }
    }

    private static boolean isInteger(String s) {
        return HibernateSearchDAOV3Adaptor.isInteger(s, 10);
    }

    private static boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }

    private boolean isNumberProperty(String propertyCode) {
        DAOFactory daoFactory = (DAOFactory)CommonServiceProvider.getApplicationContext().getBean(DAO_FACTORY);
        Session currentSession = daoFactory.getSessionFactory().getCurrentSession();
        NativeQuery nativeQuery = currentSession.createNativeQuery(IS_NUMBER);
        nativeQuery.setParameter("code", (Object)propertyCode);
        Boolean isNumber = (Boolean)nativeQuery.getSingleResult();
        return isNumber;
    }

    private boolean isDateProperty(String propertyCode) {
        DAOFactory daoFactory = (DAOFactory)CommonServiceProvider.getApplicationContext().getBean(DAO_FACTORY);
        Session currentSession = daoFactory.getSessionFactory().getCurrentSession();
        NativeQuery nativeQuery = currentSession.createNativeQuery(IS_DATE);
        nativeQuery.setParameter("code", (Object)propertyCode);
        Boolean isDate = (Boolean)nativeQuery.getSingleResult();
        return isDate;
    }

    private AuthorizationConfig getAuthorizationConfig() {
        if (this.authorizationConfig == null) {
            this.authorizationConfig = (AuthorizationConfig)CommonServiceProvider.getApplicationContext().getBean("authorization-config");
        }
        return this.authorizationConfig;
    }

    private AuthorisationInformation getAuthorisationInformation(PersonPE personPE) {
        return AuthorisationInformation.getInstance(personPE, this.getAuthorizationConfig());
    }

    private void throwUnsupportedOperationException(String feature) throws RuntimeException {
        throw new RuntimeException(new UnsupportedOperationException("HibernateSearchDAOV3Replacement - Feature not supported: " + feature));
    }

    private static void throwIllegalArgumentException(String feature) throws RuntimeException {
        throw new IllegalArgumentException("HibernateSearchDAOV3Replacement - Illegal argument: " + feature);
    }
}

