/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IMaterialDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityWithPropertiesDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.MaterialCodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.util.MaterialConfigurationProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.StatelessSession;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class MaterialDAO
extends AbstractGenericEntityWithPropertiesDAO<MaterialPE>
implements IMaterialDAO {
    private static final Class<MaterialPE> ENTITY_CLASS = MaterialPE.class;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, MaterialDAO.class);
    private static final Pattern STRICT_CODE_PATTERN = Pattern.compile("^[A-Z0-9_\\-\\.]+$", 2);
    private static final Pattern RELAXED_CODE_PATTERN = Pattern.compile("^[^\\s]+$", 2);
    public static final String sqlPropertyHistory = "(SELECT m.code as perm_id, pt.code, coalesce(h.value, h.vocabulary_term, h.material) as value, p.user_id, h.valid_from_timestamp, h.valid_until_timestamp FROM materials m, material_properties_history h, material_type_property_types mtpt, property_types pt, persons p WHERE h.mate_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " AND m.id=h.mate_id AND h.mtpt_id=mtpt.id AND mtpt.prty_id = pt.id AND pers_id_author = p.id ) UNION ( SELECT m.code as perm_id, pt.code, coalesce(value, (SELECT (t.code || ' [' || v.code || ']') FROM controlled_vocabulary_terms as t JOIN controlled_vocabularies as v ON t.covo_id = v.id WHERE t.id = pr.cvte_id), (SELECT (m.code || ' [' || mt.code || ']') FROM materials AS m JOIN material_types AS mt ON m.maty_id = mt.id WHERE m.id = pr.mate_prop_id)) as value, author.user_id, pr.modification_timestamp, null FROM materials m, material_properties pr, material_type_property_types mtpt, property_types pt, persons author WHERE pr.mate_id  " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + "  AND m.id = pr.mate_id AND pr.mtpt_id = mtpt.id AND mtpt.prty_id = pt.id AND pr.pers_id_author = author.id ) ORDER BY 1, valid_from_timestamp";
    public static final String sqlAttributesHistory = "SELECT m.id, m.code, m.code as perm_id, t.code as entity_type, m.registration_timestamp, r.user_id as registrator FROM materials m JOIN material_types t on m.maty_id = t.id JOIN persons r on m.pers_id_registerer = r.id WHERE m.id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds();

    protected MaterialDAO(PersistencyResources persistencyResources, EntityHistoryCreator historyCreator) {
        super(persistencyResources, ENTITY_CLASS, historyCreator);
    }

    @Override
    public List<MaterialPE> listMaterialsWithProperties(MaterialTypePE materialType) throws DataAccessException {
        assert (materialType != null) : "Unspecified material type.";
        Criteria criteria = this.currentSession().createCriteria(ENTITY_CLASS);
        criteria.add((Criterion)Restrictions.eq((String)"materialType", (Object)materialType));
        int count = DAOUtils.getCount(criteria);
        if (count <= 20000) {
            criteria.setFetchMode("materialProperties", FetchMode.JOIN);
        } else {
            operationLog.info((Object)String.format("Found %d materials, disable properties loading.", count));
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List<MaterialPE> list = MaterialDAO.cast(criteria.list());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d materials have been found for material type '%s'.", list.size(), materialType));
        }
        return list;
    }

    @Override
    public void createOrUpdateMaterials(List<MaterialPE> materials) {
        assert (materials != null && materials.size() > 0) : "Unspecified or empty materials.";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        for (MaterialPE materialPE : materials) {
            this.internalCreateMaterial(materialPE, hibernateTemplate);
        }
        hibernateTemplate.flush();
        hibernateTemplate.clear();
        this.scheduleDynamicPropertiesEvaluation(materials);
    }

    private void internalCreateMaterial(MaterialPE material, HibernateTemplate hibernateTemplate) {
        material.setModificationDate(this.getTransactionTimeStamp());
        MaterialDAO.validatePE(material);
        this.validateMaterialCode(material);
        hibernateTemplate.saveOrUpdate((Object)material);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("ADD: material '%s'.", material));
        }
    }

    private void validateMaterialCode(MaterialPE material) {
        Pattern codePattern = null;
        if (this.isStrictCodeConstraints()) {
            material.setCode(CodeConverter.tryToDatabase(material.getCode()));
            codePattern = STRICT_CODE_PATTERN;
        } else {
            codePattern = RELAXED_CODE_PATTERN;
        }
        if (!this.isValidCode(material.getCode(), codePattern)) {
            throw new DataIntegrityViolationException(String.format("Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)", material.getCode()));
        }
    }

    private boolean isStrictCodeConstraints() {
        return this.getMaterialConfig().isStrictCodeConstraints();
    }

    private MaterialConfigurationProvider getMaterialConfig() {
        return MaterialConfigurationProvider.getInstance();
    }

    @Override
    public MaterialPE tryFindMaterial(MaterialIdentifier identifier) {
        return this.tryFindMaterial(this.currentSession(), identifier);
    }

    @Override
    public List<MaterialPE> listMaterialsByMaterialIdentifier(Collection<MaterialIdentifier> ids) {
        ArrayList<MaterialPE> result = new ArrayList<MaterialPE>();
        for (MaterialIdentifier materialIdentifier : ids) {
            MaterialPE material = this.tryFindMaterial(materialIdentifier);
            if (material == null) continue;
            result.add(material);
        }
        return result;
    }

    @Override
    public MaterialPE tryFindMaterial(Session session, MaterialIdentifier identifier) {
        assert (identifier != null) : "identifier not given";
        String code = MaterialCodeConverter.tryMaterialCodeToDatabase(identifier.getCode(), this.getMaterialConfig());
        String typeCode = CodeConverter.tryToDatabase(identifier.getTypeCode());
        Criteria criteria = session.createCriteria(ENTITY_CLASS);
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)code));
        criteria.createCriteria("materialType").add((Criterion)Restrictions.eq((String)"code", (Object)typeCode));
        MaterialPE material = (MaterialPE)criteria.uniqueResult();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Following material '%s' has been found for code '%s' and type '%s'.", material, code, typeCode));
        }
        return material;
    }

    @Override
    public List<MaterialPE> listMaterialsById(Collection<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        List<MaterialPE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), ENTITY_CLASS, "id", ids);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d materials have been found for ids: %s.", list.size(), CollectionUtils.abbreviate(ids, (int)10)));
        }
        return list;
    }

    @Override
    public void delete(final List<TechId> materialIds, final PersonPE registrator, final String reason) throws DataAccessException {
        final String sqlCodeAndType = String.format("SELECT m.code, mt.code as typeCode  FROM %s as m, %s as mt WHERE m.id = :mId AND m.maty_id = mt.id", "materials", "material_types");
        String sqlDeleteProperties = "DELETE FROM material_properties WHERE mate_id = :mId";
        String sqlDeleteSample = "DELETE FROM materials WHERE id = :mId";
        final String sqlInsertEvent = String.format("INSERT INTO %s (id, event_type, description, reason, pers_id_registerer, entity_type, identifiers, content) VALUES (nextval('%s'), :eventType, :description, :reason, :registratorId, :entityType, :identifier, :content)", "events", "EVENT_ID_SEQ");
        this.executeStatelessAction(new AbstractDAO.StatelessHibernateCallback(){

            @Override
            public Object doInStatelessSession(StatelessSession session) {
                NativeQuery sqlQueryCodeAndType = session.createSQLQuery(sqlCodeAndType);
                NativeQuery sqlQueryDeleteProperties = session.createSQLQuery("DELETE FROM material_properties WHERE mate_id = :mId");
                NativeQuery sqlQueryDeleteSample = session.createSQLQuery("DELETE FROM materials WHERE id = :mId");
                NativeQuery sqlQueryInsertEvent = session.createSQLQuery(sqlInsertEvent);
                sqlQueryInsertEvent.setParameter("eventType", (Object)EventType.DELETION.name());
                sqlQueryInsertEvent.setParameter("reason", (Object)reason);
                sqlQueryInsertEvent.setParameter("registratorId", (Object)registrator.getId());
                sqlQueryInsertEvent.setParameter("entityType", (Object)EventPE.EntityType.MATERIAL.name());
                int counter = 0;
                for (TechId techId : materialIds) {
                    sqlQueryCodeAndType.setParameter("mId", (Object)techId.getId());
                    Object[] codeAndType = (Object[])sqlQueryCodeAndType.uniqueResult();
                    if (codeAndType == null) continue;
                    String materialCode = (String)codeAndType[0];
                    String materialTypeCode = (String)codeAndType[1];
                    String permId = MaterialPE.createPermId(materialCode, materialTypeCode);
                    String content = MaterialDAO.this.historyCreator.apply((SharedSessionContract)session, Collections.singletonList(techId.getId()), sqlPropertyHistory, null, sqlAttributesHistory, null, null, registrator);
                    try {
                        sqlQueryDeleteProperties.setParameter("mId", (Object)techId.getId());
                        sqlQueryDeleteProperties.executeUpdate();
                        sqlQueryDeleteSample.setParameter("mId", (Object)techId.getId());
                        sqlQueryDeleteSample.executeUpdate();
                        sqlQueryInsertEvent.setParameter("description", (Object)permId);
                        sqlQueryInsertEvent.setParameter("identifier", (Object)materialCode);
                        sqlQueryInsertEvent.setParameter("content", (Object)content);
                        sqlQueryInsertEvent.executeUpdate();
                        if (++counter % 1000 != 0) continue;
                        operationLog.info((Object)String.format("%d materials have been deleted...", counter));
                    }
                    catch (ConstraintViolationException cve) {
                        throw new ConstraintViolationException(permId, cve.getSQLException(), cve.getSQL(), cve.getConstraintName());
                    }
                }
                return null;
            }
        });
        List ids = TechId.asLongs(materialIds);
        this.scheduleRemoveFromFullTextIndex(ids);
    }

    @Override
    Logger getLogger() {
        return operationLog;
    }

    private final boolean isValidCode(String code, Pattern pattern) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return false;
        }
        Matcher m = pattern.matcher(code);
        return m.matches();
    }
}

