/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IMetaprojectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.InQueryScroller;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.MetaprojectName;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationHolderDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class MetaprojectDAO
extends AbstractGenericEntityDAO<MetaprojectPE>
implements IMetaprojectDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, MetaprojectDAO.class);
    private static final Class<MetaprojectPE> ENTITY_CLASS = MetaprojectPE.class;

    public MetaprojectDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, ENTITY_CLASS, historyCreator);
    }

    @Override
    public MetaprojectPE tryFindByOwnerAndName(String ownerId, String metaprojectName) {
        DetachedCriteria criteria = DetachedCriteria.forClass(MetaprojectPE.class);
        criteria.createAlias("owner", "o");
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)metaprojectName).ignoreCase());
        criteria.add((Criterion)Restrictions.eq((String)"o.userId", (Object)ownerId));
        List list = MetaprojectDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        MetaprojectPE entity = (MetaprojectPE)MetaprojectDAO.tryFindEntity(list, "metaproject", new Object[0]);
        if (operationLog.isDebugEnabled()) {
            String methodName = MethodUtils.getCurrentMethod().getName();
            operationLog.debug((Object)String.format("%s(%s, %s): '%s'.", methodName, ownerId, metaprojectName, entity));
        }
        return entity;
    }

    @Override
    public List<MetaprojectPE> listMetaprojects(PersonPE owner) {
        DetachedCriteria criteria = DetachedCriteria.forClass(MetaprojectPE.class);
        criteria.add((Criterion)Restrictions.eq((String)"owner", (Object)owner));
        criteria.addOrder(Order.asc((String)"name"));
        List<MetaprojectPE> list = MetaprojectDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): %d metaproject(s) have been found.", MethodUtils.getCurrentMethod().getName(), owner, list.size()));
        }
        return list;
    }

    @Override
    public void createOrUpdateMetaproject(MetaprojectPE metaproject, PersonPE owner) {
        assert (metaproject != null) : "Missing metaproject.";
        MetaprojectDAO.validatePE(metaproject);
        MetaprojectName.validate(metaproject.getName());
        if (metaproject.getOwner() == null) {
            metaproject.setOwner(owner);
        }
        metaproject.setPrivate(true);
        HibernateTemplate template = this.getHibernateTemplate();
        template.saveOrUpdate((Object)metaproject);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("SAVE: metaproject '%s'.", metaproject));
        }
    }

    @Override
    public Collection<MetaprojectPE> listMetaprojectsForEntity(PersonPE owner, IEntityInformationHolderDTO entity) {
        DetachedCriteria criteria = DetachedCriteria.forClass(MetaprojectAssignmentPE.class);
        criteria.createAlias("metaproject", "m");
        criteria.add((Criterion)Restrictions.eq((String)"m.owner", (Object)owner));
        criteria.add((Criterion)Restrictions.eq((String)entity.getEntityKind().getLabel(), (Object)entity));
        criteria.setFetchMode("experiment", FetchMode.SELECT);
        criteria.setFetchMode("dataSet", FetchMode.SELECT);
        criteria.setFetchMode("material", FetchMode.SELECT);
        criteria.setFetchMode("sample", FetchMode.SELECT);
        List<MetaprojectAssignmentPE> assignments = MetaprojectDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        HashSet<MetaprojectPE> metaprojects = new HashSet<MetaprojectPE>();
        for (MetaprojectAssignmentPE assignment : assignments) {
            metaprojects.add(assignment.getMetaproject());
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s, %s): %d metaproject(s) have been found.", MethodUtils.getCurrentMethod().getName(), owner, entity, metaprojects.size()));
        }
        return metaprojects;
    }

    @Override
    public Collection<Long> listMetaprojectEntityIds(Long metaprojectId, EntityKind entityKind) {
        DetachedCriteria criteria = DetachedCriteria.forClass(MetaprojectAssignmentPE.class);
        criteria.createAlias("metaproject", "m");
        criteria.createAlias(entityKind.getLabel(), "e");
        criteria.add((Criterion)Restrictions.eq((String)"m.id", (Object)metaprojectId));
        criteria.setProjection((Projection)Projections.property((String)"e.id"));
        List idsAsNumbers = this.getHibernateTemplate().findByCriteria(criteria);
        ArrayList<Long> idsAsLongs = new ArrayList<Long>();
        for (Number idAsNumber : idsAsNumbers) {
            idsAsLongs.add(idAsNumber.longValue());
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s, %s): %d metaproject entity ids have been found.", new Object[]{MethodUtils.getCurrentMethod().getName(), metaprojectId, entityKind, idsAsLongs.size()}));
        }
        return idsAsLongs;
    }

    @Override
    public Collection<MetaprojectAssignmentPE> listMetaprojectAssignmentsForEntities(PersonPE owner, Collection<? extends IEntityInformationWithPropertiesHolder> entities, EntityKind entityKind) {
        if (entities.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<MetaprojectAssignmentPE> assignments = new ArrayList<MetaprojectAssignmentPE>();
        InQueryScroller<? extends IEntityInformationWithPropertiesHolder> entitiesScroller = new InQueryScroller<IEntityInformationWithPropertiesHolder>(entities, 1);
        List<? extends IEntityInformationWithPropertiesHolder> partialEntities = null;
        while ((partialEntities = entitiesScroller.next()) != null) {
            DetachedCriteria criteria = DetachedCriteria.forClass(MetaprojectAssignmentPE.class);
            criteria.createAlias("metaproject", "m");
            criteria.add((Criterion)Restrictions.eq((String)"m.owner", (Object)owner));
            criteria.add(Restrictions.in((String)entityKind.getLabel(), partialEntities));
            criteria.setFetchMode("experiment", FetchMode.SELECT);
            criteria.setFetchMode("sample", FetchMode.SELECT);
            criteria.setFetchMode("dataSet", FetchMode.SELECT);
            criteria.setFetchMode("material", FetchMode.SELECT);
            List partialAssignments = MetaprojectDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
            assignments.addAll(partialAssignments);
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s, %s): %d metaproject(s) have been found.", MethodUtils.getCurrentMethod().getName(), owner, entities, assignments.size()));
        }
        return assignments;
    }

    @Override
    public Collection<MetaprojectAssignmentPE> listMetaprojectAssignments(Long metaprojectId, EntityKind entityKind) {
        DetachedCriteria criteria = DetachedCriteria.forClass(MetaprojectAssignmentPE.class);
        criteria.createAlias("metaproject", "m");
        criteria.add((Criterion)Restrictions.eq((String)"m.id", (Object)metaprojectId));
        criteria.add(Restrictions.isNotNull((String)entityKind.getLabel()));
        List<MetaprojectAssignmentPE> assignments = MetaprojectDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s, %s): %d metaproject(s) have been found.", new Object[]{MethodUtils.getCurrentMethod().getName(), metaprojectId, entityKind, assignments.size()}));
        }
        return assignments;
    }

    @Override
    public int getMetaprojectAssignmentsCount(Long metaprojectId, EntityKind entityKind) {
        DetachedCriteria criteria = DetachedCriteria.forClass(MetaprojectAssignmentPE.class);
        criteria.createAlias("metaproject", "m");
        criteria.add((Criterion)Restrictions.eq((String)"m.id", (Object)metaprojectId));
        criteria.add(Restrictions.isNotNull((String)entityKind.getLabel()));
        criteria.setProjection(Projections.rowCount());
        Number count = (Number)this.getHibernateTemplate().findByCriteria(criteria).get(0);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s, %s): %d metaproject assignments have been found.", new Object[]{MethodUtils.getCurrentMethod().getName(), metaprojectId, entityKind, count}));
        }
        return count.intValue();
    }

    @Override
    public List<MetaprojectPE> listByIDs(Collection<Long> ids) {
        return this.listByIDsOfName("id", ids);
    }

    private List<MetaprojectPE> listByIDsOfName(String idName, Collection<?> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<MetaprojectPE>();
        }
        List<MetaprojectPE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), MetaprojectPE.class, idName, ids);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d metaproject(s) have been found.", list.size()));
        }
        return list;
    }
}

