/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.HibernateInterceptorsWrapper;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DynamicPropertiesInterceptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EntityValidationInterceptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IHibernateTransactionManagerCallback;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.SessionsUpdateInterceptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyCalculatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.IEntityValidatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.WeakHashMap;
import net.lemnik.eodsql.QueryTool;
import org.hibernate.Interceptor;
import org.hibernate.Transaction;
import org.springframework.beans.BeansException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class OpenBISHibernateTransactionManager
extends HibernateTransactionManager
implements IHibernateTransactionManagerCallback {
    private static final long serialVersionUID = 35L;
    private IDAOFactory daoFactory;
    private DynamicPropertiesInterceptor dynamicPropertiesInterceptor;
    private IEntityValidatorFactory entityValidationFactory;
    private IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory;
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;
    private IOpenBisSessionManager openBisSessionManager;
    WeakHashMap<Transaction, String> rolledBackTransactions = new WeakHashMap();

    public OpenBISHibernateTransactionManager(IDAOFactory daoFactory, IEntityValidatorFactory entityValidationFactory, IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, IOpenBisSessionManager openBisSessionManager) {
        this.daoFactory = daoFactory;
        this.entityValidationFactory = entityValidationFactory;
        this.dynamicPropertyCalculatorFactory = dynamicPropertyCalculatorFactory;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
        this.openBisSessionManager = openBisSessionManager;
    }

    public void setDynamicPropertiesInterceptor(DynamicPropertiesInterceptor dynamicPropertiesInterceptor) {
        this.dynamicPropertiesInterceptor = dynamicPropertiesInterceptor;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        super.doBegin(transaction, definition);
        QueryTool.setManagedDatabaseConnection((Connection)((JdbcTransactionObjectSupport)transaction).getConnectionHolder().getConnection());
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        Object resource;
        super.doResume(transaction, suspendedResources);
        if (this.getDataSource() != null && (resource = TransactionSynchronizationManager.getResource((Object)this.getDataSource())) instanceof ConnectionHolder) {
            QueryTool.setManagedDatabaseConnection((Connection)((ConnectionHolder)resource).getConnection());
        }
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        super.doCleanupAfterCompletion(transaction);
        QueryTool.clearManagedDatabaseConnection();
    }

    @Override
    public void rollbackTransaction(Transaction tx, String reason) {
        tx.rollback();
        this.rolledBackTransactions.put(tx, reason);
    }

    public Interceptor getEntityInterceptor() throws IllegalStateException, BeansException {
        EntityValidationInterceptor entityValidationInterceptor = new EntityValidationInterceptor(this, this.daoFactory, this.entityValidationFactory, this.dynamicPropertyCalculatorFactory, this.managedPropertyEvaluatorFactory);
        SessionsUpdateInterceptor sessionsUpdateInterceptor = new SessionsUpdateInterceptor(this.openBisSessionManager, this.daoFactory);
        return new HibernateInterceptorsWrapper(this.dynamicPropertiesInterceptor, entityValidationInterceptor, sessionsUpdateInterceptor);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        Transaction tx = null;
        try {
            tx = this.extractTransaction(status);
            super.doCommit(status);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Reflection exception in getting transaction from hibernate. Probably the hibernate has changed it's internal implementation we depend on.");
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Reflection exception in getting transaction from hibernate. Probably the hibernate has changed it's internal implementation we depend on.");
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException("Reflection exception in getting transaction from hibernate. Probably the hibernate has changed it's internal implementation we depend on.");
        }
        catch (TransactionSystemException ex) {
            String rollBackReason = this.rolledBackTransactions.get(tx);
            if (rollBackReason != null) {
                throw new UserFailureException(rollBackReason);
            }
            throw ex;
        }
    }

    private Transaction extractTransaction(DefaultTransactionStatus status) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = status.getTransaction().getClass().getDeclaredMethod("getSessionHolder", new Class[0]);
        method.setAccessible(true);
        SessionHolder sessionHolder = (SessionHolder)method.invoke(status.getTransaction(), new Object[0]);
        return sessionHolder.getTransaction();
    }
}

