/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IOperationExecutionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionAvailability;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.OperationExecutionState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateTemplate;

final class OperationExecutionDAO
extends AbstractGenericEntityDAO<OperationExecutionPE>
implements IOperationExecutionDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, OperationExecutionDAO.class);

    OperationExecutionDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, OperationExecutionPE.class, historyCreator);
    }

    @Override
    public void createOrUpdate(OperationExecutionPE execution) {
        OperationExecutionDAO.validatePE(execution);
        HibernateTemplate template = this.getHibernateTemplate();
        template.saveOrUpdate((Object)execution);
        template.flush();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Created or updated operation execution '%s'.", execution));
        }
    }

    @Override
    public OperationExecutionPE tryFindByCode(String code) {
        List<OperationExecutionPE> list = this.findByCodes(Arrays.asList(code));
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public List<OperationExecutionPE> findByCodes(Collection<String> codes) {
        DetachedCriteria criteria = DetachedCriteria.forClass(OperationExecutionPE.class);
        criteria.add(Restrictions.in((String)"code", codes));
        criteria.addOrder(Order.asc((String)"code"));
        List<OperationExecutionPE> list = OperationExecutionDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d executions(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public List<OperationExecutionPE> findByIds(Collection<Long> ids) {
        DetachedCriteria criteria = DetachedCriteria.forClass(OperationExecutionPE.class);
        criteria.add(Restrictions.in((String)"id", ids));
        List<OperationExecutionPE> list = OperationExecutionDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d executions(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public List<OperationExecutionPE> getExecutionsToBeFailedAfterServerRestart(Date serverStartDate) {
        DetachedCriteria criteria = DetachedCriteria.forClass(OperationExecutionPE.class);
        criteria.add(Restrictions.in((String)"state", Arrays.asList(OperationExecutionState.NEW, OperationExecutionState.SCHEDULED, OperationExecutionState.RUNNING)));
        criteria.add((Criterion)Restrictions.lt((String)"creationDate", (Object)serverStartDate));
        ArrayList<OperationExecutionPE> executions = new ArrayList<OperationExecutionPE>();
        executions.addAll(this.findByCriteria(criteria));
        this.sortFromOldestToNewest(executions);
        return executions;
    }

    @Override
    public List<OperationExecutionPE> getExecutionsToBeTimeOutPending() {
        DetachedCriteria criteria = DetachedCriteria.forClass(OperationExecutionPE.class);
        criteria.add(Restrictions.in((String)"state", Arrays.asList(OperationExecutionState.FAILED, OperationExecutionState.FINISHED)));
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.eq((String)"availability", (Object)OperationExecutionAvailability.AVAILABLE), Restrictions.eq((String)"summaryAvailability", (Object)OperationExecutionAvailability.AVAILABLE), Restrictions.eq((String)"detailsAvailability", (Object)OperationExecutionAvailability.AVAILABLE)}));
        ArrayList<OperationExecutionPE> executions = new ArrayList<OperationExecutionPE>();
        for (OperationExecutionPE execution : this.findByCriteria(criteria)) {
            boolean matches = false;
            if (OperationExecutionAvailability.AVAILABLE.equals(execution.getAvailability()) && execution.getAvailabilityTimeLeft() != null && execution.getAvailabilityTimeLeft() <= 0L) {
                matches = true;
            } else if (OperationExecutionAvailability.AVAILABLE.equals(execution.getSummaryAvailability()) && execution.getSummaryAvailabilityTimeLeft() != null && execution.getSummaryAvailabilityTimeLeft() <= 0L) {
                matches = true;
            } else if (OperationExecutionAvailability.AVAILABLE.equals(execution.getDetailsAvailability()) && execution.getDetailsAvailabilityTimeLeft() != null && execution.getDetailsAvailabilityTimeLeft() <= 0L) {
                matches = true;
            }
            if (!matches) continue;
            executions.add(execution);
        }
        this.sortFromOldestToNewest(executions);
        return executions;
    }

    @Override
    public List<OperationExecutionPE> getExecutionsToBeTimedOut() {
        DetachedCriteria criteria = DetachedCriteria.forClass(OperationExecutionPE.class);
        criteria.add(Restrictions.in((String)"state", Arrays.asList(OperationExecutionState.FAILED, OperationExecutionState.FINISHED)));
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.eq((String)"availability", (Object)OperationExecutionAvailability.TIME_OUT_PENDING), Restrictions.eq((String)"summaryAvailability", (Object)OperationExecutionAvailability.TIME_OUT_PENDING), Restrictions.eq((String)"detailsAvailability", (Object)OperationExecutionAvailability.TIME_OUT_PENDING)}));
        List<OperationExecutionPE> executions = this.findByCriteria(criteria);
        this.sortFromOldestToNewest(executions);
        return executions;
    }

    @Override
    public List<OperationExecutionPE> getExecutionsToBeDeleted() {
        DetachedCriteria criteria = DetachedCriteria.forClass(OperationExecutionPE.class);
        criteria.add(Restrictions.in((String)"state", Arrays.asList(OperationExecutionState.FAILED, OperationExecutionState.FINISHED)));
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.eq((String)"availability", (Object)OperationExecutionAvailability.DELETE_PENDING), Restrictions.eq((String)"summaryAvailability", (Object)OperationExecutionAvailability.DELETE_PENDING), Restrictions.eq((String)"detailsAvailability", (Object)OperationExecutionAvailability.DELETE_PENDING)}));
        List<OperationExecutionPE> executions = this.findByCriteria(criteria);
        this.sortFromOldestToNewest(executions);
        return executions;
    }

    private void sortFromOldestToNewest(List<OperationExecutionPE> executions) {
        Collections.sort(executions, new Comparator<OperationExecutionPE>(){

            @Override
            public int compare(OperationExecutionPE o1, OperationExecutionPE o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
    }

    private List<OperationExecutionPE> findByCriteria(DetachedCriteria criteria) {
        return OperationExecutionDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
    }
}

