/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IPermIdDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationHolderDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class PermIdDAO
extends AbstractDAO
implements IPermIdDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PermIdDAO.class);
    private static final String PERM_ID_DATE_FORMAT_PATTERN = "yyyyMMddHHmmssSSS";

    protected PermIdDAO(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public String createPermId() {
        long id = this.getNextSequenceId("PERM_ID_SEQ");
        return DateFormatUtils.format((Date)this.getTransactionTimeStamp(), (String)PERM_ID_DATE_FORMAT_PATTERN) + "-" + Long.toString(id);
    }

    @Override
    public List<String> createPermIds(int n) {
        ArrayList<String> result = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            result.add(this.createPermId());
        }
        return result;
    }

    @Override
    public IEntityInformationHolderDTO tryToFindByPermId(String permId, EntityKind entityKind) {
        assert (permId != null) : "Unspecified permId";
        DetachedCriteria criteria = DetachedCriteria.forClass(entityKind.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"permId", (Object)permId));
        List list = PermIdDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        IEntityInformationHolderDTO entity = (IEntityInformationHolderDTO)PermIdDAO.tryFindEntity(list, entityKind.name(), new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s '%s' found for permId '%s'.", entityKind.name(), entity, permId));
        }
        return entity;
    }
}

