/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPostRegistrationDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.PostRegistrationPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;

public class PostRegistrationDAO
extends AbstractGenericEntityDAO<PostRegistrationPE>
implements IPostRegistrationDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PostRegistrationDAO.class);

    protected PostRegistrationDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, PostRegistrationPE.class, historyCreator);
    }

    @Override
    public void addDataSet(String dataSetCode) {
        NativeQuery query = this.currentSession().createSQLQuery("insert into post_registration_dataset_queue (select nextval('post_registration_dataset_queue_id_seq'), id from data_all where code = :code)");
        query.setString("code", CodeConverter.tryToDatabase(dataSetCode));
        int count = query.executeUpdate();
        if (count > 0) {
            operationLog.debug((Object)String.format("Post registration entry has been added for dataSet '%s'.", dataSetCode));
        }
    }

    @Override
    public void removeDataSet(String dataSetCode) {
        NativeQuery query = this.currentSession().createSQLQuery("delete from post_registration_dataset_queue where ds_id in (select id from data where code = :code)");
        query.setString("code", CodeConverter.tryToDatabase(dataSetCode));
        int count = query.executeUpdate();
        if (count > 0) {
            operationLog.debug((Object)String.format("Post registration entry has been removed for dataSet '%s'.", dataSetCode));
        }
    }

    @Override
    public Collection<Long> listDataSetsForPostRegistration() {
        NativeQuery query = this.currentSession().createSQLQuery("select ds_id from post_registration_dataset_queue q, data d where q.ds_id = d.id");
        Iterator iterator = query.list().iterator();
        ArrayList<Long> list = new ArrayList<Long>();
        while (iterator.hasNext()) {
            Number id = (Number)iterator.next();
            list.add(id.longValue());
        }
        return list;
    }
}

