/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.hibernate5.HibernateTemplate;

final class PropertyTypeDAO
extends AbstractGenericEntityDAO<PropertyTypePE>
implements IPropertyTypeDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PropertyTypeDAO.class);

    PropertyTypeDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, PropertyTypePE.class, historyCreator);
    }

    @Override
    public final PropertyTypePE tryFindPropertyTypeByCode(String code) throws DataAccessException {
        assert (code != null) : "Unspecified property type code";
        String mangledCode = CodeConverter.tryToDatabase(code);
        boolean internalNamespace = CodeConverter.isInternalNamespace(code);
        List list = PropertyTypeDAO.cast(this.getHibernateTemplate().find(String.format("select pt from %s pt where pt.simpleCode = ? and pt.managedInternally = ?", PropertyTypePE.class.getSimpleName()), PropertyTypeDAO.toArray(mangledCode, internalNamespace)));
        PropertyTypePE entity = (PropertyTypePE)PropertyTypeDAO.tryFindEntity(list, "property type", code);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): '%s'.", MethodUtils.getCurrentMethod().getName(), code, entity));
        }
        return entity;
    }

    @Override
    public List<PropertyTypePE> listAllPropertyTypes() {
        Criteria criteria = this.currentSession().createCriteria(PropertyTypePE.class);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List<PropertyTypePE> list = PropertyTypeDAO.cast(criteria.list());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d property types(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public List<PropertyTypePE> listAllPropertyTypesWithRelations() {
        Criteria criteria = this.currentSession().createCriteria(PropertyTypePE.class);
        criteria.setFetchMode("materialTypePropertyTypesInternal", FetchMode.JOIN);
        criteria.setFetchMode("sampleTypePropertyTypesInternal", FetchMode.JOIN);
        criteria.setFetchMode("experimentTypePropertyTypesInternal", FetchMode.JOIN);
        criteria.setFetchMode("dataSetTypePropertyTypesInternal", FetchMode.JOIN);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List<PropertyTypePE> list = PropertyTypeDAO.cast(criteria.list());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d property types(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public final List<PropertyTypePE> listPropertyTypes() throws DataAccessException {
        List<PropertyTypePE> list = PropertyTypeDAO.cast(this.getHibernateTemplate().find(String.format("from %s v where v.managedInternally = false", PropertyTypePE.class.getSimpleName()), new Object[0]));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d property types(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public final List<DataTypePE> listDataTypes() throws DataAccessException {
        List<DataTypePE> list = PropertyTypeDAO.cast(this.getHibernateTemplate().find(String.format("from %s dt", DataTypePE.class.getSimpleName()), new Object[0]));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d data types(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public final DataTypePE getDataTypeByCode(DataTypeCode code) throws DataAccessException {
        assert (code != null) : "Unspecified entity data type.";
        List list = PropertyTypeDAO.cast(this.getHibernateTemplate().find(String.format("from %s dt where dt.code = ?", DataTypePE.class.getSimpleName()), PropertyTypeDAO.toArray(code)));
        DataTypePE entity = (DataTypePE)PropertyTypeDAO.getEntity(list);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): '%s'.", MethodUtils.getCurrentMethod().getName(), code, entity));
        }
        return entity;
    }

    @Override
    public final void createPropertyType(PropertyTypePE propertyType) throws DataAccessException {
        assert (propertyType != null) : "Unspecified property type.";
        PropertyTypeDAO.validatePE(propertyType);
        HibernateTemplate template = this.getHibernateTemplate();
        template.save((Object)propertyType);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("ADD: property type '%s'.", propertyType));
        }
    }

    @Override
    public void delete(PropertyTypePE entity) throws DataAccessException {
        assert (entity != null) : "entity unspecified";
        int assignmentsSize = entity.getDataSetTypePropertyTypes().size() + entity.getExperimentTypePropertyTypes().size() + entity.getMaterialTypePropertyTypes().size() + entity.getSampleTypePropertyTypes().size();
        if (assignmentsSize > 0) {
            String errorMsgFormat = "Property Type '%s' cannot be deleted because entity types are assigned.";
            throw new DataIntegrityViolationException(String.format(errorMsgFormat, entity.getCode()));
        }
        super.delete(entity);
    }
}

