/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRelationshipTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelationshipTypePE;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class RelationshipTypeDAO
extends AbstractGenericEntityDAO<RelationshipTypePE>
implements IRelationshipTypeDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, RelationshipTypeDAO.class);
    private static Map<String, Long> relationshipTypeIdsMap;

    public RelationshipTypeDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, RelationshipTypePE.class, historyCreator);
    }

    @Override
    public RelationshipTypePE tryFindRelationshipTypeByCode(String code) {
        assert (code != null) : "Unspecified relationship type code";
        Long typeId = this.getRelationshipTypeId(code);
        RelationshipTypePE type = null;
        if (typeId != null) {
            type = (RelationshipTypePE)this.currentSession().get(RelationshipTypePE.class, (Serializable)typeId);
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): '%s'.", MethodUtils.getCurrentMethod().getName(), code, type));
        }
        return type;
    }

    private synchronized Long getRelationshipTypeId(String code) {
        if (relationshipTypeIdsMap == null) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            List allTypes = this.listAllEntities();
            if (allTypes != null && !allTypes.isEmpty()) {
                for (RelationshipTypePE type : allTypes) {
                    map.put(type.getCode(), type.getId());
                }
            }
            relationshipTypeIdsMap = map;
        }
        return relationshipTypeIdsMap.get(code);
    }
}

