/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRoleAssignmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Grantee;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateTemplate;

public final class RoleAssignmentDAO
extends AbstractGenericEntityDAO<RoleAssignmentPE>
implements IRoleAssignmentDAO {
    private static final String AUTHORIZATION_GROUP_INTERNAL_CODE = "authorizationGroupInternal.code";
    private static final String PERSON_INTERNAL_USER_ID = "personInternal.userId";
    public static final Class<RoleAssignmentPE> ENTITY_CLASS = RoleAssignmentPE.class;
    private static final String TABLE_NAME = ENTITY_CLASS.getSimpleName();
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, RoleAssignmentDAO.class);

    RoleAssignmentDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, ENTITY_CLASS, historyCreator);
    }

    @Override
    public final List<RoleAssignmentPE> listRoleAssignments() {
        List<RoleAssignmentPE> list = RoleAssignmentDAO.cast(this.getHibernateTemplate().find(String.format("select r from %s r", TABLE_NAME), new Object[0]));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d role assignment(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public final List<RoleAssignmentPE> listRoleAssignmentsByPerson(PersonPE person) {
        assert (person != null) : "Unspecified person.";
        DetachedCriteria criteria = DetachedCriteria.forClass(ENTITY_CLASS);
        criteria.add((Criterion)Restrictions.eq((String)"personInternal", (Object)person));
        List<RoleAssignmentPE> list = RoleAssignmentDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): %d role assignment(s) have been found.", MethodUtils.getCurrentMethod().getName(), person, list.size()));
        }
        return list;
    }

    @Override
    public final void createRoleAssignment(RoleAssignmentPE roleAssignment) {
        assert (roleAssignment != null) : "Role assignment unspecified";
        RoleAssignmentDAO.validatePE(roleAssignment);
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        hibernateTemplate.save((Object)roleAssignment);
        hibernateTemplate.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("ADD: role assignment '%s'.", roleAssignment));
        }
    }

    @Override
    public final void deleteRoleAssignment(RoleAssignmentPE roleAssignment) {
        assert (roleAssignment != null) : "Role assignment unspecified";
        PersonPE person = roleAssignment.getPerson();
        if (person != null) {
            person.removeRoleAssigment(roleAssignment);
        } else {
            roleAssignment.getAuthorizationGroup().removeRoleAssigment(roleAssignment);
        }
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        hibernateTemplate.delete((Object)roleAssignment);
        hibernateTemplate.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("DELETE: role assignment '%s'.", roleAssignment));
        }
    }

    private static final String getGranteeHqlParameter(Grantee.GranteeType type) {
        if (type.equals((Object)Grantee.GranteeType.AUTHORIZATION_GROUP)) {
            return AUTHORIZATION_GROUP_INTERNAL_CODE;
        }
        return PERSON_INTERNAL_USER_ID;
    }

    @Override
    public final RoleAssignmentPE tryFindProjectRoleAssignment(RoleWithHierarchy.RoleCode role, ProjectIdentifier projectIdentifier, Grantee grantee) {
        assert (role != null) : "Unspecified role.";
        assert (grantee != null) : "Unspecified grantee.";
        List roles = RoleAssignmentDAO.cast(this.getHibernateTemplate().find(String.format("from %s r where r." + RoleAssignmentDAO.getGranteeHqlParameter(grantee.getType()) + " = ? and project.code = ? and project.space.code = ? and r.role = ?", TABLE_NAME), RoleAssignmentDAO.toArray(new Object[]{grantee.getCode(), projectIdentifier.getProjectCode(), projectIdentifier.getSpaceCode(), role})));
        RoleAssignmentPE roleAssignment = (RoleAssignmentPE)RoleAssignmentDAO.tryFindEntity(roles, "role_assignments", new Object[]{role, projectIdentifier, grantee});
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("FIND: project role assignment '%s'.", roleAssignment));
        }
        return roleAssignment;
    }

    @Override
    public final RoleAssignmentPE tryFindSpaceRoleAssignment(RoleWithHierarchy.RoleCode role, String space, Grantee grantee) {
        assert (role != null) : "Unspecified role.";
        assert (grantee != null) : "Unspecified grantee.";
        List roles = RoleAssignmentDAO.cast(this.getHibernateTemplate().find(String.format("from %s r where r." + RoleAssignmentDAO.getGranteeHqlParameter(grantee.getType()) + " = ? and space.code = ? and r.role = ?", TABLE_NAME), RoleAssignmentDAO.toArray(new Object[]{grantee.getCode(), space, role})));
        RoleAssignmentPE roleAssignment = (RoleAssignmentPE)RoleAssignmentDAO.tryFindEntity(roles, "role_assignments", new Object[]{role, space, grantee});
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("FIND: space role assignment '%s'.", roleAssignment));
        }
        return roleAssignment;
    }

    @Override
    public final RoleAssignmentPE tryFindInstanceRoleAssignment(RoleWithHierarchy.RoleCode role, Grantee grantee) {
        assert (role != null) : "Unspecified role.";
        assert (grantee != null) : "Unspecified grantee.";
        List roles = RoleAssignmentDAO.cast(this.getHibernateTemplate().find(String.format("from %s r where r." + RoleAssignmentDAO.getGranteeHqlParameter(grantee.getType()) + " = ? and r.role = ? and space is null and project is null", TABLE_NAME), RoleAssignmentDAO.toArray(new Object[]{grantee.getCode(), role})));
        RoleAssignmentPE roleAssignment = (RoleAssignmentPE)RoleAssignmentDAO.tryFindEntity(roles, "role_assignments", new Object[]{role, grantee});
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("FIND: instance role assignment '%s'.", roleAssignment));
        }
        return roleAssignment;
    }

    @Override
    public List<RoleAssignmentPE> listRoleAssignmentsByAuthorizationGroup(AuthorizationGroupPE authGroup) {
        Criteria criteria = this.currentSession().createCriteria(RoleAssignmentPE.class);
        criteria.add((Criterion)Restrictions.eq((String)"authorizationGroupInternal", (Object)authGroup));
        List<RoleAssignmentPE> result = RoleAssignmentDAO.cast(criteria.list());
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("LIST: role assignments for authorization group '%s'.", authGroup));
        }
        return result;
    }
}

