/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityWithPropertiesDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IDetachedCriteriaFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.InQuery;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.InQueryScroller;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.SampleDataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class SampleDAO
extends AbstractGenericEntityWithPropertiesDAO<SamplePE>
implements ISampleDAO {
    private static final Class<SamplePE> ENTITY_CLASS = SamplePE.class;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, SampleDAO.class);
    private static final String ENTITY_TYPE = "case when h.space_id is not null then 'SPACE' when h.samp_id is not null then 'SAMPLE' when h.proj_id is not null then 'PROJECT' when h.expe_id is not null then 'EXPERIMENT' else 'UNKNOWN' end as entity_type";

    SampleDAO(PersistencyResources persistencyResources, EntityHistoryCreator historyCreator) {
        super(persistencyResources, SamplePE.class, historyCreator);
    }

    private final void internalCreateOrUpdateSample(SamplePE sample, PersonPE modifier, HibernateTemplate hibernateTemplate, boolean doLog) {
        SampleDAO.validatePE(sample);
        sample.setCode(CodeConverter.tryToDatabase(sample.getCode()));
        if (sample.getModificationDate() == null) {
            sample.setModificationDate(this.getTransactionTimeStamp());
        }
        this.lockEntity(sample.getExperiment());
        this.lockEntity(sample.getContainer());
        this.lockEntities(sample.getParents());
        hibernateTemplate.saveOrUpdate((Object)sample);
        if (doLog && operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("ADD: sample '%s'.", sample));
        }
    }

    @Override
    public final void createOrUpdateSample(SamplePE sample, PersonPE modifier) throws DataAccessException {
        assert (sample != null) : "Unspecified sample";
        try {
            HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
            this.internalCreateOrUpdateSample(sample, modifier, hibernateTemplate, true);
            SampleDAO.flushWithSqlExceptionHandling(hibernateTemplate);
            this.scheduleDynamicPropertiesEvaluation(Collections.singletonList(sample));
            SampleDAO.scheduleDynamicPropertiesEvaluation(this.getDynamicPropertyEvaluatorScheduler(), DataPE.class, new ArrayList<DataPE>(sample.getDatasets()));
        }
        catch (DataAccessException e) {
            SampleDataAccessExceptionTranslator.translateAndThrow(e);
        }
    }

    @Override
    public final List<SamplePE> listSamplesByGeneratedFrom(SamplePE sample) {
        return sample.getGenerated();
    }

    @Override
    public final List<SamplePE> listSamplesBySpaceAndProperty(String propertyCode, String propertyValue, SpacePE space) throws DataAccessException {
        assert (space != null) : "Unspecified space.";
        assert (propertyCode != null) : "Unspecified property code";
        assert (propertyValue != null) : "Unspecified property value";
        String queryFormat = "from " + SamplePropertyPE.class.getSimpleName() + " where %s = ? and entity.space = ?  and entityTypePropertyType.propertyTypeInternal.simpleCode = ? and entityTypePropertyType.propertyTypeInternal.managedInternally = ?";
        List<SamplePE> entities = this.listByPropertyValue(queryFormat, propertyCode, propertyValue, space);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d samples have been found for space '%s' and property '%s' equal to '%s'.", entities.size(), space, propertyCode, propertyValue));
        }
        return entities;
    }

    private List<SamplePE> listByPropertyValue(String queryFormat, String propertyCode, String propertyValue, SpacePE parent) {
        String simplePropertyCode = CodeConverter.tryToDatabase(propertyCode);
        boolean isInternalNamespace = CodeConverter.isInternalNamespace(propertyCode);
        Object[] arguments = SampleDAO.toArray(propertyValue, parent, simplePropertyCode, isInternalNamespace);
        String queryPropertySimpleValue = String.format(queryFormat, "value");
        List<SamplePropertyPE> properties1 = SampleDAO.cast(this.getHibernateTemplate().find(queryPropertySimpleValue, arguments));
        String queryPropertyVocabularyTerm = String.format(queryFormat, "vocabularyTerm.code");
        List properties2 = SampleDAO.cast(this.getHibernateTemplate().find(queryPropertyVocabularyTerm, arguments));
        properties1.addAll(properties2);
        List<SamplePE> entities = SampleDAO.extractEntities(properties1);
        return entities;
    }

    private static List<SamplePE> extractEntities(List<SamplePropertyPE> properties) {
        ArrayList<SamplePE> samples = new ArrayList<SamplePE>();
        for (SamplePropertyPE prop : properties) {
            samples.add(prop.getEntity());
        }
        return samples;
    }

    @Override
    public SamplePE tryToFindByPermID(String permID) throws DataAccessException {
        assert (permID != null) : "Unspecified permanent ID.";
        Criteria criteria = this.currentSession().createCriteria(ENTITY_CLASS);
        criteria.add((Criterion)Restrictions.eq((String)"permId", (Object)permID));
        criteria.setFetchMode("sampleType.sampleTypePropertyTypesInternal", FetchMode.JOIN);
        SamplePE sample = (SamplePE)criteria.uniqueResult();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Following sample '%s' has been found for permanent ID '%s'.", sample, permID));
        }
        return sample;
    }

    @Override
    public final SamplePE tryFindByCodeAndDatabaseInstance(String sampleCode) {
        assert (sampleCode != null) : "Unspecified sample code.";
        Criteria criteria = this.currentSession().createCriteria(ENTITY_CLASS);
        this.addSampleCodeCriterion(criteria, sampleCode);
        criteria.add(Restrictions.isNull((String)"space"));
        SamplePE sample = (SamplePE)criteria.uniqueResult();
        if (sample == null && !this.isFullCode(sampleCode)) {
            criteria = this.currentSession().createCriteria(ENTITY_CLASS);
            criteria.add(Restrictions.isNull((String)"space"));
            sample = this.tryFindContainedSampleWithUniqueSubcode(criteria, sampleCode);
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Following sample '%s' has been found for code '%s'.", sample, sampleCode));
        }
        return sample;
    }

    @Override
    public final List<SamplePE> listByCodesAndDatabaseInstance(List<String> sampleCodes, String containerCodeOrNull) {
        assert (sampleCodes != null) : "Unspecified sample codes.";
        Criteria criteria = this.currentSession().createCriteria(ENTITY_CLASS);
        return this.listByCodes(criteria, sampleCodes, containerCodeOrNull);
    }

    @Override
    public SamplePE tryfindByCodeAndProject(String sampleCode, ProjectPE project) {
        assert (sampleCode != null) : "Unspecified sample code.";
        assert (project != null) : "Unspecified project.";
        Criteria criteria = this.createProjectCriteria(project);
        this.addSampleCodeCriterion(criteria, sampleCode);
        SamplePE sample = (SamplePE)criteria.uniqueResult();
        if (sample == null && !this.isFullCode(sampleCode)) {
            criteria = this.createProjectCriteria(project);
            sample = this.tryFindContainedSampleWithUniqueSubcode(criteria, sampleCode);
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Following sample '%s' has been found for code '%s' and project '%s'.", sample, sampleCode, project));
        }
        return sample;
    }

    @Override
    public final SamplePE tryFindByCodeAndSpace(String sampleCode, SpacePE space) {
        return this.tryFindByCodeAndSpace(sampleCode, space, false);
    }

    @Override
    public final SamplePE tryFindByCodeAndSpace(String sampleCode, SpacePE space, boolean ignoringProject) {
        assert (sampleCode != null) : "Unspecified sample code.";
        assert (space != null) : "Unspecified space.";
        Criteria criteria = this.createSpaceCriteria(space, ignoringProject);
        this.addSampleCodeCriterion(criteria, sampleCode);
        SamplePE sample = (SamplePE)criteria.uniqueResult();
        if (sample == null && !this.isFullCode(sampleCode)) {
            criteria = this.createSpaceCriteria(space, ignoringProject);
            sample = this.tryFindContainedSampleWithUniqueSubcode(criteria, sampleCode);
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Following sample '%s' has been found for code '%s' and space '%s'.", sample, sampleCode, space));
        }
        return sample;
    }

    @Override
    public final List<SamplePE> listByCodesAndSpace(List<String> sampleCodes, String containerCodeOrNull, SpacePE space) {
        assert (sampleCodes != null) : "Unspecified sample codes.";
        assert (space != null) : "Unspecified space.";
        Criteria criteria = this.createSpaceCriteria(space, false);
        return this.listByCodes(criteria, sampleCodes, containerCodeOrNull);
    }

    @Override
    public List<SamplePE> listByCodesAndProject(List<String> sampleCodes, String containerCodeOrNull, ProjectPE project) {
        assert (sampleCodes != null) : "Unspecified sample codes.";
        assert (project != null) : "Unspecified project.";
        Criteria criteria = this.createProjectCriteria(project);
        return this.listByCodes(criteria, sampleCodes, containerCodeOrNull);
    }

    private List<SamplePE> listByCodes(Criteria criteria, List<String> sampleCodes, String containerCodeOrNull) {
        this.addSampleCodesCriterion(criteria, sampleCodes, containerCodeOrNull);
        List<SamplePE> result = SampleDAO.cast(criteria.list());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s samples has been found", result.size()));
        }
        return result;
    }

    private boolean isFullCode(String sampleCode) {
        return sampleCode.contains(":");
    }

    private SamplePE tryFindContainedSampleWithUniqueSubcode(Criteria criteria, String sampleCode) {
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(sampleCode)));
        criteria.add(Restrictions.isNotNull((String)"container"));
        List list = SampleDAO.cast(criteria.list());
        return list.size() == 1 ? (SamplePE)list.get(0) : null;
    }

    private Criteria createFindCriteria(Criterion criterion) {
        Criteria criteria = this.currentSession().createCriteria(ENTITY_CLASS);
        criteria.setFetchMode("sampleType.sampleTypePropertyTypesInternal", FetchMode.JOIN);
        criteria.add(criterion);
        return criteria;
    }

    private Criteria createSpaceCriteria(SpacePE space, boolean ignoringProject) {
        Criteria criteria = this.createFindCriteria((Criterion)Restrictions.eq((String)"space", (Object)space));
        if (!ignoringProject) {
            criteria.add(Restrictions.isNull((String)"projectInternal"));
        }
        return criteria;
    }

    private Criteria createProjectCriteria(ProjectPE project) {
        return this.createFindCriteria((Criterion)Restrictions.eq((String)"projectInternal", (Object)project));
    }

    private void addSampleCodesCriterion(Criteria criteria, List<String> sampleCodes, String containerCodeOrNull) {
        ArrayList<String> convertedCodes = new ArrayList<String>();
        for (String sampleCode : sampleCodes) {
            convertedCodes.add(CodeConverter.tryToDatabase(sampleCode));
        }
        criteria.add(Restrictions.in((String)"code", convertedCodes));
        criteria.setFetchMode("sampleProperties", FetchMode.JOIN);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        this.addSampleContainerCriterion(criteria, containerCodeOrNull);
    }

    private void addSampleCodeCriterion(Criteria criteria, String sampleCode) {
        String[] sampleCodeTokens = sampleCode.split(":");
        String subCode = sampleCodeTokens.length > 1 ? sampleCodeTokens[1] : sampleCode;
        String containerCodeOrNull = sampleCodeTokens.length > 1 ? sampleCodeTokens[0] : null;
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(subCode)));
        this.addSampleContainerCriterion(criteria, containerCodeOrNull);
    }

    private void addSampleContainerCriterion(Criteria criteria, String containerCodeOrNull) {
        if (containerCodeOrNull != null) {
            criteria.createAlias("container", "c");
            criteria.add((Criterion)Restrictions.eq((String)"c.code", (Object)CodeConverter.tryToDatabase(containerCodeOrNull)));
        } else {
            criteria.add(Restrictions.isNull((String)"container"));
        }
    }

    @Override
    public final void createOrUpdateSamples(List<SamplePE> samples, PersonPE modifier, boolean clearCache) throws DataAccessException {
        assert (samples != null && samples.size() > 0) : "Unspecified or empty samples.";
        try {
            HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
            for (SamplePE samplePE : samples) {
                this.internalCreateOrUpdateSample(samplePE, modifier, hibernateTemplate, false);
            }
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)String.format("ADD: %d samples.", samples.size()));
            }
            SampleDAO.flushWithSqlExceptionHandling(this.getHibernateTemplate());
            this.scheduleDynamicPropertiesEvaluation(samples);
            if (clearCache) {
                hibernateTemplate.clear();
            }
        }
        catch (DataAccessException e) {
            SampleDataAccessExceptionTranslator.translateAndThrow(e);
        }
    }

    @Override
    public final void updateSample(SamplePE sample, PersonPE modifier) throws DataAccessException {
        assert (sample != null) : "Unspecified sample";
        try {
            sample.setModifier(modifier);
            SampleDAO.validatePE(sample);
            SampleDAO.flushWithSqlExceptionHandling(this.getHibernateTemplate());
            this.scheduleDynamicPropertiesEvaluation(Collections.singletonList(sample));
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("UPDATE: sample '" + sample + "'."));
            }
        }
        catch (DataAccessException e) {
            SampleDataAccessExceptionTranslator.translateAndThrow(e);
        }
    }

    @Override
    public List<SamplePE> listByPermID(Collection<String> values) {
        return this.listByIDsOfName("permId", values);
    }

    @Override
    public List<SamplePE> listByIDs(Collection<Long> ids) {
        return this.listByIDsOfName("id", ids);
    }

    private List<SamplePE> listByIDsOfName(String idName, Collection<?> values) {
        if (values == null || values.isEmpty()) {
            return new ArrayList<SamplePE>();
        }
        List<SamplePE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), SamplePE.class, idName, values);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d sample(s) have been found.", list.size()));
        }
        return list;
    }

    @Override
    public void delete(List<TechId> sampleIds, PersonPE registrator, String reason) throws DataAccessException {
        String samplesTable = "samples_all";
        String sqlSelectPermIds = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createSelectPermIdsSQL("samples_all");
        String sqlDeleteProperties = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeletePropertiesSQL("sample_properties", "samp_id");
        String sqlDeleteAttachments = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeleteAttachmentsSQL("samp_id");
        String sqlDeleteSamples = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeleteEnitiesSQL("samples_all");
        String sqlInsertEvent = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createInsertEventSQL();
        String sqlSelectPropertyHistory = SampleDAO.createQueryPropertyHistorySQL();
        String sqlSelectRelationshipHistory = SampleDAO.createQueryRelationshipHistorySQL();
        String sqlSelectAttributes = SampleDAO.createQueryAttributesSQL();
        this.executePermanentDeleteAction(EventPE.EntityType.SAMPLE, sampleIds, registrator, reason, sqlSelectPermIds, sqlDeleteProperties, sqlDeleteAttachments, sqlDeleteSamples, sqlInsertEvent, sqlSelectPropertyHistory, sqlSelectRelationshipHistory, sqlSelectAttributes, null, AttachmentHolderKind.SAMPLE);
    }

    private static String createQueryPropertyHistorySQL() {
        return "(SELECT s.perm_id, pt.code, coalesce(h.value, h.vocabulary_term, h.material) as value, p.user_id, h.valid_from_timestamp, h.valid_until_timestamp FROM samples_all s, sample_properties_history h, sample_type_property_types stpt, property_types pt, persons p WHERE h.samp_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " AND s.id = h.samp_id AND h.stpt_id = stpt.id AND stpt.prty_id = pt.id AND pers_id_author = p.id ) UNION (SELECT s.perm_id, pt.code, coalesce(value, (SELECT (t.code || ' [' || v.code || ']') FROM controlled_vocabulary_terms as t JOIN controlled_vocabularies as v ON t.covo_id = v.id WHERE t.id = pr.cvte_id), (SELECT (m.code || ' [' || mt.code || ']') FROM materials AS m JOIN material_types AS mt ON m.maty_id = mt.id WHERE m.id = pr.mate_prop_id)) as value, author.user_id, pr.modification_timestamp, null FROM samples_all s, sample_properties pr, sample_type_property_types stpt, property_types pt, persons author WHERE pr.samp_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " AND s.id = pr.samp_id AND pr.stpt_id = stpt.id AND stpt.prty_id = pt.id AND pr.pers_id_author = author.id )  ORDER BY 1, valid_from_timestamp";
    }

    private static String createQueryRelationshipHistorySQL() {
        return "SELECT s.perm_id, h.relation_type, h.entity_perm_id, case when h.space_id is not null then 'SPACE' when h.samp_id is not null then 'SAMPLE' when h.proj_id is not null then 'PROJECT' when h.expe_id is not null then 'EXPERIMENT' else 'UNKNOWN' end as entity_type, p.user_id, h.valid_from_timestamp, h.valid_until_timestamp FROM samples_all s, sample_relationships_history h, persons p WHERE s.id = h.main_samp_id AND h.main_samp_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " AND h.pers_id_author = p.id ORDER BY 1, valid_from_timestamp";
    }

    private static String createQueryAttributesSQL() {
        return "SELECT s.id, s.perm_id, s.code, t.code as entity_type, s.registration_timestamp, r.user_id as registrator FROM samples_all s JOIN sample_types t on s.saty_id = t.id JOIN persons r on s.pers_id_registerer = r.id WHERE s.id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds();
    }

    @Override
    public void deletePermanently(final DeletionPE deletion, final PersonPE registrator) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                String permIdQuery = "SELECT id, perm_id FROM samples_all WHERE del_id = :id";
                String properties = "DELETE FROM sample_properties WHERE samp_id IN (SELECT id FROM samples_all WHERE del_id = :id)";
                String attachmentContentIdQuery = "SELECT exac_id FROM attachments WHERE samp_id IN (SELECT id FROM samples_all WHERE del_id = :id)";
                String attachments = "DELETE FROM attachments WHERE samp_id IN (SELECT id FROM samples_all WHERE del_id = :id)";
                String attachmentContents = "DELETE FROM attachment_contents WHERE id IN (:ids)";
                String samples = "DELETE FROM samples_all WHERE del_id = :id";
                String event = "INSERT INTO events (id, event_type, description, reason, pers_id_registerer, entity_type, identifiers, content) VALUES (nextval('EVENT_ID_SEQ'), 'DELETION', :description, :reason, :registerer, 'SAMPLE', :identifiers, :content)";
                NativeQuery getPermIds = session.createSQLQuery(permIdQuery);
                getPermIds.setParameter("id", (Object)deletion.getId());
                StringBuffer permIdList = new StringBuffer();
                ArrayList<Long> entityIdsToDelete = new ArrayList<Long>();
                for (Object[] result : getPermIds.list()) {
                    permIdList.append(", ");
                    permIdList.append((String)result[1]);
                    entityIdsToDelete.add(((BigInteger)result[0]).longValue());
                }
                if (permIdList.length() == 0) {
                    return null;
                }
                String permIds = permIdList.substring(2);
                InQueryScroller entityIdsToDeleteScroller = new InQueryScroller(entityIdsToDelete, 16384);
                List<Long> partialEntityIdsToDelete = null;
                String content = "";
                while ((partialEntityIdsToDelete = entityIdsToDeleteScroller.next()) != null) {
                    if (content.length() > 0) {
                        content = content + ", ";
                    }
                    content = content + SampleDAO.this.historyCreator.apply((SharedSessionContract)session, partialEntityIdsToDelete, SampleDAO.createQueryPropertyHistorySQL(), SampleDAO.createQueryRelationshipHistorySQL(), SampleDAO.createQueryAttributesSQL(), null, AttachmentHolderKind.SAMPLE, registrator);
                }
                NativeQuery deleteProperties = session.createSQLQuery(properties);
                deleteProperties.setParameter("id", (Object)deletion.getId());
                deleteProperties.executeUpdate();
                NativeQuery getAttachmentContentIds = session.createSQLQuery(attachmentContentIdQuery);
                getAttachmentContentIds.setParameter("id", (Object)deletion.getId());
                List attachmentContentIdList = getAttachmentContentIds.list();
                NativeQuery deleteAttachments = session.createSQLQuery(attachments);
                deleteAttachments.setParameter("id", (Object)deletion.getId());
                deleteAttachments.executeUpdate();
                NativeQuery deleteSamples = session.createSQLQuery(samples);
                deleteSamples.setParameter("id", (Object)deletion.getId());
                deleteSamples.executeUpdate();
                NativeQuery insertEvent = session.createSQLQuery(event);
                insertEvent.setParameter("description", (Object)permIds);
                insertEvent.setParameter("reason", (Object)deletion.getReason());
                insertEvent.setParameter("registerer", (Object)registrator.getId());
                insertEvent.setParameter("identifiers", (Object)permIds);
                insertEvent.setParameter("content", (Object)content);
                insertEvent.executeUpdate();
                return null;
            }
        });
    }

    @Override
    public Set<TechId> listSampleIdsByChildrenIds(final Collection<TechId> children, final TechId relationship) {
        String query = "select sample_id_parent from sample_relationships where sample_id_child in (:ids) and relationship_id = :r ";
        List results = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) {
                InQuery inQuery = new InQuery();
                HashMap<String, Object> fixParams = new HashMap<String, Object>();
                fixParams.put("r", relationship.getId());
                List longIds = TechId.asLongs((Collection)children);
                List list = inQuery.withBatch(session, "select sample_id_parent from sample_relationships where sample_id_child in (:ids) and relationship_id = :r ", "ids", longIds, fixParams);
                return list;
            }
        });
        Set<TechId> result = SampleDAO.transformNumbers2TechIdSet(results);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("found %d sample parents for given children", results.size()));
        }
        return result;
    }

    @Override
    public Map<Long, Set<Long>> mapSampleIdsByChildrenIds(final Collection<Long> children, final Long relationship) {
        String query = "select sample_id_child, sample_id_parent from sample_relationships where relationship_id = :relationship and sample_id_child in (:children)";
        List results = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) {
                InQuery inQuery = new InQuery();
                HashMap<String, Object> fixParams = new HashMap<String, Object>();
                fixParams.put("relationship", relationship);
                List list = inQuery.withBatch(session, "select sample_id_child, sample_id_parent from sample_relationships where relationship_id = :relationship and sample_id_child in (:children)", "children", new ArrayList(children), fixParams);
                return list;
            }
        });
        HashMap<Long, Set<Long>> childIdToParentIdsMap = new HashMap<Long, Set<Long>>();
        for (Object[] result : results) {
            Number childId = (Number)result[0];
            Number parentId = (Number)result[1];
            HashSet<Long> parentIds = (HashSet<Long>)childIdToParentIdsMap.get(childId);
            if (parentIds == null) {
                parentIds = new HashSet<Long>();
                childIdToParentIdsMap.put(childId.longValue(), parentIds);
            }
            parentIds.add(parentId.longValue());
        }
        return childIdToParentIdsMap;
    }

    @Override
    public Set<TechId> listSampleIdsByParentIds(Collection<TechId> parentIds) {
        return this.listChildrenIds(parentIds, "sample_relationships");
    }

    @Override
    public Set<TechId> listChildrenForTrashedSamples(Collection<TechId> parentIds) {
        return this.listChildrenIds(parentIds, "sample_relationships_all");
    }

    private Set<TechId> listChildrenIds(final Collection<TechId> parents, String tableName) {
        final String query = "SELECT sample_id_child FROM " + tableName + " WHERE sample_id_parent IN (:ids)";
        List results = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) {
                List longIds = TechId.asLongs((Collection)parents);
                InQuery inQuery = new InQuery();
                List list = inQuery.withBatch(session, query, "ids", longIds, null);
                return list;
            }
        });
        Set<TechId> result = SampleDAO.transformNumbers2TechIdSet(results);
        if (operationLog.isDebugEnabled()) {
            operationLog.info((Object)String.format("found %d sample children for given parents", results.size()));
        }
        return result;
    }

    @Override
    public List<TechId> listSampleIdsByContainerIds(Collection<TechId> containers) {
        List longIds = TechId.asLongs(containers);
        return this.listSampleIdsByColumn("container.id", longIds, "sample components for given containers");
    }

    @Override
    public List<TechId> listSampleIdsBySampleTypeIds(Collection<TechId> sampleTypeIds) {
        List longIds = TechId.asLongs(sampleTypeIds);
        return this.listSampleIdsByColumn("sampleType.id", longIds, "samples for given sample types");
    }

    @Override
    public List<TechId> listSampleIdsByExperimentIds(Collection<TechId> experiments) {
        List longIds = TechId.asLongs(experiments);
        return this.listSampleIdsByColumn("experimentInternal.id", longIds, "samples for given experiments");
    }

    private List<TechId> listSampleIdsByColumn(String columnName, List<Long> longIds, String message) {
        List results = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass(SamplePE.class);
                criteria.setProjection((Projection)Projections.id());
                return criteria;
            }
        }, columnName, longIds);
        operationLog.info((Object)String.format("found %s " + message, results.size()));
        return SampleDAO.transformNumbers2TechIdList(results);
    }

    @Override
    public void setSampleContainer(final Long sampleId, final Long containerId) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                NativeQuery q = session.createSQLQuery("update samples set samp_id_part_of = :containerId where id = :sampleId");
                q.setLong("containerId", containerId.longValue());
                q.setLong("sampleId", sampleId.longValue());
                q.executeUpdate();
                return null;
            }
        });
    }

    @Override
    public void setSampleContained(final Long sampleId, final Collection<Long> containedIds) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                NativeQuery clearQuery = session.createSQLQuery("update samples set samp_id_part_of = null where id not in :containedIds and samp_id_part_of = :containerId");
                clearQuery.setLong("containerId", sampleId.longValue());
                clearQuery.setParameterList("containedIds", containedIds);
                clearQuery.executeUpdate();
                SampleDAO.this.addSampleContained(sampleId, containedIds);
                return null;
            }
        });
    }

    @Override
    public void addSampleContained(final Long sampleId, final Collection<Long> containedIds) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                NativeQuery setQuery = session.createSQLQuery("update samples set samp_id_part_of = :containerId where id in :containedIds");
                setQuery.setLong("containerId", sampleId.longValue());
                setQuery.setParameterList("containedIds", containedIds);
                setQuery.executeUpdate();
                return null;
            }
        });
    }

    @Override
    public void removeSampleContained(final Long sampleId, final Collection<Long> containedIds) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                NativeQuery clearQuery = session.createSQLQuery("update samples set samp_id_part_of = null where id in :containedIds and samp_id_part_of = :containerId");
                clearQuery.setLong("containerId", sampleId.longValue());
                clearQuery.setParameterList("containedIds", containedIds);
                clearQuery.executeUpdate();
                return null;
            }
        });
    }

    @Override
    public void setSampleRelationshipChildren(final Long sampleId, final Collection<Long> childrenIds, final Long relationshipId, final PersonPE author) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                NativeQuery q = session.createSQLQuery("delete from sample_relationships where sample_id_child not in :childrenIds and sample_id_parent = :parentId and relationship_id = :relationshipId");
                q.setParameterList("childrenIds", childrenIds);
                q.setLong("parentId", sampleId.longValue());
                q.setLong("relationshipId", relationshipId.longValue());
                q.executeUpdate();
                SampleDAO.this.addSampleRelationshipChildren(sampleId, childrenIds, relationshipId, author);
                return null;
            }
        });
    }

    @Override
    public void addSampleRelationshipChildren(final Long sampleId, final Collection<Long> childrenIds, final Long relationshipId, final PersonPE author) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                for (Long relatedSampleId : childrenIds) {
                    NativeQuery q = session.createSQLQuery("insert into sample_relationships (id, sample_id_parent, sample_id_child, relationship_id, pers_id_author, registration_timestamp, modification_timestamp) select nextval('sample_relationship_id_seq'),  :parentId, :childId, :relationshipId, :authorId, now(), now() where not exists (select 1 from sample_relationships where sample_id_parent = :parentId and sample_id_child = :childId and relationship_id = :relationshipId)");
                    q.setLong("parentId", sampleId.longValue());
                    q.setLong("childId", relatedSampleId.longValue());
                    q.setLong("relationshipId", relationshipId.longValue());
                    q.setLong("authorId", author.getId().longValue());
                    q.executeUpdate();
                }
                return null;
            }
        });
    }

    @Override
    public void removeSampleRelationshipChildren(final Long sampleId, final Collection<Long> childrenIds, final Long relationshipId, PersonPE author) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                NativeQuery q = session.createSQLQuery("delete from sample_relationships where sample_id_parent = :parentId and sample_id_child in :childrenIds and relationship_id = :relationshipId");
                q.setLong("parentId", sampleId.longValue());
                q.setParameterList("childrenIds", childrenIds);
                q.setLong("relationshipId", relationshipId.longValue());
                q.executeUpdate();
                return null;
            }
        });
    }

    @Override
    public void setSampleRelationshipParents(final Long sampleId, final Collection<Long> parentsIds, final Long relationshipId, final PersonPE author) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                NativeQuery q = session.createSQLQuery("delete from sample_relationships where sample_id_parent not in :parentIds and sample_id_child = :childId and relationship_id = :relationshipId");
                q.setParameterList("parentIds", parentsIds);
                q.setLong("childId", sampleId.longValue());
                q.setLong("relationshipId", relationshipId.longValue());
                q.executeUpdate();
                SampleDAO.this.addSampleRelationshipParents(sampleId, parentsIds, relationshipId, author);
                return null;
            }
        });
    }

    @Override
    public void addSampleRelationshipParents(final Long sampleId, final Collection<Long> parentsIds, final Long relationshipId, final PersonPE author) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                for (Long parentId : parentsIds) {
                    NativeQuery q = session.createSQLQuery("insert into sample_relationships (id, sample_id_parent, sample_id_child, relationship_id, pers_id_author, registration_timestamp, modification_timestamp) select nextval('sample_relationship_id_seq'),  :parentId, :childId, :relationshipId, :authorId, now(), now() where not exists (select 1 from sample_relationships where sample_id_parent = :parentId and sample_id_child = :childId and relationship_id = :relationshipId)");
                    q.setLong("parentId", parentId.longValue());
                    q.setLong("childId", sampleId.longValue());
                    q.setLong("relationshipId", relationshipId.longValue());
                    q.setLong("authorId", author.getId().longValue());
                    q.executeUpdate();
                }
                return null;
            }
        });
    }

    @Override
    public void removeSampleRelationshipParents(final Long sampleId, final Collection<Long> parentsIds, final Long relationshipId, PersonPE author) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                NativeQuery q = session.createSQLQuery("delete from sample_relationships where sample_id_parent in :parentIds and sample_id_child = :childId and relationship_id = :relationshipId");
                q.setParameterList("parentIds", parentsIds);
                q.setLong("childId", sampleId.longValue());
                q.setLong("relationshipId", relationshipId.longValue());
                q.executeUpdate();
                return null;
            }
        });
    }

    @Override
    Logger getLogger() {
        return operationLog;
    }
}

