/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IScriptDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;

final class ScriptDAO
extends AbstractGenericEntityDAO<ScriptPE>
implements IScriptDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ScriptDAO.class);

    ScriptDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, ScriptPE.class, historyCreator);
    }

    @Override
    public void createOrUpdate(ScriptPE script) {
        assert (script != null) : "Missing script.";
        ScriptDAO.validatePE(script);
        HibernateTemplate template = this.getHibernateTemplate();
        template.saveOrUpdate((Object)script);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("SAVE: script '%s'.", script));
        }
    }

    @Override
    public ScriptPE tryFindByName(String scriptName) {
        assert (scriptName != null) : "Unspecified script.";
        Criteria criteria = this.currentSession().createCriteria(ScriptPE.class);
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)scriptName));
        return (ScriptPE)criteria.uniqueResult();
    }

    @Override
    public List<ScriptPE> listEntities(ScriptType scriptTypeOrNull, EntityKind entityKindOrNull) throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(ScriptPE.class);
        if (scriptTypeOrNull != null) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"scriptType"), (Criterion)Restrictions.eq((String)"scriptType", (Object)scriptTypeOrNull)));
        }
        if (entityKindOrNull != null) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"entityKind"), (Criterion)Restrictions.eq((String)"entityKind", (Object)entityKindOrNull)));
        }
        List<ScriptPE> list = ScriptDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): %d scripts(s) have been found.", MethodUtils.getCurrentMethod().getName(), entityKindOrNull, list.size()));
        }
        return list;
    }
}

