/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISemanticAnnotationDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.dto.SemanticAnnotationPE;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateTemplate;

public final class SemanticAnnotationDAO
extends AbstractGenericEntityDAO<SemanticAnnotationPE>
implements ISemanticAnnotationDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, SemanticAnnotationDAO.class);
    public static final String ERROR_OWNER_CANNOT_BE_NULL_OR_MORE_THAN_ONE = "Semantic annotation has to be assigned either to entity type, property type or property assignment.";
    public static final String ERROR_PREDICATE_CANNOT_BE_NULL_OR_EMPTY = "Predicate of a semantic annotation has to be defined, i.e. predicate:\n- ontology id cannot be null or empty\n- ontology version cannot be null\n- accession id cannot be null or empty\n";
    public static final String ERROR_DESCRIPTOR_CANNOT_BE_NULL_OR_EMPTY = "Descriptor of an entity type semantic annotation has to be defined, i.e. descriptor:\n- ontology id cannot be null or empty\n- ontology version cannot be null\n- accession id cannot be null or empty\n";
    public static final String ERROR_DESCRIPTOR_CAN_BE_NULL_OR_NON_EMPTY = "Descriptor of a property type or property assignment semantic annotation has to be either defined, i.e descriptor:\n- ontology id cannot be null or empty\n- ontology version cannot be null\n- accession id cannot be null or empty\nor the whole descriptor has to be null, i.e. descriptor:\n- ontology id has to be null\n- ontology version has to be null\n- accession id has to be null\n";

    SemanticAnnotationDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, SemanticAnnotationPE.class, historyCreator);
    }

    @Override
    public void createOrUpdate(SemanticAnnotationPE annotation) {
        SemanticAnnotationDAO.validatePE(annotation);
        this.validateAnnotation(annotation);
        HibernateTemplate template = this.getHibernateTemplate();
        template.saveOrUpdate((Object)annotation);
        SemanticAnnotationDAO.flushWithSqlExceptionHandling(template);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Created or updated semantic annotation '%s'.", annotation));
        }
    }

    @Override
    public List<SemanticAnnotationPE> findByIds(Collection<Long> ids) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SemanticAnnotationPE.class);
        criteria.add(Restrictions.in((String)"id", ids));
        List<SemanticAnnotationPE> list = SemanticAnnotationDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d semantic annotation(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public List<SemanticAnnotationPE> findByPermIds(Collection<String> permIds) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SemanticAnnotationPE.class);
        criteria.add(Restrictions.in((String)"permId", permIds));
        List<SemanticAnnotationPE> list = SemanticAnnotationDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d semantic annotation(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    private void validateAnnotation(SemanticAnnotationPE annotation) {
        int notNullCount = 0;
        if (annotation.getSampleType() != null) {
            ++notNullCount;
        }
        if (annotation.getPropertyType() != null) {
            ++notNullCount;
        }
        if (annotation.getSampleTypePropertyType() != null) {
            ++notNullCount;
        }
        if (notNullCount != 1) {
            throw new UserFailureException(ERROR_OWNER_CANNOT_BE_NULL_OR_MORE_THAN_ONE);
        }
        if (this.isNullOrEmpty(annotation.getPredicateOntologyId()) || this.isNullOrEmpty(annotation.getPredicateAccessionId()) || this.isNull(annotation.getPredicateOntologyVersion())) {
            throw new UserFailureException(ERROR_PREDICATE_CANNOT_BE_NULL_OR_EMPTY);
        }
        if (annotation.getSampleType() != null) {
            if (this.isNullOrEmpty(annotation.getDescriptorOntologyId()) || this.isNullOrEmpty(annotation.getDescriptorAccessionId()) || this.isNull(annotation.getDescriptorOntologyVersion())) {
                throw new UserFailureException(ERROR_DESCRIPTOR_CANNOT_BE_NULL_OR_EMPTY);
            }
        } else {
            if (this.isNull(annotation.getDescriptorOntologyId()) && this.isNull(annotation.getDescriptorAccessionId()) && this.isNull(annotation.getDescriptorOntologyVersion())) {
                return;
            }
            if (this.isNullOrEmpty(annotation.getDescriptorOntologyId()) || this.isNullOrEmpty(annotation.getDescriptorAccessionId()) || this.isNull(annotation.getDescriptorOntologyVersion())) {
                throw new UserFailureException(ERROR_DESCRIPTOR_CAN_BE_NULL_OR_NON_EMPTY);
            }
        }
    }

    private boolean isNull(String value) {
        return value == null;
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }
}

