/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISpaceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;

final class SpaceDAO
extends AbstractGenericEntityDAO<SpacePE>
implements ISpaceDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, SpaceDAO.class);

    SpaceDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, SpacePE.class, historyCreator);
    }

    @Override
    public final SpacePE tryFindSpaceByCode(String spaceCode) throws DataAccessException {
        assert (spaceCode != null) : "Unspecified space code.";
        List list = SpaceDAO.cast(this.getHibernateTemplate().find(String.format("select g from %s g where g.code = ?", this.getEntityClass().getSimpleName()), SpaceDAO.toArray(CodeConverter.tryToDatabase(spaceCode))));
        SpacePE entity = (SpacePE)SpaceDAO.tryFindEntity(list, "space", new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): '%s'.", MethodUtils.getCurrentMethod().getName(), spaceCode, entity));
        }
        return entity;
    }

    @Override
    public List<SpacePE> tryFindSpaceByCodes(List<String> spaceCodes) throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.add(Restrictions.in((String)"code", spaceCodes));
        List<SpacePE> list = SpaceDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d space(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public final List<SpacePE> listSpaces() throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.setFetchMode("registrator", FetchMode.JOIN);
        List<SpacePE> list = SpaceDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d space(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public List<SpacePE> listByIDs(Collection<Long> ids) {
        return this.listByIDsOfName("id", ids);
    }

    private List<SpacePE> listByIDsOfName(String idName, Collection<?> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<SpacePE>();
        }
        List<SpacePE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), SpacePE.class, idName, ids);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d spaces(s) have been found.", list.size()));
        }
        return list;
    }

    @Override
    public final void createSpace(SpacePE space) throws DataAccessException {
        assert (space != null) : "Unspecified space";
        SpaceDAO.validatePE(space);
        HibernateTemplate template = this.getHibernateTemplate();
        space.setCode(CodeConverter.tryToDatabase(space.getCode()));
        template.save((Object)space);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("ADD: space '%s'.", space));
        }
    }
}

