/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateTemplate;

final class VocabularyDAO
extends AbstractGenericEntityDAO<VocabularyPE>
implements IVocabularyDAO {
    private static final Class<VocabularyPE> ENTITY_CLASS = VocabularyPE.class;
    private static final String TABLE_NAME = ENTITY_CLASS.getSimpleName();
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, VocabularyDAO.class);

    VocabularyDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, ENTITY_CLASS, historyCreator);
    }

    @Override
    public final void createOrUpdateVocabulary(VocabularyPE vocabularyPE) {
        assert (vocabularyPE != null) : "Given vocabulary can not be null.";
        VocabularyDAO.validatePE(vocabularyPE);
        HibernateTemplate template = this.getHibernateTemplate();
        template.save((Object)vocabularyPE);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("ADD/UPDATE: vocabulary '%s'.", vocabularyPE));
        }
    }

    @Override
    public final VocabularyPE tryFindVocabularyByCode(String vocabularyCode) {
        assert (vocabularyCode != null) : "Unspecified vocabulary code.";
        String mangledVocabularyCode = CodeConverter.tryToDatabase(vocabularyCode);
        boolean internalNamespace = CodeConverter.isInternalNamespace(vocabularyCode);
        List list = VocabularyDAO.cast(this.getHibernateTemplate().find(String.format("select v from %s v where v.simpleCode = ? and v.managedInternally = ?", TABLE_NAME), VocabularyDAO.toArray(mangledVocabularyCode, internalNamespace)));
        VocabularyPE entity = (VocabularyPE)VocabularyDAO.tryFindEntity(list, "vocabulary", vocabularyCode);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): '%s'.", MethodUtils.getCurrentMethod().getName(), vocabularyCode, entity));
        }
        return entity;
    }

    @Override
    public final List<VocabularyPE> listVocabularies(boolean excludeInternal) {
        String excludeInternalQuery = " where v.managedInternally = false";
        List<VocabularyPE> list = VocabularyDAO.cast(this.getHibernateTemplate().find(String.format("from %s v " + (excludeInternal ? excludeInternalQuery : ""), TABLE_NAME), new Object[0]));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)(list.size() + " vocabulary(ies) have been found."));
        }
        return list;
    }

    @Override
    public VocabularyTermPE tryFindVocabularyTermByCode(VocabularyPE vocabulary, String code) {
        assert (vocabulary != null) : "Unspecified vocabulary.";
        assert (code != null) : "Unspecified code.";
        Criteria criteria = this.currentSession().createCriteria(VocabularyTermPE.class);
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)code));
        criteria.add((Criterion)Restrictions.eq((String)"vocabularyInternal", (Object)vocabulary));
        VocabularyTermPE result = (VocabularyTermPE)VocabularyDAO.tryGetEntity(criteria.uniqueResult());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): '%s'.", vocabulary.getCode(), code, result));
        }
        return result;
    }
}

