/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyTermDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

final class VocabularyTermDAO
extends AbstractGenericEntityDAO<VocabularyTermPE>
implements IVocabularyTermDAO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, VocabularyTermDAO.class);

    VocabularyTermDAO(SessionFactory sessionFactory, EntityHistoryCreator historyCreator) {
        super(sessionFactory, VocabularyTermPE.class, historyCreator);
    }

    @Override
    public void increaseVocabularyTermOrdinals(VocabularyPE vocabulary, Long fromOrdinal, int increment) {
        assert (vocabulary != null) : "Unspecified vocabulary.";
        assert (fromOrdinal != null) : "Unspecified ordinal.";
        Long vocabularyId = HibernateUtils.getId(vocabulary);
        this.executeUpdate("UPDATE controlled_vocabulary_terms SET ordinal = ordinal + ? WHERE covo_id = ? AND ordinal >= ?", Integer.valueOf(increment), vocabularyId, fromOrdinal);
    }

    @Override
    public long getMaximumOrdinal(VocabularyPE vocabulary) {
        Long vocabularyId = HibernateUtils.getId(vocabulary);
        Number max = (Number)this.getUniqueResult("select max(ordinal) from controlled_vocabulary_terms where covo_id = %s", vocabularyId);
        return max == null ? 0L : max.longValue();
    }

    @Override
    public void updateRegistrator(VocabularyTermPE term, PersonPE registrator) {
        Long termId = HibernateUtils.getId(term);
        Long registratorId = HibernateUtils.getId(registrator);
        term.setRegistrator(registrator);
        this.executeUpdate("UPDATE controlled_vocabulary_terms SET pers_id_registerer = ? WHERE id = ?", registratorId, termId);
    }
}

