/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion;

import ch.systemsx.cisd.common.collection.SimpleComparator;
import ch.systemsx.cisd.common.time.DateFormatThreadLocal;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAttachmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.AttachmentEntry;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.AttributeEntry;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityModification;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.PropertyHistoryEntry;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.RelationshipHistoryEntry;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.hibernate.SQLQuery;
import org.hibernate.SharedSessionContract;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;

public class EntityHistoryCreator {
    private static final String ENTITY_IDS = "entityIds";
    private static final Set<String> NON_ATTRIBUTE_COLUMNS = new HashSet<String>(Arrays.asList("ID", "PERM_ID"));
    private boolean enabled = false;
    private IDAOFactory daoFactory;

    public void setDaoFactory(IDAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public void setEnabled(String s) {
        this.enabled = s == null || s.length() <= 0 || !s.equalsIgnoreCase("false");
    }

    public String apply(SharedSessionContract session, List<Long> entityIdsToDelete, String propertyHistoryQuery, String relationshipHistoryQuery, String attributesQuery, List<? extends AttachmentHolderPE> attachmentHolders, AttachmentHolderKind attachmentHolderKind, PersonPE registrator) {
        List<RelationshipHistoryEntry> deletedAttachments;
        if (!this.enabled) {
            return "";
        }
        HashMap<String, List<? extends EntityModification>> histories = new HashMap<String, List<? extends EntityModification>>();
        if (attributesQuery != null) {
            List<AttributeEntry> attributeEntries = this.selectAttributeEntries((SQLQuery)session.createSQLQuery(attributesQuery), entityIdsToDelete);
            this.addToHistories(histories, attributeEntries);
        }
        List<PropertyHistoryEntry> propertyHistory = this.selectHistoryPropertyEntries((SQLQuery)session.createSQLQuery(propertyHistoryQuery), entityIdsToDelete);
        this.addToHistories(histories, propertyHistory);
        if (relationshipHistoryQuery != null) {
            List<RelationshipHistoryEntry> relationshipHistory = this.selectRelationshipHistoryEntries((SQLQuery)session.createSQLQuery(relationshipHistoryQuery), entityIdsToDelete);
            this.addToHistories(histories, relationshipHistory);
        }
        if (attachmentHolders != null) {
            deletedAttachments = this.deleteAttachments(session, registrator, attachmentHolders);
            this.addToHistories(histories, deletedAttachments);
        }
        if (attachmentHolderKind != null) {
            deletedAttachments = this.deleteAttachments(session, registrator, attachmentHolderKind, entityIdsToDelete);
            this.addToHistories(histories, deletedAttachments);
        }
        return this.jsonize(histories);
    }

    public String jsonize(Map<String, List<? extends EntityModification>> modifications) {
        String content;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        ObjectWriter ow = new ObjectMapper().setDateFormat((DateFormat)dateFormat).writer().withDefaultPrettyPrinter();
        try {
            content = ow.writeValueAsString(modifications);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return content;
    }

    private List<RelationshipHistoryEntry> deleteAttachments(SharedSessionContract session, PersonPE registrator, AttachmentHolderKind attachmentHolderKind, List<Long> holderIds) {
        NativeQuery sqlQuery = session.createSQLQuery(this.createSelectHolderStatement(attachmentHolderKind));
        ArrayList<Object> attachmentHolders = new ArrayList<Object>();
        HashMap<Long, Object> attachmentHoldersById = new HashMap<Long, Object>();
        for (Map<String, Object> row : this.getRows((SQLQuery)sqlQuery, holderIds)) {
            AttachmentHolder attachmentHolder = new AttachmentHolder();
            attachmentHolder.id = ((Number)row.get("ID")).longValue();
            attachmentHolder.permId = (String)row.get("PERM_ID");
            attachmentHolders.add(attachmentHolder);
            attachmentHoldersById.put(attachmentHolder.id, attachmentHolder);
        }
        TreeMap<String, AttachmentEntry> attachmentEntries = new TreeMap<String, AttachmentEntry>();
        NativeQuery insertQuery = session.createSQLQuery("INSERT INTO events (id, event_type, description, reason, pers_id_registerer, entity_type, identifiers, content, exac_id) VALUES (nextval('EVENT_ID_SEQ'), 'DELETION', :description, '', :registerer, 'ATTACHMENT', :identifiers, :content, :attachment)");
        sqlQuery = session.createSQLQuery(this.createSelectAttachmentsStatement(attachmentHolderKind));
        for (Map map : this.getRows((SQLQuery)sqlQuery, holderIds)) {
            long holderId = ((Number)map.get("HOLDER_ID")).longValue();
            AttachmentHolder holder = (AttachmentHolder)attachmentHoldersById.get(holderId);
            String holderName = attachmentHolderKind.name().toLowerCase();
            String holderIdentifier = holder.permId;
            String fileName = (String)map.get("FILE_NAME");
            int version = ((Number)map.get("VERSION")).intValue();
            String identifier = String.format("%s/%s/%s(%s)", holderName, holderIdentifier, fileName, version);
            insertQuery.setParameter("description", (Object)identifier);
            insertQuery.setParameter("registerer", (Object)registrator.getId());
            insertQuery.setParameter("identifiers", (Object)identifier);
            insertQuery.setParameter("attachment", (Object)((Number)map.get("EXAC_ID")).longValue());
            HashMap<String, List<? extends EntityModification>> modifications = new HashMap<String, List<? extends EntityModification>>();
            AttachmentEntry attachmentEntry = new AttachmentEntry();
            attachmentEntry.fileName = fileName;
            attachmentEntry.version = version;
            attachmentEntry.description = (String)map.get("DESCRIPTION");
            attachmentEntry.title = (String)map.get("TITLE");
            attachmentEntry.relationType = "OWNED";
            attachmentEntry.entityType = attachmentHolderKind.toString();
            attachmentEntry.relatedEntity = holder.permId;
            attachmentEntry.validFrom = (Date)map.get("REGISTRATION_TIMESTAMP");
            attachmentEntry.userId = (String)map.get("USER_ID");
            modifications.put(identifier, Arrays.asList(attachmentEntry));
            attachmentEntries.put(identifier, attachmentEntry);
            insertQuery.setParameter("content", (Object)this.jsonize(modifications));
            insertQuery.executeUpdate();
        }
        ArrayList<RelationshipHistoryEntry> result = new ArrayList<RelationshipHistoryEntry>();
        Set set = attachmentEntries.entrySet();
        for (Map.Entry entry : set) {
            RelationshipHistoryEntry relationshipHistoryEntry = new RelationshipHistoryEntry();
            AttachmentEntry attachmentEntry = (AttachmentEntry)entry.getValue();
            relationshipHistoryEntry.userId = attachmentEntry.userId;
            relationshipHistoryEntry.entityType = "ATTACHMENT";
            relationshipHistoryEntry.permId = attachmentEntry.relatedEntity;
            relationshipHistoryEntry.relatedEntity = (String)entry.getKey();
            relationshipHistoryEntry.relationType = "OWNER";
            relationshipHistoryEntry.validFrom = ((AttachmentEntry)entry.getValue()).validFrom;
            result.add(relationshipHistoryEntry);
        }
        return result;
    }

    private String createSelectHolderStatement(AttachmentHolderKind holderKind) {
        String tableName = "";
        switch (holderKind) {
            case PROJECT: {
                tableName = "projects";
                break;
            }
            case EXPERIMENT: {
                tableName = "experiments_all";
                break;
            }
            case SAMPLE: {
                tableName = "samples_all";
            }
        }
        return "SELECT id, perm_id from " + tableName + " WHERE id in (:" + ENTITY_IDS + ")";
    }

    private String createSelectAttachmentsStatement(AttachmentHolderKind attachmentHolderKind) {
        String holderColumn = "";
        switch (attachmentHolderKind) {
            case PROJECT: {
                holderColumn = "proj_id";
                break;
            }
            case EXPERIMENT: {
                holderColumn = "expe_id";
                break;
            }
            case SAMPLE: {
                holderColumn = "samp_id";
            }
        }
        return "SELECT " + holderColumn + " as holder_id, file_name, version, title, description, a.registration_timestamp, r.user_id, exac_id FROM attachments a join persons r on a.pers_id_registerer = r.id WHERE " + holderColumn + " in (:" + ENTITY_IDS + ")";
    }

    private List<RelationshipHistoryEntry> deleteAttachments(SharedSessionContract session, PersonPE registrator, List<? extends AttachmentHolderPE> attachmentHolders) {
        ArrayList<RelationshipHistoryEntry> relationshipHistoryEntries = new ArrayList<RelationshipHistoryEntry>();
        IAttachmentDAO attachmentDAO = this.daoFactory.getAttachmentDAO();
        for (AttachmentHolderPE attachmentHolderPE : attachmentHolders) {
            List<AttachmentPE> attachments = attachmentDAO.listAttachments(attachmentHolderPE);
            ArrayList<String> fileNames = new ArrayList<String>();
            for (AttachmentPE attachment : attachments) {
                fileNames.add(attachment.getFileName());
            }
            Map<String, AttachmentEntry> deletedAttachments = attachmentDAO.deleteAttachments(attachmentHolderPE, "", fileNames, registrator);
            Set<Map.Entry<String, AttachmentEntry>> entrySet = deletedAttachments.entrySet();
            for (Map.Entry<String, AttachmentEntry> entry : entrySet) {
                RelationshipHistoryEntry relationshipHistoryEntry = new RelationshipHistoryEntry();
                relationshipHistoryEntry.userId = entry.getValue().userId;
                relationshipHistoryEntry.entityType = "ATTACHMENT";
                relationshipHistoryEntry.permId = attachmentHolderPE.getPermId();
                relationshipHistoryEntry.relatedEntity = entry.getKey();
                relationshipHistoryEntry.relationType = "OWNER";
                relationshipHistoryEntry.validFrom = entry.getValue().validFrom;
                relationshipHistoryEntries.add(relationshipHistoryEntry);
            }
        }
        return relationshipHistoryEntries;
    }

    private List<AttributeEntry> selectAttributeEntries(SQLQuery sqlQuery, List<Long> entityIdsToDelete) {
        List<Map<String, Object>> rows = this.getRows(sqlQuery, entityIdsToDelete);
        HashMap<Long, EntityAttributes> result = new HashMap<Long, EntityAttributes>();
        for (Map<String, Object> row : rows) {
            Long id = ((BigInteger)row.get("ID")).longValue();
            String permId = (String)row.get("PERM_ID");
            EntityAttributes attributes = new EntityAttributes(permId);
            for (Map.Entry<String, Object> entry : row.entrySet()) {
                String key = entry.getKey();
                if (NON_ATTRIBUTE_COLUMNS.contains(key)) continue;
                attributes.addAttribute(key, this.render(entry.getValue()));
            }
            result.put(id, attributes);
        }
        ArrayList<AttributeEntry> list = new ArrayList<AttributeEntry>();
        for (EntityAttributes entityAttributes : result.values()) {
            Map<String, String> map = entityAttributes.getAttributes();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                AttributeEntry historyEntry = new AttributeEntry();
                historyEntry.permId = entityAttributes.getPermId();
                historyEntry.attributeName = entry.getKey();
                historyEntry.value = entry.getValue();
                list.add(historyEntry);
            }
        }
        return list;
    }

    private String render(Object value) {
        if (value instanceof Date) {
            return ((SimpleDateFormat)DateFormatThreadLocal.DATE_FORMAT.get()).format((Date)value);
        }
        return value == null ? null : value.toString();
    }

    private void addToHistories(Map<String, List<? extends EntityModification>> histories, List<? extends EntityModification> modifications) {
        for (EntityModification entityModification : modifications) {
            String permId = entityModification.permId;
            List<? extends EntityModification> current = histories.get(permId);
            if (current == null) {
                current = new ArrayList<EntityModification>();
            }
            histories.put(permId, this.addModification(current, entityModification));
        }
    }

    private List<EntityModification> addModification(List<? extends EntityModification> current, EntityModification modification) {
        ArrayList<? extends EntityModification> list = new ArrayList<EntityModification>(current);
        list.add(modification);
        Collections.sort(list, new SimpleComparator<EntityModification, Date>(){

            public Date evaluate(EntityModification item) {
                return item.validFrom == null ? new Date(0L) : item.validFrom;
            }
        });
        return Collections.unmodifiableList(list);
    }

    private List<PropertyHistoryEntry> selectHistoryPropertyEntries(SQLQuery selectPropertyHistory, List<Long> entityIds) {
        selectPropertyHistory.setParameterList(ENTITY_IDS, entityIds);
        selectPropertyHistory.setResultTransformer(new ResultTransformer(){
            private static final long serialVersionUID = 1L;

            public Object transformTuple(Object[] values, String[] aliases) {
                PropertyHistoryEntry entry = new PropertyHistoryEntry();
                int i = 0;
                entry.permId = (String)values[i++];
                entry.propertyCode = (String)values[i++];
                entry.value = (String)values[i++];
                entry.userId = (String)values[i++];
                entry.validFrom = (Date)values[i++];
                entry.validUntil = (Date)values[i++];
                return entry;
            }

            public List transformList(List list) {
                return list;
            }
        });
        return this.cast(selectPropertyHistory.list());
    }

    private List<RelationshipHistoryEntry> selectRelationshipHistoryEntries(SQLQuery selectRelationshipHistory, List<Long> entityIds) {
        selectRelationshipHistory.setParameterList(ENTITY_IDS, entityIds);
        selectRelationshipHistory.setResultTransformer(new ResultTransformer(){
            private static final long serialVersionUID = 1L;

            public Object transformTuple(Object[] values, String[] aliases) {
                RelationshipHistoryEntry entry = new RelationshipHistoryEntry();
                int i = 0;
                entry.permId = (String)values[i++];
                entry.relationType = (String)values[i++];
                entry.relatedEntity = (String)values[i++];
                entry.entityType = (String)values[i++];
                entry.userId = (String)values[i++];
                entry.validFrom = (Date)values[i++];
                entry.validUntil = (Date)values[i++];
                return entry;
            }

            public List transformList(List list) {
                return list;
            }
        });
        return this.cast(selectRelationshipHistory.list());
    }

    private List<Map<String, Object>> getRows(SQLQuery sqlQuery, List<Long> entityIdsToDelete) {
        sqlQuery.setParameterList(ENTITY_IDS, entityIdsToDelete);
        sqlQuery.setResultTransformer(new ResultTransformer(){
            private static final long serialVersionUID = 1L;

            public Object transformTuple(Object[] values, String[] aliases) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (int i = 0; i < values.length; ++i) {
                    row.put(aliases[i].toUpperCase(), values[i]);
                }
                return row;
            }

            public List transformList(List list) {
                return list;
            }
        });
        return this.cast(sqlQuery.list());
    }

    protected final <T> List<T> cast(List<?> list) {
        return list;
    }

    private static class AttachmentHolder {
        long id;
        String permId;

        private AttachmentHolder() {
        }
    }

    private static class EntityAttributes {
        private final String permId;
        private final Map<String, String> attributes = new HashMap<String, String>();

        public EntityAttributes(String permId) {
            this.permId = permId;
        }

        public void addAttribute(String attributeName, String value) {
            this.attributes.put(attributeName, value);
        }

        public String getPermId() {
            return this.permId;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }
    }
}

