/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.DynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IBatchDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyCalculatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

final class DefaultBatchDynamicPropertyEvaluator
implements IBatchDynamicPropertyEvaluator {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DefaultBatchDynamicPropertyEvaluator.class);
    private static String ID_PROPERTY_NAME = "id";
    private static final Map<Class<? extends IEntityInformationWithPropertiesHolder>, EntityKind> entityKindsByClass = new HashedMap();
    private final int batchSize;
    private final IDAOFactory daoFactory;
    private final IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory;
    private final IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    DefaultBatchDynamicPropertyEvaluator(int batchSize, IDAOFactory daoFactory, IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        assert (batchSize > -1) : "Batch size can not be negative.";
        this.batchSize = batchSize;
        this.daoFactory = daoFactory;
        this.dynamicPropertyCalculatorFactory = dynamicPropertyCalculatorFactory;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    @Override
    public final <T extends IEntityInformationWithPropertiesHolder> List<Long> doEvaluateProperties(Class<T> clazz) throws DataAccessException {
        operationLog.info((Object)String.format("Evaluating dynamic properties for all %ss...", clazz.getSimpleName()));
        Session hibernateSession = this.daoFactory.getSessionFactory().getCurrentSession();
        DynamicPropertyEvaluator evaluator = new DynamicPropertyEvaluator(this.daoFactory, null, this.dynamicPropertyCalculatorFactory, this.managedPropertyEvaluatorFactory);
        int index = 0;
        List<Long> ids = DefaultBatchDynamicPropertyEvaluator.getAllIds(hibernateSession, clazz);
        DefaultBatchDynamicPropertyEvaluator.retainDynamicIds(hibernateSession, clazz, ids);
        int idsSize = ids.size();
        operationLog.info((Object)String.format("... got %d '%s' ids...", idsSize, clazz.getSimpleName()));
        int maxIndex = idsSize - 1;
        if (maxIndex > -1) {
            ids.set(maxIndex, ids.get(maxIndex) + 1L);
        }
        while (index < maxIndex) {
            int nextIndex = this.getNextIndex(index, maxIndex);
            long minId = ids.get(index);
            long maxId = ids.get(nextIndex);
            List<T> results = DefaultBatchDynamicPropertyEvaluator.listEntitiesWithRestrictedId(hibernateSession, clazz, minId, maxId);
            DefaultBatchDynamicPropertyEvaluator.evaluateProperties(hibernateSession, evaluator, results);
            index = nextIndex;
            operationLog.info((Object)String.format("%d/%d %ss have been updated...", index + 1, maxIndex + 1, clazz.getSimpleName()));
        }
        operationLog.info((Object)String.format("Evaluation of dynamic properties for '%s' is complete. %d entities have been updated.", clazz.getSimpleName(), index + 1));
        return ids;
    }

    @Override
    public <T extends IEntityInformationWithPropertiesHolder> List<Long> doEvaluateProperties(Class<T> clazz, List<Long> ids) throws DataAccessException {
        operationLog.info((Object)String.format("Evaluating dynamic properties for %ss...", clazz.getSimpleName()));
        Session hibernateSession = this.daoFactory.getSessionFactory().getCurrentSession();
        DynamicPropertyEvaluator evaluator = new DynamicPropertyEvaluator(this.daoFactory, null, this.dynamicPropertyCalculatorFactory, this.managedPropertyEvaluatorFactory);
        ArrayList<Long> dynamicIds = new ArrayList<Long>(ids);
        DefaultBatchDynamicPropertyEvaluator.retainDynamicIds(hibernateSession, clazz, dynamicIds);
        operationLog.info((Object)String.format("... got %d '%s' ids...", dynamicIds.size(), clazz.getSimpleName()));
        int maxIndex = dynamicIds.size();
        int index = 0;
        while (index < maxIndex) {
            int nextIndex = this.getNextIndex(index, maxIndex);
            List<Long> subList = dynamicIds.subList(index, nextIndex);
            List<T> results = DefaultBatchDynamicPropertyEvaluator.listEntitiesWithRestrictedId(hibernateSession, clazz, subList);
            DefaultBatchDynamicPropertyEvaluator.evaluateProperties(hibernateSession, evaluator, results);
            index = nextIndex;
            operationLog.info((Object)String.format("%d/%d %ss have been updated...", index, maxIndex, clazz.getSimpleName()));
        }
        operationLog.info((Object)String.format("Evaluation of dynamic properties for '%s' is complete. %d entities have been updated.", clazz.getSimpleName(), index));
        return dynamicIds;
    }

    private int getNextIndex(int index, int maxIndex) {
        return Math.min(index + this.batchSize, maxIndex);
    }

    private static final <T extends IEntityInformationWithPropertiesHolder> void evaluateProperties(Session session, IDynamicPropertyEvaluator evaluator, List<T> entities) {
        for (IEntityInformationWithPropertiesHolder entity : entities) {
            evaluator.evaluateProperties(entity, session);
        }
        session.flush();
        session.clear();
    }

    private static final <T> List<Long> getAllIds(Session session, Class<T> clazz) {
        Criteria criteria = DefaultBatchDynamicPropertyEvaluator.createCriteria(session, clazz).setProjection((Projection)Projections.property((String)ID_PROPERTY_NAME)).addOrder(Order.asc((String)ID_PROPERTY_NAME));
        return DefaultBatchDynamicPropertyEvaluator.list(criteria);
    }

    private static final <T> List<T> listEntitiesWithRestrictedId(Session session, Class<T> clazz, long minId, long maxId) {
        Criteria criteria = DefaultBatchDynamicPropertyEvaluator.createCriteria(session, clazz).add((Criterion)Restrictions.ge((String)ID_PROPERTY_NAME, (Object)minId)).add((Criterion)Restrictions.lt((String)ID_PROPERTY_NAME, (Object)maxId));
        return DefaultBatchDynamicPropertyEvaluator.list(criteria);
    }

    private static final <T> List<T> listEntitiesWithRestrictedId(Session hibernateSession, Class<T> clazz, List<Long> ids) {
        Criteria criteria = DefaultBatchDynamicPropertyEvaluator.createCriteria(hibernateSession, clazz).add(Restrictions.in((String)ID_PROPERTY_NAME, ids));
        return DefaultBatchDynamicPropertyEvaluator.list(criteria);
    }

    private static final <T> Criteria createCriteria(Session session, Class<T> clazz) {
        return session.createCriteria(clazz);
    }

    private static final <T> List<T> list(Criteria criteria) {
        return criteria.list();
    }

    private static final <T> List<T> list(Query query) {
        return query.list();
    }

    private static <T extends IEntityInformationWithPropertiesHolder> void retainDynamicIds(Session hibernateSession, Class<T> clazz, List<Long> ids) {
        EntityKind entityKind = DefaultBatchDynamicPropertyEvaluator.getEntityKind(clazz);
        List<Long> dynamicEntityIds = DefaultBatchDynamicPropertyEvaluator.listEntityIdsWithDynamicProperty(hibernateSession, entityKind);
        ids.retainAll(dynamicEntityIds);
    }

    private static final <T extends IEntityInformationWithPropertiesHolder> EntityKind getEntityKind(Class<T> clazz) {
        return entityKindsByClass.get(clazz);
    }

    private static List<Long> listEntityIdsWithDynamicProperty(Session hibernateSession, EntityKind entityKind) throws DataAccessException {
        String query = null;
        switch (entityKind) {
            case SAMPLE: {
                query = String.format("SELECT DISTINCT sample.id FROM SamplePE sample JOIN sample.sampleType.sampleTypePropertyTypesInternal pti WHERE pti.script.scriptType = '%s'", ScriptType.DYNAMIC_PROPERTY.name());
                break;
            }
            case DATA_SET: {
                query = String.format("SELECT DISTINCT data.id FROM DataPE data JOIN data.dataSetType.dataSetTypePropertyTypesInternal pti WHERE pti.script.scriptType = '%s'", ScriptType.DYNAMIC_PROPERTY.name());
                break;
            }
            case EXPERIMENT: {
                query = String.format("SELECT DISTINCT experiment.id FROM ExperimentPE experiment JOIN experiment.experimentType.experimentTypePropertyTypesInternal pti WHERE pti.script.scriptType = '%s'", ScriptType.DYNAMIC_PROPERTY.name());
                break;
            }
            case MATERIAL: {
                query = String.format("SELECT DISTINCT material.id FROM MaterialPE material JOIN material.materialType.materialTypePropertyTypesInternal pti WHERE pti.script.scriptType = '%s'", ScriptType.DYNAMIC_PROPERTY.name());
                break;
            }
            default: {
                throw new IllegalArgumentException(entityKind.toString());
            }
        }
        List<Long> list = DefaultBatchDynamicPropertyEvaluator.list((Query)hibernateSession.createQuery(query));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("LIST: found %s ids of entities of class '%s' assigned to dynamic property.", list.size(), entityKind.getEntityTypePropertyTypeAssignmentClass().getSimpleName()));
        }
        return list;
    }

    static {
        entityKindsByClass.put(SamplePE.class, EntityKind.SAMPLE);
        entityKindsByClass.put(ExperimentPE.class, EntityKind.EXPERIMENT);
        entityKindsByClass.put(MaterialPE.class, EntityKind.MATERIAL);
        entityKindsByClass.put(DataPE.class, EntityKind.DATA_SET);
        entityKindsByClass.put(ExternalDataPE.class, EntityKind.DATA_SET);
    }
}

