/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.DynamicPropertyEvaluationOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationSchedulerWithQueue;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.DefaultBatchDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IBatchDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyCalculatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public final class DynamicPropertyEvaluationRunnable
implements Runnable {
    private static final int BATCH_SIZE = 1000;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DynamicPropertyEvaluationRunnable.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, DynamicPropertyEvaluationRunnable.class);
    private final IDynamicPropertyEvaluationSchedulerWithQueue evaluationQueue;
    private final IBatchDynamicPropertyEvaluator evaluator;
    private final TransactionTemplate transactionTemplate;

    public DynamicPropertyEvaluationRunnable(PlatformTransactionManager transactionManager, IDAOFactory daoFactory, IDynamicPropertyEvaluationSchedulerWithQueue evaluationQueue, IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.evaluationQueue = evaluationQueue;
        this.evaluator = new DefaultBatchDynamicPropertyEvaluator(1000, daoFactory, dynamicPropertyCalculatorFactory, managedPropertyEvaluatorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final synchronized void run() {
        DynamicPropertyEvaluationRunnable.operationLog.info((Object)"Start dynamic properties evaluator queue.");
        try {
            while (true) {
                operation = this.evaluationQueue.peekWait();
                if (DynamicPropertyEvaluationRunnable.operationLog.isInfoEnabled()) {
                    DynamicPropertyEvaluationRunnable.operationLog.info((Object)("Update: " + operation));
                }
                stopWatch = new StopWatch();
                stopWatch.start();
                modifiedIds = null;
                try {
                    clazz = Class.forName(operation.getClassName());
                    if (!operation.isDeletion()) {
                        modifiedIds = (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<Long>>(){

                            public List<Long> doInTransaction(TransactionStatus status) {
                                return DynamicPropertyEvaluationRunnable.this.evaluate(operation, clazz);
                            }
                        });
                    }
                    stopWatch.stop();
                }
                catch (RuntimeException e) {
                    try {
                        DynamicPropertyEvaluationRunnable.notificationLog.error((Object)("Error: " + operation + "."), (Throwable)e);
                    }
                    catch (Throwable var5_8) {
                        if (DynamicPropertyEvaluationRunnable.operationLog.isInfoEnabled()) {
                            DynamicPropertyEvaluationRunnable.operationLog.info((Object)("Update of " + (modifiedIds == null ? "" : modifiedIds.size() + " ") + operation.getClassName() + "s took " + stopWatch));
                        }
                        throw var5_8;
                    }
                    if (DynamicPropertyEvaluationRunnable.operationLog.isInfoEnabled()) {
                        DynamicPropertyEvaluationRunnable.operationLog.info((Object)("Update of " + (modifiedIds == null ? "" : modifiedIds.size() + " ") + operation.getClassName() + "s took " + stopWatch));
                    } else {
                        ** GOTO lbl29
                    }
                }
                if (DynamicPropertyEvaluationRunnable.operationLog.isInfoEnabled()) {
                    DynamicPropertyEvaluationRunnable.operationLog.info((Object)("Update of " + (modifiedIds == null ? "" : modifiedIds.size() + " ") + operation.getClassName() + "s took " + stopWatch));
                }
                this.evaluationQueue.take();
            }
        }
        catch (InterruptedException e) {
            DynamicPropertyEvaluationRunnable.operationLog.warn((Object)e);
            DynamicPropertyEvaluationRunnable.operationLog.info((Object)"Evaluation closed");
        }
        catch (Throwable th) {
            try {
                DynamicPropertyEvaluationRunnable.notificationLog.error((Object)"A problem has occurred while evaluating dynamic properties.", th);
            }
            catch (Throwable var6_9) {
                throw var6_9;
            }
            finally {
                DynamicPropertyEvaluationRunnable.operationLog.info((Object)"Evaluation closed");
            }
        }
    }

    private List<Long> evaluate(DynamicPropertyEvaluationOperation operation, Class<IEntityInformationWithPropertiesHolder> clazz) {
        if (operation.getIds() == null) {
            return this.evaluator.doEvaluateProperties(clazz);
        }
        ArrayList<Long> ids = new ArrayList<Long>(operation.getIds());
        return this.evaluator.doEvaluateProperties(clazz, ids);
    }
}

