/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.common.resource.IReleasable;
import ch.systemsx.cisd.common.resource.Resources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.BasicPropertyAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.DynamicPropertyAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.XmlPropertyAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityPropertyAdaptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class AbstractEntityAdaptor
implements IEntityAdaptor,
IReleasable {
    private final String code;
    protected final IEntityPropertiesHolder propertiesHolder;
    protected Map<String, IEntityPropertyAdaptor> propertiesByCode;
    protected final IDynamicPropertyEvaluator evaluator;
    private Resources resources;
    protected static String ENTITY_TYPE_CODE_FIELD = "type code";
    protected static String ENTITY_TYPE_ANY_CODE_REGEXP = ".*";

    public AbstractEntityAdaptor(String code, Collection<IEntityPropertyAdaptor> properties) {
        this.code = code;
        this.propertiesHolder = null;
        this.evaluator = null;
        this.initPropertiesMap(properties);
    }

    public AbstractEntityAdaptor(IEntityPropertiesHolder propertiesHolder, IDynamicPropertyEvaluator propertyEvaluator) {
        this.code = propertiesHolder.getCode();
        this.propertiesHolder = propertiesHolder;
        this.evaluator = propertyEvaluator;
    }

    private void initPropertiesMap() {
        if (this.propertiesHolder == null) {
            throw new IllegalStateException("Couldn't init properties if the properties holder has not been set");
        }
        if (this.evaluator == null) {
            throw new IllegalStateException("Couldn't init properties if the property evaluator has not been set");
        }
        this.propertiesByCode = new HashMap<String, IEntityPropertyAdaptor>();
        for (EntityPropertyPE entityPropertyPE : this.propertiesHolder.getProperties()) {
            this.addProperty(AbstractEntityAdaptor.adaptEntityProperty(entityPropertyPE, this, this.evaluator));
        }
    }

    public static IEntityPropertyAdaptor adaptEntityProperty(EntityPropertyPE property, IEntityAdaptor entityAdaptor, IDynamicPropertyEvaluator evaluator) {
        String value;
        EntityTypePropertyTypePE etpt = property.getEntityTypePropertyType();
        PropertyTypePE propertyType = etpt.getPropertyType();
        String propertyTypeCode = propertyType.getCode();
        if (etpt.isDynamic()) {
            return new DynamicPropertyAdaptor(propertyTypeCode, entityAdaptor, property, evaluator);
        }
        if (property.getMaterialValue() != null) {
            MaterialPE material = property.getMaterialValue();
            value = MaterialIdentifier.print(material.getCode(), material.getEntityType().getCode());
        } else {
            value = property.getVocabularyTerm() != null ? property.getVocabularyTerm().getCode() : property.getValue();
        }
        if (propertyType.getTransformation() == null) {
            return new BasicPropertyAdaptor(propertyTypeCode, value, property);
        }
        return new XmlPropertyAdaptor(propertyTypeCode, value, property, propertyType.getTransformation());
    }

    private void initPropertiesMap(Collection<IEntityPropertyAdaptor> properties) {
        this.propertiesByCode = new HashMap<String, IEntityPropertyAdaptor>();
        if (properties != null) {
            for (IEntityPropertyAdaptor property : properties) {
                this.addProperty(property);
            }
        }
    }

    private Map<String, IEntityPropertyAdaptor> propertiesMap() {
        if (this.propertiesByCode == null) {
            this.initPropertiesMap();
        }
        return this.propertiesByCode;
    }

    private void addProperty(IEntityPropertyAdaptor property) {
        this.propertiesMap().put(property.propertyTypeCode().toUpperCase(), property);
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public IEntityPropertyAdaptor property(String propertyTypeCode) {
        return this.propertiesMap().get(propertyTypeCode.toUpperCase());
    }

    @Override
    public String propertyValue(String propertyTypeCode) {
        IEntityPropertyAdaptor propertyOrNull = this.property(propertyTypeCode);
        return propertyOrNull == null ? "" : propertyOrNull.valueAsString();
    }

    @Override
    public String propertyRendered(String propertyTypeCode) {
        IEntityPropertyAdaptor propertyOrNull = this.property(propertyTypeCode);
        return propertyOrNull == null ? "" : propertyOrNull.renderedValue();
    }

    @Override
    public Collection<IEntityPropertyAdaptor> properties() {
        return this.propertiesMap().values();
    }

    public void release() {
        if (this.resources != null) {
            this.resources.release();
        }
    }

    protected Resources getResources() {
        if (this.resources == null) {
            this.resources = new Resources();
        }
        return this.resources;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.code());
        return builder.toString();
    }
}

