/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.SearchDataSetsOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.SearchSamplesOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.AbstractEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.ExternalDataAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.INonAbstractEntityAdapter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.SampleAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IDataAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IExperimentAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.ISampleAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.Session;

public class ExperimentAdaptor
extends AbstractEntityAdaptor
implements IExperimentAdaptor,
INonAbstractEntityAdapter {
    private final ExperimentPE experimentPE;
    private final Session session;

    public ExperimentAdaptor(ExperimentPE experimentPE, IDynamicPropertyEvaluator evaluator, Session session) {
        super(experimentPE, evaluator);
        this.session = session;
        this.experimentPE = experimentPE;
    }

    public ExperimentPE experimentPE() {
        return this.experimentPE;
    }

    @Override
    public ExperimentPE entityPE() {
        return this.experimentPE();
    }

    @Override
    public Iterable<ISampleAdaptor> samples() {
        return this.samplesOfType("*");
    }

    @Override
    public Iterable<ISampleAdaptor> samplesOfType(String typeRegexp) {
        IDAOFactory daoFactory = CommonServiceProvider.getDAOFactory();
        SearchSamplesOperationExecutor searchSamplesOperationExecutor = (SearchSamplesOperationExecutor)CommonServiceProvider.tryToGetBean("search-samples-operation-executor");
        IPersonDAO personDAO = daoFactory.getPersonDAO();
        ISampleDAO sampleDAO = daoFactory.getSampleDAO();
        SampleFetchOptions fetchOptions = new SampleFetchOptions();
        SampleSearchCriteria criteria = (SampleSearchCriteria)new SampleSearchCriteria().withAndOperator();
        criteria.withType().withCode().thatEquals(typeRegexp);
        criteria.withExperiment().withPermId().thatEquals(String.valueOf(this.experimentPE.getPermId()));
        PersonPE systemUser = personDAO.tryFindPersonByUserId("system");
        Collection<Long> ids = searchSamplesOperationExecutor.executeDirectSQLSearchForIds(systemUser, criteria, fetchOptions);
        List<SamplePE> samplePEs = sampleDAO.listByIDs(ids);
        return samplePEs.stream().map(samplePE -> new SampleAdaptor((SamplePE)samplePE, this.evaluator, this.session)).collect(Collectors.toList());
    }

    @Override
    public Iterable<IDataAdaptor> dataSets() {
        return this.dataSetsOfType("*");
    }

    @Override
    public Iterable<IDataAdaptor> dataSetsOfType(String typeRegexp) {
        IDAOFactory daoFactory = CommonServiceProvider.getDAOFactory();
        SearchDataSetsOperationExecutor searchDataSetsOperationExecutor = (SearchDataSetsOperationExecutor)CommonServiceProvider.tryToGetBean("search-data-sets-operation-executor");
        IPersonDAO personDAO = daoFactory.getPersonDAO();
        IDataDAO dataSetDAO = daoFactory.getDataDAO();
        DataSetFetchOptions fetchOptions = new DataSetFetchOptions();
        DataSetSearchCriteria criteria = (DataSetSearchCriteria)new DataSetSearchCriteria().withAndOperator();
        criteria.withType().withCode().thatEquals(typeRegexp);
        criteria.withExperiment().withPermId().thatEquals(this.experimentPE.getPermId());
        PersonPE systemUser = personDAO.tryFindPersonByUserId("system");
        Collection<Long> ids = searchDataSetsOperationExecutor.executeDirectSQLSearchForIds(systemUser, criteria, fetchOptions);
        List<DataPE> dataPEs = dataSetDAO.listByIDs(ids);
        return dataPEs.stream().map(dataPE -> new ExternalDataAdaptor((DataPE)dataPE, this.evaluator, this.session)).collect(Collectors.toList());
    }
}

