/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.systemsx.cisd.common.resource.ReleasableIterable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.AbstractEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.EntityAdaptorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.ExternalDataAdaptorRelationsLoader;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.INonAbstractEntityAdapter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IDataAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IExperimentAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.ISampleAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.List;
import org.hibernate.Session;

public class ExternalDataAdaptor
extends AbstractEntityAdaptor
implements IDataAdaptor,
INonAbstractEntityAdapter {
    private final DataPE externalDataPE;
    private final Session session;

    public ExternalDataAdaptor(DataPE externalDataPE, IDynamicPropertyEvaluator evaluator, Session session) {
        super(externalDataPE, evaluator);
        this.session = session;
        this.externalDataPE = externalDataPE;
    }

    public DataPE externalDataPE() {
        return this.externalDataPE;
    }

    @Override
    public DataPE entityPE() {
        return this.externalDataPE();
    }

    @Override
    public IExperimentAdaptor experiment() {
        ExperimentPE experiment = this.externalDataPE.getExperiment();
        if (experiment != null) {
            IExperimentAdaptor adaptor = EntityAdaptorFactory.create(experiment, this.evaluator, this.session);
            this.getResources().add((Object)adaptor);
            return adaptor;
        }
        return null;
    }

    @Override
    public ISampleAdaptor sample() {
        SamplePE sample = this.externalDataPE.tryGetSample();
        if (sample != null) {
            ISampleAdaptor adaptor = EntityAdaptorFactory.create(sample, this.evaluator, this.session);
            this.getResources().add((Object)adaptor);
            return adaptor;
        }
        return null;
    }

    @Override
    public Iterable<IDataAdaptor> parents() {
        return this.parentsOfType(ENTITY_TYPE_ANY_CODE_REGEXP);
    }

    @Override
    public Iterable<IDataAdaptor> parentsOfType(String typeCodeRegexp) {
        return this.getParentsOfType(typeCodeRegexp, this.evaluator.getParentChildRelationshipTypeId());
    }

    private Iterable<IDataAdaptor> getParentsOfType(String typeCodeRegexp, Long relationshipTypeId) {
        ReleasableIterable iterable = new ReleasableIterable(new ExternalDataAdaptorRelationsLoader(this.externalDataPE, this.evaluator, this.session).parentsOfType(typeCodeRegexp, relationshipTypeId));
        this.getResources().add((Object)iterable);
        return iterable;
    }

    @Override
    public Iterable<IDataAdaptor> children() {
        return this.childrenOfType(ENTITY_TYPE_ANY_CODE_REGEXP);
    }

    @Override
    public Iterable<IDataAdaptor> childrenOfType(String typeCodeRegexp) {
        return this.getChildrenOfType(typeCodeRegexp, this.evaluator.getParentChildRelationshipTypeId());
    }

    private Iterable<IDataAdaptor> getChildrenOfType(String typeCodeRegexp, Long relationshipTypeId) {
        ReleasableIterable iterable = new ReleasableIterable(new ExternalDataAdaptorRelationsLoader(this.externalDataPE, this.evaluator, this.session).childrenOfType(typeCodeRegexp, relationshipTypeId));
        this.getResources().add((Object)iterable);
        return iterable;
    }

    @Override
    public IDataAdaptor container() {
        List<DataSetRelationshipPE> relationships = RelationshipUtils.getContainerComponentRelationships(this.externalDataPE.getParentRelationships());
        if (relationships.isEmpty()) {
            return null;
        }
        IDataAdaptor adaptor = EntityAdaptorFactory.create(relationships.get(0).getParentDataSet(), this.evaluator, this.session);
        this.getResources().add((Object)adaptor);
        return adaptor;
    }

    @Override
    public Iterable<IDataAdaptor> containers() {
        return this.getParentsOfType(ENTITY_TYPE_ANY_CODE_REGEXP, this.evaluator.getContainerComponentRelationshipTypeId());
    }

    @Override
    public Iterable<IDataAdaptor> contained() {
        return this.containedOfType(ENTITY_TYPE_ANY_CODE_REGEXP);
    }

    @Override
    public Iterable<IDataAdaptor> containedOfType(String typeCodeRegexp) {
        return this.getChildrenOfType(typeCodeRegexp, this.evaluator.getContainerComponentRelationshipTypeId());
    }
}

