/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.common.jython.evaluator.IJythonEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.INonAbstractEntityAdapter;
import ch.systemsx.cisd.openbis.generic.shared.IJythonEvaluatorPool;
import ch.systemsx.cisd.openbis.generic.shared.calculator.AbstractCalculator;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IAtomicEvaluation;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IEvaluationRunner;

public class JythonEntityValidationCalculator {
    private static final String ENTITY_VARIABLE_NAME = "__entity";
    private static final String IS_NEW_ENTITY_VARIABLE_NAME = "__isNewEntity";
    private static final String INVOKE_CALCULATE_EXPR = "validate(__entity, __isNewEntity)";
    private static final String CALCULATOR_VARIABLE = "__calculator";
    private static final String VALIDATION_REQUEST_FUNCTION = "def requestValidation(entity):\n  __calculator.requestValidation(entity)\n";
    private final IEvaluationRunner runner;
    private final IValidationRequestDelegate<Object> wrappedValidationRequestedDelegate;

    public static JythonEntityValidationCalculator create(String expression, IValidationRequestDelegate<INonAbstractEntityAdapter> validationRequestedDelegate, IJythonEvaluatorPool jythonEvaluatorPool) {
        String initialScript = AbstractCalculator.getBasicInitialScript();
        initialScript = initialScript + VALIDATION_REQUEST_FUNCTION;
        initialScript = initialScript + expression;
        String calculatedExpression = INVOKE_CALCULATE_EXPR;
        return new JythonEntityValidationCalculator(jythonEvaluatorPool.getRunner(calculatedExpression, Math.class, initialScript), validationRequestedDelegate);
    }

    public JythonEntityValidationCalculator(IEvaluationRunner runner, final IValidationRequestDelegate<INonAbstractEntityAdapter> validationRequested) {
        this.runner = runner;
        this.wrappedValidationRequestedDelegate = new IValidationRequestDelegate<Object>(){

            @Override
            public void requestValidation(Object entity) {
                if (entity == null) {
                    return;
                }
                if (!(entity instanceof INonAbstractEntityAdapter)) {
                    throw new IllegalArgumentException("Trying to force the validation of an object of invalid type " + entity.getClass());
                }
                validationRequested.requestValidation((INonAbstractEntityAdapter)entity);
            }
        };
    }

    public String eval(final IEntityAdaptor entity, final boolean isNewEntity) throws EvaluatorException {
        return this.runner.evaluate(new IAtomicEvaluation<String>(){

            @Override
            public String evaluate(IJythonEvaluator evaluator) {
                evaluator.set(JythonEntityValidationCalculator.CALCULATOR_VARIABLE, (Object)JythonEntityValidationCalculator.this.wrappedValidationRequestedDelegate);
                evaluator.set(JythonEntityValidationCalculator.ENTITY_VARIABLE_NAME, (Object)entity);
                evaluator.set(JythonEntityValidationCalculator.IS_NEW_ENTITY_VARIABLE_NAME, (Object)isNewEntity);
                return evaluator.evalAsStringLegacy2_2();
            }
        });
    }

    public void checkScriptCompilation() {
        this.runner.evaluate(new IAtomicEvaluation<Void>(){

            @Override
            public Void evaluate(IJythonEvaluator evaluator) {
                return null;
            }
        });
    }

    public static interface IValidationRequestDelegate<T> {
        public void requestValidation(T var1);
    }
}

