/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.SearchDataSetsOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.SearchSamplesOperationExecutor;
import ch.systemsx.cisd.common.resource.ReleasableIterable;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.AbstractEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.EntityAdaptorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.ExternalDataAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.INonAbstractEntityAdapter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.SampleAdaptorRelationsLoader;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IDataAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IExperimentAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.ISampleAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.Session;

public class SampleAdaptor
extends AbstractEntityAdaptor
implements ISampleAdaptor,
INonAbstractEntityAdapter {
    private final SamplePE samplePE;
    private final Session session;

    public SampleAdaptor(SamplePE samplePE, IDynamicPropertyEvaluator evaluator, Session session) {
        super(samplePE, evaluator);
        this.session = session;
        this.samplePE = samplePE;
    }

    public SamplePE samplePE() {
        return this.samplePE;
    }

    @Override
    public SamplePE entityPE() {
        return this.samplePE();
    }

    @Override
    public IExperimentAdaptor experiment() {
        IExperimentAdaptor adaptor = EntityAdaptorFactory.create(this.samplePE.getExperiment(), this.evaluator, this.session);
        this.getResources().add((Object)adaptor);
        return adaptor;
    }

    @Override
    public Iterable<ISampleAdaptor> parents() {
        return this.parentsOfType(ENTITY_TYPE_ANY_CODE_REGEXP);
    }

    @Override
    public Iterable<ISampleAdaptor> parentsOfType(String typeCodeRegexp) {
        ReleasableIterable iterable = new ReleasableIterable(new SampleAdaptorRelationsLoader(this.samplePE, this.evaluator, this.session).parentsOfType(typeCodeRegexp));
        this.getResources().add((Object)iterable);
        return iterable;
    }

    @Override
    public Iterable<ISampleAdaptor> children() {
        return this.childrenOfType(ENTITY_TYPE_ANY_CODE_REGEXP);
    }

    @Override
    public Iterable<ISampleAdaptor> childrenOfType(String typeCodeRegexp) {
        ReleasableIterable iterable = new ReleasableIterable(new SampleAdaptorRelationsLoader(this.samplePE, this.evaluator, this.session).childrenOfType(typeCodeRegexp));
        this.getResources().add((Object)iterable);
        return iterable;
    }

    @Override
    public ISampleAdaptor container() {
        SamplePE container = this.samplePE.getContainer();
        if (container != null) {
            ISampleAdaptor adaptor = EntityAdaptorFactory.create(container, this.evaluator, this.session);
            this.getResources().add((Object)adaptor);
            return adaptor;
        }
        return null;
    }

    @Override
    public Iterable<ISampleAdaptor> contained() {
        return this.containedOfType("*");
    }

    @Override
    public Iterable<ISampleAdaptor> containedOfType(String typeCodeRegexp) {
        IDAOFactory daoFactory = CommonServiceProvider.getDAOFactory();
        SearchSamplesOperationExecutor searchSamplesOperationExecutor = (SearchSamplesOperationExecutor)CommonServiceProvider.tryToGetBean("search-samples-operation-executor");
        IPersonDAO personDAO = daoFactory.getPersonDAO();
        ISampleDAO sampleDAO = daoFactory.getSampleDAO();
        SampleFetchOptions fetchOptions = new SampleFetchOptions();
        SampleSearchCriteria criteria = (SampleSearchCriteria)new SampleSearchCriteria().withAndOperator();
        criteria.withContainer().withPermId().thatEquals(this.samplePE.getPermId());
        criteria.withType().withCode().thatEquals(typeCodeRegexp);
        PersonPE systemUser = personDAO.tryFindPersonByUserId("system");
        Collection<Long> ids = searchSamplesOperationExecutor.executeDirectSQLSearchForIds(systemUser, criteria, fetchOptions);
        List<SamplePE> samplePEs = sampleDAO.listByIDs(ids);
        return samplePEs.stream().map(samplePE -> new SampleAdaptor((SamplePE)samplePE, this.evaluator, this.session)).collect(Collectors.toList());
    }

    @Override
    public Iterable<IDataAdaptor> dataSets() {
        return this.dataSetsOfType("*");
    }

    @Override
    public Iterable<IDataAdaptor> dataSetsOfType(String typeCodeRegexp) {
        IDAOFactory daoFactory = CommonServiceProvider.getDAOFactory();
        SearchDataSetsOperationExecutor searchDataSetsOperationExecutor = (SearchDataSetsOperationExecutor)CommonServiceProvider.tryToGetBean("search-data-sets-operation-executor");
        IPersonDAO personDAO = daoFactory.getPersonDAO();
        IDataDAO dataSetDAO = daoFactory.getDataDAO();
        DataSetFetchOptions fetchOptions = new DataSetFetchOptions();
        DataSetSearchCriteria criteria = (DataSetSearchCriteria)new DataSetSearchCriteria().withAndOperator();
        criteria.withSample().withPermId().thatEquals(this.samplePE.getPermId());
        criteria.withType().withCode().thatEquals(typeCodeRegexp);
        PersonPE systemUser = personDAO.tryFindPersonByUserId("system");
        Collection<Long> ids = searchDataSetsOperationExecutor.executeDirectSQLSearchForIds(systemUser, criteria, fetchOptions);
        List<DataPE> dataPEs = dataSetDAO.listByIDs(ids);
        return dataPEs.stream().map(dataPE -> new ExternalDataAdaptor((DataPE)dataPE, this.evaluator, this.session)).collect(Collectors.toList());
    }
}

