/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.BasicPropertyAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.util.XmlUtils;

public class XmlPropertyAdaptor
extends BasicPropertyAdaptor {
    private final String xsltTransformation;
    private String renderedValue = null;

    public XmlPropertyAdaptor(String code, String value, EntityPropertyPE propertyPE, String xsltTransformation) {
        super(code, value, propertyPE);
        this.xsltTransformation = xsltTransformation;
    }

    public XmlPropertyAdaptor(String code, String value, String xsltTransformation) {
        this(code, value, null, xsltTransformation);
    }

    @Override
    public String renderedValue() {
        if (this.renderedValue == null) {
            this.renderedValue = this.doRenderValue();
        }
        return this.renderedValue;
    }

    private String doRenderValue() {
        String xml = super.valueAsString();
        return XmlUtils.transform(this.xsltTransformation, xml);
    }

    @Override
    public String toString() {
        return this.propertyTypeCode() + "\nvalue:\n" + this.valueAsString() + "\nrendered:\n" + this.renderedValue();
    }
}

