/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.hotfix;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.update.SampleUpdate;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;

public class ELNAnnotationsMigration {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ELNAnnotationsMigration.class);

    private static boolean contains(String permId, List<Sample> samples) {
        for (Sample sample : samples) {
            if (!sample.getPermId().getPermId().equals(permId)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static void beforeUpgrade() throws Exception {
        ELNAnnotationsMigration.operationLog.info((Object)"ELNAnnotationsMigration beforeUpgrade START");
        api = CommonServiceProvider.getApplicationServerApi();
        sessionToken = api.loginAsSystem();
        criteria = new SampleSearchCriteria();
        criteria.withProperty("$ANNOTATIONS_STATE");
        options = new SampleFetchOptions();
        options.withProperties();
        options.withParents();
        options.withChildren();
        options.sortBy().permId();
        options.from(Integer.valueOf(0));
        options.count(Integer.valueOf(0));
        results = api.searchSamples(sessionToken, criteria, options);
        count = 10000;
        total = results.getTotalCount();
        ELNAnnotationsMigration.operationLog.info((Object)("ELNAnnotationsMigration from: " + from + " count: " + count + " total: " + total));
        sampleUpdates = new ArrayList<SampleUpdate>();
        exceptionsTotal = 0;
        exceptionsPermIds = new ArrayList<String>();
        skippedTotal = 0;
        skippedPermIds = new ArrayList<String>();
        for (from = 0; total > from; from += count) {
            options.from(Integer.valueOf(from));
            options.count(Integer.valueOf(count));
            ELNAnnotationsMigration.operationLog.info((Object)("ELNAnnotationsMigration from: " + from + " count: " + count + " total: " + total));
            for (Sample sample : api.searchSamples(sessionToken, criteria, options).getObjects()) {
                sampleUpdate = null;
                annotations = sample.getProperty("$ANNOTATIONS_STATE");
                if (!annotations.isEmpty() && !annotations.startsWith("\ufffd")) {
                    factory = DocumentBuilderFactory.newInstance();
                    builder = factory.newDocumentBuilder();
                    input = new ByteArrayInputStream(annotations.getBytes("UTF-8"));
                    try {
                        document = builder.parse(input);
                        documentElement = document.getDocumentElement();
                        if (!documentElement.hasChildNodes()) ** GOTO lbl85
                        sampleNodes = documentElement.getChildNodes();
                        for (sampleIdx = 0; sampleIdx < sampleNodes.getLength(); ++sampleIdx) {
                            sampleNode = sampleNodes.item(sampleIdx);
                            sampleNodeAttributes = sampleNode.getAttributes();
                            sampleNodeAttributesNumber = sampleNodeAttributes.getLength();
                            if (sampleNodeAttributesNumber <= 3) continue;
                            samplePermId = sampleNodeAttributes.getNamedItem("permId").getNodeValue();
                            for (attributeIdx = 0; attributeIdx < sampleNodeAttributes.getLength(); ++attributeIdx) {
                                attributeNode = sampleNodeAttributes.item(attributeIdx);
                                name = attributeNode.getNodeName();
                                v0 = isInfoProperty = name.equals("permId") != false || name.equals("identifier") != false || name.equals("sampleType") != false;
                                if (isInfoProperty) continue;
                                value = attributeNode.getNodeValue();
                                isParent = ELNAnnotationsMigration.contains(samplePermId, sample.getParents());
                                isChildren = ELNAnnotationsMigration.contains(samplePermId, sample.getChildren());
                                if (!isParent && !isChildren) continue;
                                if (sampleUpdate == null) {
                                    sampleUpdate = new SampleUpdate();
                                    sampleUpdate.setSampleId((ISampleId)sample.getPermId());
                                }
                                if (isParent) {
                                    sampleUpdate.relationship((ISampleId)new SamplePermId(samplePermId)).addParentAnnotation(name, value);
                                }
                                if (!isChildren) continue;
                                sampleUpdate.relationship((ISampleId)new SamplePermId(samplePermId)).addChildAnnotation(name, value);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ++exceptionsTotal;
                        exceptionsPermIds.add(sample.getPermId().getPermId());
                        ELNAnnotationsMigration.operationLog.info((Object)("ELNAnnotationsMigration FAILED: " + sample.getPermId().getPermId() + " $ANNOTATIONS_STATE = " + annotations));
                        ex.printStackTrace();
                    }
                } else {
                    ++skippedTotal;
                    skippedPermIds.add(sample.getPermId().getPermId());
                    ELNAnnotationsMigration.operationLog.info((Object)("ELNAnnotationsMigration SKIPPED: " + sample.getPermId().getPermId() + " $ANNOTATIONS_STATE = " + annotations));
                }
lbl85:
                // 4 sources

                if (sampleUpdate == null) continue;
                sampleUpdates.add(sampleUpdate);
            }
        }
        ELNAnnotationsMigration.operationLog.info((Object)"=== ELNAnnotationsMigration Summary ===");
        ELNAnnotationsMigration.operationLog.info((Object)("ELNAnnotationsMigration exceptionsTotal: " + exceptionsTotal));
        ELNAnnotationsMigration.operationLog.info((Object)("ELNAnnotationsMigration skippedTotal: " + skippedTotal));
        ELNAnnotationsMigration.operationLog.info((Object)("ELNAnnotationsMigration updateSamples sampleUpdates.size: " + sampleUpdates.size()));
        api.updateSamples(sessionToken, sampleUpdates);
        ELNAnnotationsMigration.operationLog.info((Object)("ELNAnnotationsMigration exceptionsPermIds: " + exceptionsPermIds));
        ELNAnnotationsMigration.operationLog.info((Object)("ELNAnnotationsMigration skippedPermIds: " + skippedPermIds));
        ELNAnnotationsMigration.operationLog.info((Object)"ELNAnnotationsMigration beforeUpgrade END");
    }
}

