/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.hotfix;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.ListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.IEntityTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.ExperimentType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.search.ExperimentSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.update.ExperimentTypeUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyAssignment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.create.PropertyAssignmentCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.IPropertyTypeId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.IApplicationServerInternalApi;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOFactory;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;
import org.hibernate.query.NativeQuery;

public class ELNCollectionTypeMigration {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ELNCollectionTypeMigration.class);
    private static final String COLLECTION = "COLLECTION";
    private static final String[] experimentsOfTypeCollection = new String[]{"STORAGES_COLLECTION", "GENERAL_PROTOCOLS", "PRODUCT_COLLECTION", "SUPPLIER_COLLECTION", "REQUEST_COLLECTION", "ORDER_COLLECTION", "TEMPLATES_COLLECTION", "PUBLICATIONS_COLLECTION", "ANTIBODY_COLLECTION", "CHEMICAL_COLLECTION", "ENZYME_COLLECTION", "MEDIA_COLLECTION", "SOLUTION_BUFFER_COLLECTION", "BACTERIA_COLLECTION", "CELL_LINE_COLLECTION", "FLY_COLLECTION", "YEAST_COLLECTION", "PLASMID_COLLECTION", "OLIGO_COLLECTION", "RNA_COLLECTION", "PCR_PROTOCOLS", "WESTERN_BLOTTING_PROTOCOLS", "PLANT_COLLECTION"};
    private static final Map<String, String> PROPERTY_UPDATES_MAP = Stream.of(new AbstractMap.SimpleEntry<String, String>("COMPANY", "PRODUCT.COMPANY"), new AbstractMap.SimpleEntry<String, String>("SIZE_OF_ITEM", "PRODUCT.SIZE_OF_ITEM"), new AbstractMap.SimpleEntry<String, String>("HAZARD_STATEMENT", "PRODUCT.HAZARD_STATEMENT"), new AbstractMap.SimpleEntry<String, String>("CATEGORY", "PRODUCT.CATEGORY"), new AbstractMap.SimpleEntry<String, String>("DESCRIPTION", "PRODUCT.DESCRIPTION"), new AbstractMap.SimpleEntry<String, String>("PRODUCT_SECONDARY_NAMES", "PRODUCT.PRODUCT_SECONDARY_NAMES"), new AbstractMap.SimpleEntry<String, String>("ORDER_NUMBER", "REQUEST.ORDER_NUMBER"), new AbstractMap.SimpleEntry<String, String>("DEPARTMENT", "REQUEST.DEPARTMENT"), new AbstractMap.SimpleEntry<String, String>("BUYER", "REQUEST.BUYER"), new AbstractMap.SimpleEntry<String, String>("PROJECT", "REQUEST.PROJECT"), new AbstractMap.SimpleEntry<String, String>("URL", "SUPPLIER.URL"), new AbstractMap.SimpleEntry<String, String>("PREFERRED_ORDER_METHOD", "SUPPLIER.PREFERRED_ORDER_METHOD"), new AbstractMap.SimpleEntry<String, String>("COMPANY_CONTACT_EMAIL", "SUPPLIER.COMPANY_CONTACT_EMAIL"), new AbstractMap.SimpleEntry<String, String>("COMPANY_CONTACT_NAME", "SUPPLIER.COMPANY_CONTACT_NAME"), new AbstractMap.SimpleEntry<String, String>("PRICE_PAID", "ORDER.PRICE_PAID"), new AbstractMap.SimpleEntry<String, String>("PROTOCOL_TYPE", "GENERAL_PROTOCOL.PROTOCOL_TYPE"), new AbstractMap.SimpleEntry<String, String>("PROTOCOL_EVALUATION", "GENERAL_PROTOCOL.PROTOCOL_EVALUATION"), new AbstractMap.SimpleEntry<String, String>("TIME_REQUIREMENT", "GENERAL_PROTOCOL.TIME_REQUIREMENT"), new AbstractMap.SimpleEntry<String, String>("MATERIALS", "GENERAL_PROTOCOL.MATERIALS"), new AbstractMap.SimpleEntry<String, String>("GRANT", "DEFAULT_EXPERIMENT.GRANT"), new AbstractMap.SimpleEntry<String, String>("EXPERIMENTAL_RESULTS", "EXPERIMENTAL_STEP.EXPERIMENTAL_RESULTS"), new AbstractMap.SimpleEntry<String, String>("EXPERIMENTAL_GOALS", "EXPERIMENTAL_STEP.EXPERIMENTAL_GOALS"), new AbstractMap.SimpleEntry<String, String>("EXPERIMENTAL_PROCEDURE", "EXPERIMENTAL_STEP.EXPERIMENTAL_DESCRIPTION")).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    private static final String[] WIDGET_POST_UPDATES = new String[]{"UPDATE property_types SET meta_data = '{ \"custom_widget\" : \"Word Processor\" }'::jsonb WHERE id IN (SELECT id FROM property_types WHERE daty_id = (SELECT id FROM data_types WHERE code = 'MULTILINE_VARCHAR'));", "UPDATE property_types SET meta_data = NULL WHERE id IN (SELECT id FROM property_types WHERE daty_id IN (SELECT id FROM data_types WHERE code NOT IN ('MULTILINE_VARCHAR', 'XML')));", "UPDATE property_types SET meta_data = NULL WHERE code IN ('NAME', 'SEQUENCE', 'AUTHORS', 'FREEFORM_TABLE_STATE');"};

    private static Set<ExperimentType> getExperimentTypes(String[] experimentCodes) {
        IApplicationServerInternalApi api = CommonServiceProvider.getApplicationServerApi();
        String sessionToken = api.loginAsSystem();
        ExperimentSearchCriteria esc = new ExperimentSearchCriteria();
        esc.withOrOperator();
        for (String experimentOfTypeCollection : experimentCodes) {
            esc.withCode().thatEquals(experimentOfTypeCollection);
        }
        ExperimentFetchOptions efo = new ExperimentFetchOptions();
        efo.withType().withPropertyAssignments().withPropertyType();
        SearchResult experimentSearchResult = api.searchExperiments(sessionToken, esc, efo);
        HashSet<ExperimentType> experimentTypes = new HashSet<ExperimentType>();
        for (Experiment experiment : experimentSearchResult.getObjects()) {
            experimentTypes.add(experiment.getType());
        }
        return experimentTypes;
    }

    private static ExperimentType getExperimentType(String experimentTypeCode) {
        IApplicationServerInternalApi api = CommonServiceProvider.getApplicationServerApi();
        String sessionToken = api.loginAsSystem();
        ExperimentTypeFetchOptions etfo = new ExperimentTypeFetchOptions();
        etfo.withPropertyAssignments().withPropertyType();
        EntityTypePermId COLLECTION = new EntityTypePermId(experimentTypeCode);
        Map collectionType = api.getExperimentTypes(sessionToken, Arrays.asList(COLLECTION), etfo);
        ExperimentType experimentTypeCOLLECTION = (ExperimentType)collectionType.get(COLLECTION);
        return experimentTypeCOLLECTION;
    }

    private static Set<PropertyType> getPropertyTypes(ExperimentType type) {
        HashSet<PropertyType> propertyTypes = new HashSet<PropertyType>();
        for (PropertyAssignment propertyAssignment : type.getPropertyAssignments()) {
            propertyTypes.add(propertyAssignment.getPropertyType());
        }
        return propertyTypes;
    }

    private static Set<String> getPropertyTypesCodes(ExperimentType type) {
        HashSet<String> propertyTypes = new HashSet<String>();
        for (PropertyAssignment propertyAssignment : type.getPropertyAssignments()) {
            propertyTypes.add(propertyAssignment.getPropertyType().getCode());
        }
        return propertyTypes;
    }

    private static void addMissingProperties(String experimentTypeCode, Set<PropertyType> missingPropertyTypes) {
        IApplicationServerInternalApi api = CommonServiceProvider.getApplicationServerApi();
        String sessionToken = api.loginAsSystem();
        ArrayList<PropertyAssignmentCreation> propertiesToAdd = new ArrayList<PropertyAssignmentCreation>();
        for (PropertyType propertyType : missingPropertyTypes) {
            PropertyAssignmentCreation pac = new PropertyAssignmentCreation();
            pac.setPropertyTypeId((IPropertyTypeId)propertyType.getPermId());
            propertiesToAdd.add(pac);
        }
        EntityTypePermId experimentPermId = new EntityTypePermId(experimentTypeCode);
        ExperimentTypeUpdate experimentTypeUpdate = new ExperimentTypeUpdate();
        experimentTypeUpdate.setTypeId((IEntityTypeId)experimentPermId);
        ListUpdateValue.ListUpdateActionAdd luaa = new ListUpdateValue.ListUpdateActionAdd();
        luaa.setItems(propertiesToAdd);
        experimentTypeUpdate.setPropertyAssignmentActions(Arrays.asList(luaa));
        ArrayList<ExperimentTypeUpdate> experimentTypeUpdates = new ArrayList<ExperimentTypeUpdate>();
        experimentTypeUpdates.add(experimentTypeUpdate);
        if (!experimentTypeUpdates.isEmpty()) {
            api.updateExperimentTypes(sessionToken, experimentTypeUpdates);
        }
    }

    static List executeNativeQuery(String SQL) {
        DAOFactory daoFactory = (DAOFactory)CommonServiceProvider.getApplicationContext().getBean("dao-factory");
        Session currentSession = daoFactory.getSessionFactory().getCurrentSession();
        NativeQuery nativeQuery = currentSession.createNativeQuery(SQL);
        List result = nativeQuery.getResultList();
        return result;
    }

    static List executeNativeQuery(String SQL, String key, Object value) {
        DAOFactory daoFactory = (DAOFactory)CommonServiceProvider.getApplicationContext().getBean("dao-factory");
        Session currentSession = daoFactory.getSessionFactory().getCurrentSession();
        NativeQuery nativeQuery = currentSession.createNativeQuery(SQL);
        nativeQuery.setParameter(key, value);
        List result = nativeQuery.getResultList();
        return result;
    }

    static void executeNativeUpdate(String SQL, String ukey, Object uValue, String ckey, Object cValue) {
        DAOFactory daoFactory = (DAOFactory)CommonServiceProvider.getApplicationContext().getBean("dao-factory");
        Session currentSession = daoFactory.getSessionFactory().getCurrentSession();
        NativeQuery nativeQuery = currentSession.createNativeQuery(SQL);
        if (ukey != null) {
            nativeQuery.setParameter(ukey, uValue);
        }
        if (ckey != null) {
            nativeQuery.setParameter(ckey, cValue);
        }
        nativeQuery.executeUpdate();
    }

    static void executeNativeUpdate(String SQL) {
        try {
            DAOFactory daoFactory = (DAOFactory)CommonServiceProvider.getApplicationContext().getBean("dao-factory");
            Session currentSession = daoFactory.getSessionFactory().getCurrentSession();
            Connection connection = ((SessionImpl)currentSession).connection();
            PreparedStatement statement = connection.prepareStatement(SQL);
            statement.execute();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Map<BigInteger, BigInteger> getMap(List<Object[]> prty_id_AND_etpt_id) {
        HashMap<BigInteger, BigInteger> prty_id_2_etpt_id = new HashMap<BigInteger, BigInteger>();
        for (Object[] row : prty_id_AND_etpt_id) {
            prty_id_2_etpt_id.put((BigInteger)row[0], (BigInteger)row[1]);
        }
        return prty_id_2_etpt_id;
    }

    public static void beforeUpgrade() {
        operationLog.info((Object)"ELNCollectionTypeMigration beforeUpgrade START");
        for (String experimentCode : experimentsOfTypeCollection) {
            ExperimentType experimentType;
            Set<ExperimentType> experimentTypes = ELNCollectionTypeMigration.getExperimentTypes(new String[]{experimentCode});
            if (experimentTypes.isEmpty() || (experimentType = experimentTypes.iterator().next()).getCode().equals(COLLECTION)) continue;
            Set<PropertyType> propertyTypes = ELNCollectionTypeMigration.getPropertyTypes(experimentType);
            Set<String> collectionPropertyTypes = ELNCollectionTypeMigration.getPropertyTypesCodes(ELNCollectionTypeMigration.getExperimentType(COLLECTION));
            HashSet<PropertyType> missingInCollection = new HashSet<PropertyType>();
            for (PropertyType propertyType : propertyTypes) {
                if (collectionPropertyTypes.contains(propertyType.getCode())) continue;
                missingInCollection.add(propertyType);
            }
            ELNCollectionTypeMigration.addMissingProperties(COLLECTION, missingInCollection);
            String COLLECTION_TYPE_ID = "SELECT id FROM experiment_types WHERE code = :code";
            BigInteger collectionTypeTechId = (BigInteger)ELNCollectionTypeMigration.executeNativeQuery("SELECT id FROM experiment_types WHERE code = :code", "code", COLLECTION).get(0);
            String EXPERIMENT_TYPE_ID = "SELECT exty_id FROM experiments_all WHERE code = :code";
            BigInteger experimentTypeTechId = (BigInteger)ELNCollectionTypeMigration.executeNativeQuery("SELECT exty_id FROM experiments_all WHERE code = :code", "code", experimentCode).get(0);
            String EXPERIMENT_PROPERTY_TYPE_IDS = "SELECT etpt.prty_id, etpt.id FROM experiment_type_property_types etpt WHERE etpt.exty_id = :exty_id";
            Map<BigInteger, BigInteger> collection_prty_id_2_etpt_id = ELNCollectionTypeMigration.getMap(ELNCollectionTypeMigration.executeNativeQuery("SELECT etpt.prty_id, etpt.id FROM experiment_type_property_types etpt WHERE etpt.exty_id = :exty_id", "exty_id", collectionTypeTechId));
            Map<BigInteger, BigInteger> experiment_prty_id_2_etpt_id = ELNCollectionTypeMigration.getMap(ELNCollectionTypeMigration.executeNativeQuery("SELECT etpt.prty_id, etpt.id FROM experiment_type_property_types etpt WHERE etpt.exty_id = :exty_id", "exty_id", experimentTypeTechId));
            for (BigInteger propertyTechId : experiment_prty_id_2_etpt_id.keySet()) {
                BigInteger oldAssignment = experiment_prty_id_2_etpt_id.get(propertyTechId);
                BigInteger newAssignment = collection_prty_id_2_etpt_id.get(propertyTechId);
                String UPDATE_PROPERTY_ASSIGNMENT = "UPDATE experiment_properties SET etpt_id = :new_etpt_id WHERE etpt_id = :old_etpt_id";
                operationLog.info((Object)("ELNCollectionTypeMigration - Swap for property tech id : " + propertyTechId + " : " + oldAssignment + " <> " + newAssignment));
                ELNCollectionTypeMigration.executeNativeUpdate("UPDATE experiment_properties SET etpt_id = :new_etpt_id WHERE etpt_id = :old_etpt_id", "old_etpt_id", oldAssignment, "new_etpt_id", newAssignment);
            }
            String UPDATE_TYPE = "UPDATE experiments_all SET exty_id = :exty_id WHERE code = :code";
            ELNCollectionTypeMigration.executeNativeUpdate("UPDATE experiments_all SET exty_id = :exty_id WHERE code = :code", "exty_id", collectionTypeTechId, "code", experimentCode);
            operationLog.info((Object)("ELNCollectionTypeMigration -  Update for : " + experimentCode + " : exty_id : " + collectionTypeTechId));
        }
        for (Map.Entry entry : PROPERTY_UPDATES_MAP.entrySet()) {
            operationLog.info((Object)("Going to Execute PROPERTY_UPDATE: " + (String)entry.getKey()));
            String query = String.format("UPDATE property_types SET code = '%s' WHERE code = '%s' and (select count(*) from property_types where code = '%s') = 0 and (select count(*) from core_plugins where name = 'eln-lims') > 0;", entry.getValue(), entry.getKey(), entry.getValue());
            ELNCollectionTypeMigration.executeNativeUpdate(query, null, null, null, null);
            operationLog.info((Object)"PROPERTY_UPDATE DONE");
        }
        operationLog.info((Object)"ELNCollectionTypeMigration beforeUpgrade END");
    }

    public static void afterUpgrade() {
        operationLog.info((Object)"ELNCollectionTypeMigration afterUpgrade START");
        for (String WIDGET_POST_UPDATE : WIDGET_POST_UPDATES) {
            operationLog.info((Object)("Going to Execute WIDGET_POST_UPDATES: " + WIDGET_POST_UPDATE));
            ELNCollectionTypeMigration.executeNativeUpdate(WIDGET_POST_UPDATE);
            operationLog.info((Object)"WIDGET_POST_UPDATE DONE");
        }
        operationLog.info((Object)"ELNCollectionTypeMigration afterUpgrade END");
    }
}

