/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.hotfix;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.update.SampleUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.IApplicationServerInternalApi;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOFactory;
import ch.systemsx.cisd.openbis.generic.server.hotfix.ELNAnnotationsMigration;
import ch.systemsx.cisd.openbis.generic.server.hotfix.ELNCollectionTypeMigration;
import ch.systemsx.cisd.openbis.generic.shared.dto.CorePluginPE;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ELNFixes {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ELNAnnotationsMigration.class);
    private static final String STORAGE_VALIDATION_LEVEL_PROPERTY_CODE = "$STORAGE.STORAGE_VALIDATION_LEVEL";
    private static final String STORAGE_VALIDATION_LEVEL_DEFAULT_VALUE = "RACK";
    private static final String NAME_PROPERTY_CODE = "$NAME";
    private static final String MULTI_GROUP_CONFIG_KEY = "user-management-config-file-path";
    private static final String MULTI_GROUP_SPACES = "SELECT COUNT(*) > 0 FROM spaces WHERE code LIKE '%_ELN_SETTINGS'";

    public static void beforeUpgrade() throws Exception {
        operationLog.info((Object)"ELNFixes beforeUpgrade START");
        IApplicationServerInternalApi api = CommonServiceProvider.getApplicationServerApi();
        String sessionToken = api.loginAsSystem();
        ELNFixes.storageValidationLevelFix(sessionToken, api);
        ELNFixes.nameNoRTFFix(sessionToken, api);
        operationLog.info((Object)"ELNFixes beforeUpgrade FINISH");
    }

    private static void storageValidationLevelFix(String sessionToken, IApplicationServerInternalApi api) {
        SampleSearchCriteria criteria = new SampleSearchCriteria();
        criteria.withType().withCode().thatEquals("STORAGE");
        SampleFetchOptions options = new SampleFetchOptions();
        options.withProperties();
        SearchResult storages = api.searchSamples(sessionToken, criteria, options);
        ArrayList<SampleUpdate> storageUpdates = new ArrayList<SampleUpdate>();
        for (Sample storage : storages.getObjects()) {
            if (storage.getProperty(STORAGE_VALIDATION_LEVEL_PROPERTY_CODE) != null && !storage.getProperty(STORAGE_VALIDATION_LEVEL_PROPERTY_CODE).isEmpty()) continue;
            SampleUpdate storageUpdate = new SampleUpdate();
            storageUpdate.setSampleId((ISampleId)storage.getPermId());
            storageUpdate.setProperty(STORAGE_VALIDATION_LEVEL_PROPERTY_CODE, STORAGE_VALIDATION_LEVEL_DEFAULT_VALUE);
            storageUpdates.add(storageUpdate);
        }
        if (!storageUpdates.isEmpty()) {
            api.updateSamples(sessionToken, storageUpdates);
        }
        operationLog.info((Object)("ELNFixes storageValidationLevelFix: " + storageUpdates.size()));
    }

    private static void nameNoRTFFix(String sessionToken, IApplicationServerInternalApi api) {
        SampleSearchCriteria criteria = new SampleSearchCriteria();
        criteria.withStringProperty(NAME_PROPERTY_CODE).thatContains("<");
        criteria.withType().withCode().thatEquals("ENTRY");
        SampleFetchOptions options = new SampleFetchOptions();
        options.withProperties();
        SearchResult namesRTF = api.searchSamples(sessionToken, criteria, options);
        ArrayList<SampleUpdate> nameUpdates = new ArrayList<SampleUpdate>();
        for (Sample nameRTF : namesRTF.getObjects()) {
            SampleUpdate nameUpdate = new SampleUpdate();
            nameUpdate.setSampleId((ISampleId)nameRTF.getPermId());
            nameUpdate.setProperty(NAME_PROPERTY_CODE, nameRTF.getProperty(NAME_PROPERTY_CODE).replaceAll("(<([^>]+)>)", ""));
            nameUpdates.add(nameUpdate);
        }
        if (!nameUpdates.isEmpty()) {
            api.updateSamples(sessionToken, nameUpdates);
        }
        operationLog.info((Object)("ELNFixes nameNoRTFFix: " + nameUpdates.size()));
    }

    public static boolean isELNInstalled() {
        DAOFactory daoFactory = (DAOFactory)CommonServiceProvider.getApplicationContext().getBean("dao-factory");
        List<CorePluginPE> elnLims = daoFactory.getCorePluginDAO().listCorePluginsByName("eln-lims");
        return elnLims != null && elnLims.size() > 0;
    }

    public static boolean isMultiGroup() {
        List isMultiGroupSpaces = ELNCollectionTypeMigration.executeNativeQuery(MULTI_GROUP_SPACES);
        String isMultiGroupProperty = ELNFixes.getProperty(MULTI_GROUP_CONFIG_KEY);
        return (Boolean)isMultiGroupSpaces.get(0) != false || isMultiGroupProperty != null;
    }

    static String getProperty(String key) {
        ExposablePropertyPlaceholderConfigurer configurer = (ExposablePropertyPlaceholderConfigurer)CommonServiceProvider.tryToGetBean("propertyConfigurer");
        return configurer.getResolvedProps().getProperty(key);
    }
}

