/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class MasterDataRegistrationHelper {
    private static Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, MasterDataRegistrationHelper.class);
    private File masterDataFolder;

    public MasterDataRegistrationHelper(Collection<?> systemPaths) {
        for (Object systemPath : systemPaths) {
            String systemPathString;
            if (systemPath == null || !(systemPathString = String.valueOf(systemPath)).contains("core-plugins")) continue;
            this.masterDataFolder = new File(new File(systemPathString), "master-data");
            if (!this.masterDataFolder.exists()) {
                throw new IllegalArgumentException("Folder does not exist: " + this.masterDataFolder.getAbsolutePath());
            }
            if (this.masterDataFolder.isFile()) {
                throw new IllegalArgumentException("Is not a folder but a file: " + this.masterDataFolder.getAbsolutePath());
            }
            operationLog.info((Object)("Master data folder: " + this.masterDataFolder.getAbsolutePath()));
            return;
        }
        throw new IllegalArgumentException("Does not contain path to the core plugin: " + systemPaths);
    }

    public List<byte[]> listXlsByteArrays() {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (File file : this.masterDataFolder.listFiles()) {
            String name = file.getName();
            if (!name.endsWith(".xls") && !name.endsWith(".xlsx")) continue;
            operationLog.info((Object)("load master data " + file.getName()));
            result.add(FileUtilities.loadToByteArray((File)file));
        }
        return result;
    }

    public List<byte[]> getByteArray(String findName) {
        for (File file : this.masterDataFolder.listFiles()) {
            String name = file.getName();
            if (!name.equals(findName)) continue;
            operationLog.info((Object)("load master data " + file.getName()));
            return Arrays.asList(new byte[][]{FileUtilities.loadToByteArray((File)file)});
        }
        return null;
    }

    public List<byte[]> listCsvByteArrays() throws IOException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (File file : this.masterDataFolder.listFiles()) {
            String name = file.getName();
            if (!name.endsWith(".csv")) continue;
            operationLog.info((Object)("load master data " + file.getName()));
            result.add(Files.readAllBytes(file.toPath()));
        }
        return result;
    }

    public Map<String, String> getAllScripts() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        File scriptsFolder = new File(this.masterDataFolder, "scripts");
        if (scriptsFolder.isDirectory()) {
            this.gatherScripts(result, scriptsFolder, scriptsFolder);
        }
        return result;
    }

    private void gatherScripts(Map<String, String> scripts, File rootFolder, File file) {
        if (file.isFile()) {
            String scriptPath = FileUtilities.getRelativeFilePath((File)rootFolder, (File)file);
            scripts.put(scriptPath, FileUtilities.loadToString((File)file));
            operationLog.info((Object)("Script " + scriptPath + " loaded"));
        }
        if (file.isDirectory()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                this.gatherScripts(scripts, rootFolder, child);
            }
        }
    }
}

