/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl;

import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.DataType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IAbstractType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IDataSetType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IDataSetTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IEntityType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IExperimentType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IExperimentTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IExternalDataManagementSystemImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IFileFormatType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IFileFormatTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IMasterDataRegistrationTransaction;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IMaterialType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IMaterialTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IPropertyAssignment;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IPropertyAssignmentImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IPropertyType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IPropertyTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.ISampleType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.ISampleTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IScript;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IScriptImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IVocabulary;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IVocabularyImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IVocabularyTerm;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IVocabularyTermImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.DataSetType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.DataSetTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.DataSetTypeWrapper;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.EncapsulatedCommonServer;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ExperimentType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ExperimentTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ExperimentTypeWrapper;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ExternalDataManagementSystemImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ExternalDataManagementSystemWrapper;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.FileFormatType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.FileFormatTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.FileFormatTypeWrapper;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MasterDataTransactionErrors;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MaterialType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MaterialTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MaterialTypeWrapper;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.PropertyAssignment;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.PropertyAssignmentImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.PropertyAssignmentWrapper;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.PropertyType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.PropertyTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.PropertyTypeWrapper;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.SampleType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.SampleTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.SampleTypeWrapper;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.Script;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ScriptImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ScriptWrapper;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.Vocabulary;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.VocabularyImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.VocabularyTermImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.VocabularyWrapper;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MasterDataRegistrationTransaction
implements IMasterDataRegistrationTransaction {
    private final EncapsulatedCommonServer commonServer;
    private final List<ExperimentType> createdExperimentTypes = new ArrayList<ExperimentType>();
    private final List<SampleType> createdSampleTypes = new ArrayList<SampleType>();
    private final List<DataSetType> createdDataSetTypes = new ArrayList<DataSetType>();
    private final List<Script> createdScripts = new ArrayList<Script>();
    private final List<MaterialType> createdMaterialTypes = new ArrayList<MaterialType>();
    private final List<PropertyType> createdPropertyTypes = new ArrayList<PropertyType>();
    private final List<FileFormatType> createdFileTypes = new ArrayList<FileFormatType>();
    private final List<Vocabulary> createdVocabularies = new ArrayList<Vocabulary>();
    private final Map<Long, List<VocabularyTerm>> createdVocabularyTerms = new HashMap<Long, List<VocabularyTerm>>();
    private final List<VocabularyTermImmutable> updatedVocabularyTerms = new ArrayList<VocabularyTermImmutable>();
    private final List<PropertyAssignment> createdAssignments = new ArrayList<PropertyAssignment>();
    private final List<ExternalDataManagementSystem> createdExternalDataManagementSystems = new ArrayList<ExternalDataManagementSystem>();
    private final MasterDataTransactionErrors transactionErrors = new MasterDataTransactionErrors();

    public MasterDataRegistrationTransaction(EncapsulatedCommonServer commonServer) {
        this.commonServer = commonServer;
    }

    public MasterDataTransactionErrors getTransactionErrors() {
        return this.transactionErrors;
    }

    public boolean hasErrors() {
        return this.transactionErrors.hasErrors();
    }

    @Override
    public IExperimentType createNewExperimentType(String code) {
        ExperimentType experimentType = new ExperimentType(code);
        this.createdExperimentTypes.add(experimentType);
        return experimentType;
    }

    @Override
    public IExperimentTypeImmutable getExperimentType(String code) {
        return this.findTypeForCode(this.commonServer.listExperimentTypes(), code);
    }

    @Override
    public IExperimentType getOrCreateNewExperimentType(String code) {
        IExperimentTypeImmutable experimentType = this.getExperimentType(code);
        if (experimentType != null) {
            return new ExperimentTypeWrapper((ExperimentTypeImmutable)experimentType);
        }
        return this.createNewExperimentType(code);
    }

    @Override
    public List<IExperimentTypeImmutable> listExperimentTypes() {
        return this.commonServer.listExperimentTypes();
    }

    @Override
    public ISampleType createNewSampleType(String code) {
        SampleType sampleType = new SampleType(code);
        this.createdSampleTypes.add(sampleType);
        return sampleType;
    }

    @Override
    public ISampleTypeImmutable getSampleType(String code) {
        return this.findTypeForCode(this.commonServer.listSampleTypes(), code);
    }

    @Override
    public ISampleType getOrCreateNewSampleType(String code) {
        ISampleTypeImmutable sampleType = this.getSampleType(code);
        if (sampleType != null) {
            return new SampleTypeWrapper((SampleTypeImmutable)sampleType);
        }
        return this.createNewSampleType(code);
    }

    @Override
    public List<ISampleTypeImmutable> listSampleTypes() {
        return this.commonServer.listSampleTypes();
    }

    @Override
    public IDataSetType createNewDataSetType(String code) {
        DataSetType dataSetType = new DataSetType(code);
        this.createdDataSetTypes.add(dataSetType);
        return dataSetType;
    }

    @Override
    public IDataSetTypeImmutable getDataSetType(String code) {
        return this.findTypeForCode(this.commonServer.listDataSetTypes(), code);
    }

    @Override
    public IDataSetType getOrCreateNewDataSetType(String code) {
        IDataSetTypeImmutable dataSetType = this.getDataSetType(code);
        if (dataSetType != null) {
            return new DataSetTypeWrapper((DataSetTypeImmutable)dataSetType);
        }
        return this.createNewDataSetType(code);
    }

    @Override
    public List<IDataSetTypeImmutable> listDataSetTypes() {
        return this.commonServer.listDataSetTypes();
    }

    @Override
    public IScriptImmutable getScript(String code) {
        return this.findTypeForCode(this.commonServer.listScripts(), code);
    }

    @Override
    public IScript getOrCreateNewScript(String code) {
        IScriptImmutable script = this.getScript(code);
        if (script != null) {
            return new ScriptWrapper((ScriptImmutable)script);
        }
        return this.createNewScript();
    }

    private IScript createNewScript() {
        Script script = new Script();
        this.createdScripts.add(script);
        return script;
    }

    @Override
    public List<IScriptImmutable> listScripts() {
        return this.commonServer.listScripts();
    }

    @Override
    public IMaterialType createNewMaterialType(String code) {
        MaterialType materialType = new MaterialType(code);
        this.createdMaterialTypes.add(materialType);
        return materialType;
    }

    @Override
    public IMaterialTypeImmutable getMaterialType(String code) {
        return this.findTypeForCode(this.commonServer.listMaterialTypes(), code);
    }

    @Override
    public IMaterialType getOrCreateNewMaterialType(String code) {
        IMaterialTypeImmutable materialType = this.getMaterialType(code);
        if (materialType != null) {
            return new MaterialTypeWrapper((MaterialTypeImmutable)materialType);
        }
        return this.createNewMaterialType(code);
    }

    @Override
    public List<IMaterialTypeImmutable> listMaterialTypes() {
        return this.commonServer.listMaterialTypes();
    }

    @Override
    public IFileFormatType createNewFileFormatType(String code) {
        FileFormatType fileFormatType = new FileFormatType(code);
        this.createdFileTypes.add(fileFormatType);
        return fileFormatType;
    }

    @Override
    public IFileFormatTypeImmutable getFileFormatType(String code) {
        return this.findTypeForCode(this.commonServer.listFileFormatTypes(), code);
    }

    @Override
    public IFileFormatType getOrCreateNewFileFormatType(String code) {
        IFileFormatTypeImmutable fileFormatType = this.getFileFormatType(code);
        if (fileFormatType != null) {
            return new FileFormatTypeWrapper((FileFormatTypeImmutable)fileFormatType);
        }
        return this.createNewFileFormatType(code);
    }

    @Override
    public List<IFileFormatTypeImmutable> listFileFormatTypes() {
        return this.commonServer.listFileFormatTypes();
    }

    @Override
    public IPropertyType createNewPropertyType(String code, DataType dataType) {
        PropertyType propertyType = new PropertyType(code, dataType);
        this.createdPropertyTypes.add(propertyType);
        return propertyType;
    }

    @Override
    public IPropertyTypeImmutable getPropertyType(String code) {
        List<IPropertyTypeImmutable> propertyTypes = this.commonServer.listPropertyTypes();
        for (IPropertyTypeImmutable propertyType : propertyTypes) {
            String fullCode = (propertyType.isManagedInternally() ? "$" : "") + code;
            if (!propertyType.getCode().equalsIgnoreCase(fullCode)) continue;
            return propertyType;
        }
        return null;
    }

    @Override
    public IPropertyType getOrCreateNewPropertyType(String code, DataType dataType) {
        IPropertyTypeImmutable propertyType = this.getPropertyType(code);
        if (propertyType != null) {
            return new PropertyTypeWrapper((PropertyTypeImmutable)propertyType);
        }
        return this.createNewPropertyType(code, dataType);
    }

    @Override
    public List<IPropertyTypeImmutable> listPropertyTypes() {
        return this.commonServer.listPropertyTypes();
    }

    @Override
    public IPropertyAssignment assignPropertyType(IEntityType entityType, IPropertyTypeImmutable propertyType) {
        EntityKind entityKind = EntityKind.valueOf((String)entityType.getEntityKind().name());
        IPropertyAssignmentImmutable assigment = this.findAssignment(entityType, propertyType);
        if (assigment != null) {
            return new PropertyAssignmentWrapper((PropertyAssignmentImmutable)assigment);
        }
        return this.createAssignment(entityKind, entityType, propertyType);
    }

    private <T extends IAbstractType> T findTypeForCode(List<T> types, String code) {
        for (IAbstractType type : types) {
            if (!type.getCode().equalsIgnoreCase(code)) continue;
            return (T)type;
        }
        return null;
    }

    private IPropertyAssignmentImmutable findAssignment(IEntityType entityType, IPropertyTypeImmutable propertyType) {
        for (IPropertyAssignmentImmutable assignment : this.listPropertyAssignments()) {
            if (!assignment.getEntityKind().equals(entityType.getEntityKind()) || !assignment.getEntityTypeCode().equalsIgnoreCase(entityType.getCode()) || !assignment.getPropertyTypeCode().equalsIgnoreCase(propertyType.getCode())) continue;
            return assignment;
        }
        return null;
    }

    private IVocabularyImmutable findVocabularyForCode(List<IVocabularyImmutable> vocabularies, String code) {
        for (IVocabularyImmutable vocabulary : vocabularies) {
            String fullCode = (vocabulary.isManagedInternally() ? "$" : "") + code;
            if (!vocabulary.getCode().equalsIgnoreCase(fullCode)) continue;
            return vocabulary;
        }
        return null;
    }

    private PropertyAssignment createAssignment(EntityKind entityKind, IEntityType type, IPropertyTypeImmutable propertyType) {
        String propTypeCode = propertyType.getCode();
        if (!CodeConverter.isInternalNamespace(propTypeCode) && propertyType.isManagedInternally()) {
            propTypeCode = CodeConverter.tryToBusinessLayer(propTypeCode, true);
        }
        PropertyAssignment assignment = new PropertyAssignment(entityKind, type.getCode(), propTypeCode);
        this.createdAssignments.add(assignment);
        return assignment;
    }

    @Override
    public List<IPropertyAssignmentImmutable> listPropertyAssignments() {
        return this.commonServer.listPropertyAssignments();
    }

    @Override
    public IVocabularyTerm createNewVocabularyTerm(String code) {
        return new VocabularyTerm(code);
    }

    @Override
    public IVocabulary createNewVocabulary(String code) {
        Vocabulary vocabulary = new Vocabulary(code);
        this.createdVocabularies.add(vocabulary);
        return vocabulary;
    }

    @Override
    public IVocabularyTerm getVocabularyTerm(IVocabularyImmutable vocabulary, String vocabularyTermCode) {
        List<IVocabularyTermImmutable> terms = vocabulary.getTerms();
        for (IVocabularyTermImmutable term : terms) {
            if (!vocabularyTermCode.equalsIgnoreCase(term.getCode())) continue;
            return new VocabularyTerm(((VocabularyTermImmutable)term).getVocabularyTerm());
        }
        throw new IllegalArgumentException("Vocabulary " + vocabulary.getCode() + " has no term " + vocabularyTermCode.toUpperCase() + ".");
    }

    @Override
    public void updateVocabularyTerm(IVocabularyTerm term) {
        VocabularyTermImmutable t = (VocabularyTermImmutable)((Object)term);
        if (t.getVocabularyTerm().getId() != null) {
            this.updatedVocabularyTerms.add(t);
        }
    }

    @Override
    public IVocabularyImmutable getVocabulary(String code) {
        return this.findVocabularyForCode(this.commonServer.listVocabularies(), code);
    }

    @Override
    public IVocabulary getOrCreateNewVocabulary(String code) {
        IVocabularyImmutable vocabulary = this.getVocabulary(code);
        if (vocabulary != null) {
            return new VocabularyWrapper((VocabularyImmutable)vocabulary, this.createdVocabularyTerms);
        }
        return this.createNewVocabulary(code);
    }

    @Override
    public List<IVocabularyImmutable> listVocabularies() {
        return this.commonServer.listVocabularies();
    }

    @Override
    public IExternalDataManagementSystem createNewExternalDataManagementSystem(String code) {
        ExternalDataManagementSystem edms = new ExternalDataManagementSystem(code);
        this.createdExternalDataManagementSystems.add(edms);
        return edms;
    }

    @Override
    public IExternalDataManagementSystemImmutable getExternalDataManagementSystem(String code) {
        return this.commonServer.getExternalDataManagementSystem(code);
    }

    @Override
    public IExternalDataManagementSystem getOrCreateNewExternalDataManagementSystem(String code) {
        IExternalDataManagementSystemImmutable edms = this.getExternalDataManagementSystem(code);
        if (edms != null) {
            return new ExternalDataManagementSystemWrapper((ExternalDataManagementSystemImmutable)edms);
        }
        return this.createNewExternalDataManagementSystem(code);
    }

    @Override
    public List<IExternalDataManagementSystemImmutable> listExternalDataManagementSystems() {
        return this.commonServer.listExternalDataManagementSystems();
    }

    public void commit() {
        this.registerFileFormatTypes(this.createdFileTypes);
        this.registerVocabularies(this.createdVocabularies);
        this.addVocabularyTerms(this.createdVocabularyTerms);
        this.updateVocabularyTerms(this.updatedVocabularyTerms);
        this.registerScripts(this.createdScripts);
        this.registerExperimentTypes(this.createdExperimentTypes);
        this.registerSampleTypes(this.createdSampleTypes);
        this.registerDataSetTypes(this.createdDataSetTypes);
        this.registerMaterialTypes(this.createdMaterialTypes);
        this.registerPropertyTypes(this.createdPropertyTypes);
        this.registerPropertyAssignments(this.createdAssignments);
        this.registerExternalDataManagementSystems(this.createdExternalDataManagementSystems);
    }

    private void registerFileFormatTypes(List<FileFormatType> fileFormatTypes) {
        for (FileFormatType fileFormatType : fileFormatTypes) {
            try {
                this.commonServer.registerFileFormatType(fileFormatType);
            }
            catch (Exception ex) {
                this.transactionErrors.addTypeRegistrationError(ex, fileFormatType);
            }
        }
    }

    private void registerExperimentTypes(List<ExperimentType> experimentTypes) {
        for (ExperimentType experimentType : experimentTypes) {
            try {
                this.commonServer.registerExperimentType(experimentType);
            }
            catch (Exception ex) {
                this.transactionErrors.addTypeRegistrationError(ex, experimentType);
            }
        }
    }

    private void registerSampleTypes(List<SampleType> sampleTypes) {
        for (SampleType sampleType : sampleTypes) {
            try {
                this.commonServer.registerSampleType(sampleType);
            }
            catch (Exception ex) {
                this.transactionErrors.addTypeRegistrationError(ex, sampleType);
            }
        }
    }

    private void registerDataSetTypes(List<DataSetType> dataSetTypes) {
        for (DataSetType dataSetType : dataSetTypes) {
            try {
                this.commonServer.registerDataSetType(dataSetType);
            }
            catch (Exception ex) {
                this.transactionErrors.addTypeRegistrationError(ex, dataSetType);
            }
        }
    }

    private void registerScripts(List<Script> scripts) {
        for (Script script : scripts) {
            try {
                this.commonServer.registerScript(script);
            }
            catch (Exception ex) {
                this.transactionErrors.addTypeRegistrationError(ex, script);
            }
        }
    }

    private void registerMaterialTypes(List<MaterialType> materialTypes) {
        for (MaterialType materialType : materialTypes) {
            try {
                this.commonServer.registerMaterialType(materialType);
            }
            catch (Exception ex) {
                this.transactionErrors.addTypeRegistrationError(ex, materialType);
            }
        }
    }

    private void registerPropertyTypes(List<PropertyType> propertyTypes) {
        for (PropertyType propertyType : propertyTypes) {
            try {
                this.commonServer.registerPropertyType(propertyType);
            }
            catch (Exception ex) {
                this.transactionErrors.addTypeRegistrationError(ex, propertyType);
            }
        }
    }

    private void registerPropertyAssignments(List<PropertyAssignment> propertyAssigments) {
        for (PropertyAssignment assignment : propertyAssigments) {
            try {
                this.commonServer.registerPropertyAssignment(assignment);
            }
            catch (Exception ex) {
                this.transactionErrors.addPropertyAssignmentError(ex, assignment);
            }
        }
    }

    private void registerVocabularies(List<Vocabulary> vocabularies) {
        for (Vocabulary vocabulary : vocabularies) {
            try {
                this.commonServer.registerVocabulary(vocabulary);
            }
            catch (Exception ex) {
                this.transactionErrors.addVocabularyRegistrationError(ex, vocabulary);
            }
        }
    }

    private void addVocabularyTerms(Map<Long, List<VocabularyTerm>> terms) {
        Set<Map.Entry<Long, List<VocabularyTerm>>> entrySet = terms.entrySet();
        for (Map.Entry<Long, List<VocabularyTerm>> entry : entrySet) {
            Long vocaId = entry.getKey();
            List<VocabularyTerm> newTerms = entry.getValue();
            try {
                this.commonServer.addVocabularyTerms(vocaId, newTerms, null);
            }
            catch (Exception ex) {
                this.transactionErrors.addVocabularyTermsRegistrationError(ex, newTerms);
            }
        }
    }

    private void updateVocabularyTerms(List<VocabularyTermImmutable> terms) {
        for (VocabularyTermImmutable term : terms) {
            try {
                this.commonServer.update(term);
            }
            catch (Exception ex) {
                this.transactionErrors.updateVocabularyTermError(ex, term);
            }
        }
    }

    private void registerExternalDataManagementSystems(List<ExternalDataManagementSystem> edmss) {
        for (ExternalDataManagementSystem edms : edmss) {
            this.commonServer.createOrUpdateExternalDataManagementSystem(edms);
        }
    }
}

